/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.util;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IC2Items;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.item.IInventoryItem;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.TileEntitySecurityStation;
import pneumaticCraft.lib.Log;

public class PneumaticCraftUtils {
    private static Random rand = new Random();
    private static final List<Item> inventoryItemBlacklist = new ArrayList<Item>();
    public static double[] sin = new double[500];
    public static double[] cos = new double[500];
    public static double[] tan = new double[500];
    public static final int circlePoints = 500;

    public static ForgeDirection getDirectionFacing(EntityLivingBase entity, boolean includeUpAndDown) {
        double yaw;
        for (yaw = (double)entity.field_70177_z; yaw < 0.0; yaw += 360.0) {
        }
        yaw %= 360.0;
        if (includeUpAndDown) {
            if (entity.field_70125_A > 45.0f) {
                return ForgeDirection.DOWN;
            }
            if (entity.field_70125_A < -45.0f) {
                return ForgeDirection.UP;
            }
        }
        if (yaw < 45.0) {
            return ForgeDirection.SOUTH;
        }
        if (yaw < 135.0) {
            return ForgeDirection.WEST;
        }
        if (yaw < 225.0) {
            return ForgeDirection.NORTH;
        }
        if (yaw < 315.0) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.SOUTH;
    }

    @SideOnly(value=Side.CLIENT)
    public static double rotateMatrixByMetadata(int metadata) {
        double metaRotation;
        ForgeDirection facing = ForgeDirection.getOrientation((int)(metadata & 7));
        switch (facing) {
            case UP: {
                metaRotation = 0.0;
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)0.0, (double)-1.0, (double)-1.0);
                break;
            }
            case DOWN: {
                metaRotation = 0.0;
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)0.0, (double)-1.0, (double)1.0);
                break;
            }
            case NORTH: {
                metaRotation = 0.0;
                break;
            }
            case EAST: {
                metaRotation = 90.0;
                break;
            }
            case SOUTH: {
                metaRotation = 180.0;
                break;
            }
            default: {
                metaRotation = 270.0;
            }
        }
        GL11.glRotated((double)metaRotation, (double)0.0, (double)1.0, (double)0.0);
        return metaRotation;
    }

    public static List<String> convertStringIntoList(String text, int maxCharPerLine) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuilder output = new StringBuilder(text.length());
        ArrayList<String> textList = new ArrayList<String>();
        String color = "";
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (word.contains("\u00a7")) {
                for (int i = 0; i < word.length() - 1; ++i) {
                    if (!word.substring(i, i + 2).contains("\u00a7")) continue;
                    color = word.substring(i, i + 2);
                }
                lineLen -= 2;
            }
            if (lineLen + word.length() > maxCharPerLine || word.contains("\\n")) {
                word = word.replace("\\n", "");
                textList.add(output.toString());
                output.delete(0, output.length());
                output.append(color);
                lineLen = 0;
            } else if (lineLen > 0) {
                output.append(" ");
                ++lineLen;
            }
            output.append(word);
            lineLen += word.length();
        }
        textList.add(output.toString());
        return textList;
    }

    public static String convertTicksToMinutesAndSeconds(int ticks, boolean fraction) {
        String part = ticks % 20 * 5 + "";
        if (part.length() < 2) {
            part = "0" + part;
        }
        if ((ticks /= 20) < 60) {
            return ticks + (fraction ? "." + part : "") + "s";
        }
        return ticks / 60 + "m " + ticks % 60 + "s";
    }

    public static String convertAmountToString(int amount) {
        if (amount < 1000) {
            return amount + "";
        }
        return amount / 1000 + "k";
    }

    public static String roundNumberTo(double value, int decimals) {
        double ret = PneumaticCraftUtils.roundNumberToDouble(value, decimals);
        if (decimals == 0) {
            return "" + (int)ret;
        }
        return "" + ret;
    }

    public static double roundNumberToDouble(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static String roundNumberTo(float value, int decimals) {
        return "" + (double)Math.round((double)value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static boolean areFloatsEqual(float f1, float f2) {
        return PneumaticCraftUtils.areFloatsEqual(f1, f2, 0.001f);
    }

    public static boolean areFloatsEqual(float f1, float f2, float maxDifference) {
        return Math.abs(f1 - f2) < maxDifference;
    }

    public static String getPartOfString(String string, int progress, int maxProgress) {
        if (progress > maxProgress) {
            return string;
        }
        return string.substring(0, string.length() * progress / maxProgress);
    }

    public static int getMaxItemNameLength(ItemStack[] inventoryStacks) {
        int maxLength = 0;
        for (ItemStack iStack : inventoryStacks) {
            if (iStack == null) continue;
            maxLength = Math.max(maxLength, iStack.func_82833_r().length());
        }
        return maxLength;
    }

    public static void bubbleSortOnCharIndex(ItemStack[] stackArray, int charIndex) {
        for (int i = 0; i < stackArray.length - 1; ++i) {
            for (int j = 1; j < stackArray.length - i; ++j) {
                boolean lowerStackTooShort;
                boolean higherStackTooShort;
                boolean bl = stackArray[j - 1] != null ? stackArray[j - 1].func_82833_r().length() <= charIndex : (higherStackTooShort = true);
                boolean bl2 = stackArray[j] != null ? stackArray[j].func_82833_r().length() <= charIndex : (lowerStackTooShort = true);
                if (stackArray[j - 1] != null && (stackArray[j] == null || !lowerStackTooShort && !higherStackTooShort && stackArray[j - 1].func_82833_r().charAt(charIndex) <= stackArray[j].func_82833_r().charAt(charIndex))) continue;
                ItemStack temp = stackArray[j - 1];
                stackArray[j - 1] = stackArray[j];
                stackArray[j] = temp;
            }
        }
    }

    public static void sortStringArrayAlphabetically(String[] strings) {
        boolean notDone = true;
        while (notDone) {
            notDone = false;
            for (int j = 0; j < strings.length - 1; ++j) {
                if (strings[j].compareToIgnoreCase(strings[j + 1]) <= 0) continue;
                String temp = strings[j];
                strings[j] = strings[j + 1];
                strings[j + 1] = temp;
                notDone = true;
            }
        }
    }

    public static void sortCombineItemStacksAndToString(List<String> textList, ItemStack[] originalStacks) {
        ItemStack[] stacks = new ItemStack[originalStacks.length];
        for (int i = 0; i < originalStacks.length; ++i) {
            if (originalStacks[i] == null) continue;
            stacks[i] = originalStacks[i].func_77946_l();
        }
        int maxItemNameLength = PneumaticCraftUtils.getMaxItemNameLength(stacks);
        for (int i = maxItemNameLength - 1; i >= 0; --i) {
            PneumaticCraftUtils.bubbleSortOnCharIndex(stacks, i);
        }
        int itemCount = 0;
        ItemStack oldItemStack = null;
        List<ItemStack> oldInventoryItems = null;
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            if (oldItemStack == null || !stack.func_77969_a(oldItemStack) || oldInventoryItems != null && oldInventoryItems.size() > 0) {
                if (oldItemStack != null) {
                    textList.add("-" + PneumaticCraftUtils.convertAmountToString(itemCount) + " " + oldItemStack.func_82833_r());
                }
                if (oldInventoryItems != null) {
                    int oldSize = textList.size();
                    PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, oldInventoryItems.toArray(new ItemStack[oldInventoryItems.size()]));
                    for (int i = oldSize; i < textList.size(); ++i) {
                        textList.set(i, ">> " + textList.get(i));
                    }
                }
                oldItemStack = stack;
                itemCount = stack.field_77994_a;
            } else {
                itemCount += stack.field_77994_a;
            }
            oldInventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        }
        if (itemCount > 0 && oldItemStack != null) {
            textList.add("-" + PneumaticCraftUtils.convertAmountToString(itemCount) + " " + oldItemStack.func_82833_r());
            if (oldInventoryItems != null) {
                int oldSize = textList.size();
                PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, oldInventoryItems.toArray(new ItemStack[oldInventoryItems.size()]));
                for (int i = oldSize; i < textList.size(); ++i) {
                    textList.set(i, ">> " + textList.get(i));
                }
            }
        }
    }

    public static List<ItemStack> getStacksInItem(ItemStack item) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (item.func_77973_b() instanceof IInventoryItem && !inventoryItemBlacklist.contains(item.func_77973_b())) {
            try {
                ((IInventoryItem)item.func_77973_b()).getStacksInItem(item, items);
            }
            catch (Throwable e) {
                Log.error("An InventoryItem crashed:");
                e.printStackTrace();
                inventoryItemBlacklist.add(item.func_77973_b());
            }
        } else {
            Iterator<IInventoryItem> iterator = PneumaticCraftAPIHandler.getInstance().inventoryItems.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().getStacksInItem(item, items);
                }
                catch (Throwable e) {
                    Log.error("An InventoryItem crashed:");
                    e.printStackTrace();
                    iterator.remove();
                }
            }
        }
        return items;
    }

    public static int getRedstoneLevel(World world, int x, int y, int z) {
        int analogLevel = world.func_94577_B(x, y, z);
        if (analogLevel == 0 && world.func_72864_z(x, y, z)) {
            return 15;
        }
        return analogLevel;
    }

    @Optional.Method(modid="IC2")
    public static boolean isIC2Item(Item id, String ic2ItemKey) {
        ItemStack ic2Item = IC2Items.getItem((String)ic2ItemKey);
        return ic2Item != null && ic2Item.func_77973_b() == id;
    }

    @Optional.Method(modid="IC2")
    public static boolean isIC2Upgrade(Item id) {
        return PneumaticCraftUtils.isIC2Item(id, "overclockerUpgrade") || PneumaticCraftUtils.isIC2Item(id, "transformerUpgrade") || PneumaticCraftUtils.isIC2Item(id, "energyStorageUpgrade");
    }

    public static ItemStack getBuildcraftItemStack(EnumBuildcraftModule module, String itemName) {
        try {
            Class<?> buildcraftItems = Class.forName(PneumaticCraftUtils.getItemClassForModule(module));
            Object ret = buildcraftItems.getField(itemName).get(null);
            if (ret instanceof Item) {
                return new ItemStack((Item)ret);
            }
            if (ret instanceof Block) {
                return new ItemStack((Block)ret);
            }
            return null;
        }
        catch (Exception e) {
            Log.warning("Tried to retrieve a Buildcraft item which failed. Tried to retrieve: " + itemName + ", from module " + PneumaticCraftUtils.getItemClassForModule(module));
            return null;
        }
    }

    private static String getItemClassForModule(EnumBuildcraftModule module) {
        switch (module) {
            case BUILDERS: {
                return "buildcraft.BuildCraftBuilders";
            }
            case CORE: {
                return "buildcraft.BuildCraftCore";
            }
            case ENERGY: {
                return "buildcraft.BuildCraftEnergy";
            }
            case FACTORY: {
                return "buildcraft.BuildCraftFactory";
            }
            case SILICON: {
                return "buildcraft.BuildCraftSilicon";
            }
            case TRANSPORT: {
                return "buildcraft.BuildCraftTransport";
            }
        }
        return "";
    }

    public static boolean isRenderIDCamo(int renderID) {
        return PneumaticCraftAPIHandler.getInstance().concealableRenderIds.contains(renderID);
    }

    public static int getProtectingSecurityStations(World world, int x, int y, int z, EntityPlayer player, boolean showRangeLines, boolean placementRange) {
        int blockingStations = 0;
        for (TileEntitySecurityStation station : PneumaticCraftUtils.getSecurityStations(world, x, y, z, placementRange)) {
            if (station.doesAllowPlayer(player)) continue;
            ++blockingStations;
            if (!showRangeLines) continue;
            station.showRangeLines();
        }
        return blockingStations;
    }

    public static Iterable<TileEntitySecurityStation> getSecurityStations(final World world, final int x, final int y, final int z, final boolean placementRange) {
        return new Iterable<TileEntitySecurityStation>(){

            @Override
            public Iterator<TileEntitySecurityStation> iterator() {
                return new Iterator<TileEntitySecurityStation>(){
                    private final int range;
                    private int i;
                    private int j;
                    private TileEntitySecurityStation curStation;
                    private int chunkTileEntityIndex;
                    {
                        this.range = placementRange ? 32 : 16;
                        this.i = x - this.range;
                        this.j = z - this.range;
                        this.chunkTileEntityIndex = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.curStation != null) {
                            return true;
                        }
                        while (this.i <= x + this.range) {
                            while (this.j <= z + this.range) {
                                Chunk chunk = world.func_72938_d(this.i, this.j);
                                int curIndex = 0;
                                for (TileEntity te : chunk.field_150816_i.values()) {
                                    TileEntitySecurityStation station;
                                    if (curIndex > this.chunkTileEntityIndex && te instanceof TileEntitySecurityStation && (station = (TileEntitySecurityStation)te).hasValidNetwork() && Math.abs(station.field_145851_c - x) <= station.getSecurityRange() + (placementRange ? 16 : 0) && Math.abs(station.field_145848_d - y) <= station.getSecurityRange() + (placementRange ? 16 : 0) && Math.abs(station.field_145849_e - z) <= station.getSecurityRange() + (placementRange ? 16 : 0)) {
                                        this.curStation = station;
                                        this.chunkTileEntityIndex = curIndex;
                                        return true;
                                    }
                                    ++curIndex;
                                }
                                this.chunkTileEntityIndex = -1;
                                this.j += 16;
                            }
                            this.j = z - this.range;
                            this.i += 16;
                        }
                        return false;
                    }

                    @Override
                    public TileEntitySecurityStation next() {
                        if (this.hasNext()) {
                            TileEntitySecurityStation station = this.curStation;
                            this.curStation = null;
                            return station;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static MovingObjectPosition getEntityLookedObject(EntityLivingBase entity) {
        return PneumaticCraftUtils.getEntityLookedObject(entity, 4.5f);
    }

    public static MovingObjectPosition getEntityLookedObject(EntityLivingBase entity, float maxDistance) {
        Pair<Vec3, Vec3> vecs = PneumaticCraftUtils.getStartAndEndLookVec(entity, maxDistance);
        return entity.field_70170_p.func_72933_a((Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
    }

    public static Pair<Vec3, Vec3> getStartAndEndLookVec(EntityLivingBase entity) {
        return PneumaticCraftUtils.getStartAndEndLookVec(entity, 4.5f);
    }

    public static Pair<Vec3, Vec3> getStartAndEndLookVec(EntityLivingBase entity, float maxDistance) {
        Vec3 entityVec = entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer ? Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + 1.62 - (double)entity.field_70129_M), (double)entity.field_70161_v) : Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e() - (double)entity.field_70129_M - (entity.func_70093_af() ? 0.08 : 0.0)), (double)entity.field_70161_v);
        Vec3 entityLookVec = entity.func_70676_i(1.0f);
        Vec3 maxDistVec = entityVec.func_72441_c(entityLookVec.field_72450_a * (double)maxDistance, entityLookVec.field_72448_b * (double)maxDistance, entityLookVec.field_72449_c * (double)maxDistance);
        return new ImmutablePair((Object)entityVec, (Object)maxDistVec);
    }

    public static ChunkPosition getEntityLookedBlock(EntityLivingBase entity, float maxDistance) {
        MovingObjectPosition hit = PneumaticCraftUtils.getEntityLookedObject(entity, maxDistance);
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return null;
        }
        return new ChunkPosition(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
    }

    public static boolean isEntityValidForFilter(String filter, Entity entity) {
        try {
            return PneumaticCraftUtils.isEntityValidForFilterUnsafe(filter, entity);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isEntityValidForFilterUnsafe(String filter, Entity entity) throws IllegalArgumentException {
        int i;
        if (filter == null) {
            return true;
        }
        if (StringUtils.countMatches((CharSequence)filter, (CharSequence)"(") != StringUtils.countMatches((CharSequence)filter, (CharSequence)")")) {
            throw new IllegalArgumentException("Not an equal amount of opening and closing braces");
        }
        String[] splits = filter.split("[(),]");
        for (i = 0; i < splits.length; ++i) {
            splits[i] = splits[i].trim();
        }
        if (!PneumaticCraftUtils.isEntityValidForName(splits[0], entity)) {
            return false;
        }
        for (i = 1; i < splits.length; ++i) {
            String[] modifier = splits[i].split("=");
            if (modifier.length == 2) {
                if (PneumaticCraftUtils.isEntityValidForModifier(modifier[0].trim(), modifier[1].trim(), entity)) continue;
                return false;
            }
            throw new IllegalArgumentException("No '=' sign in the modifier.");
        }
        return true;
    }

    private static boolean isEntityValidForModifier(String modifier, String value, Entity entity) throws IllegalArgumentException {
        if (modifier.equalsIgnoreCase("age")) {
            if (entity instanceof EntityAgeable) {
                if (value.equalsIgnoreCase("adult")) {
                    return ((EntityAgeable)entity).func_70874_b() >= 0;
                }
                if (value.equalsIgnoreCase("baby")) {
                    return ((EntityAgeable)entity).func_70874_b() < 0;
                }
                throw new IllegalArgumentException(value + " doesn't match 'adult'/'baby'.");
            }
            throw new IllegalArgumentException("This modifier can't be applied to this entity.");
        }
        if (modifier.equalsIgnoreCase("breedable")) {
            if (entity instanceof EntityAgeable) {
                if (value.equalsIgnoreCase("yes")) {
                    return ((EntityAgeable)entity).func_70874_b() == 0;
                }
                if (value.equalsIgnoreCase("no")) {
                    return ((EntityAgeable)entity).func_70874_b() != 0;
                }
                throw new IllegalArgumentException(value + " doesn't match 'yes'/'no'.");
            }
            throw new IllegalArgumentException("This modifier can't be applied to this entity.");
        }
        throw new IllegalArgumentException(modifier + " is not a valid modifier");
    }

    private static boolean isEntityValidForName(String filter, Entity entity) throws IllegalArgumentException {
        if (filter.equals("")) {
            return true;
        }
        if (filter.startsWith("@")) {
            filter = filter.substring(1);
            Class typeClass = null;
            if (filter.equals("mob")) {
                typeClass = EntityMob.class;
            } else if (filter.equals("animal")) {
                typeClass = EntityAnimal.class;
            } else if (filter.equals("living")) {
                typeClass = EntityLivingBase.class;
            } else if (filter.equals("player")) {
                typeClass = EntityPlayer.class;
            } else if (filter.equals("item")) {
                typeClass = EntityItem.class;
            } else if (filter.equals("minecart")) {
                typeClass = EntityMinecart.class;
            } else if (filter.equals("drone")) {
                typeClass = EntityDrone.class;
            }
            if (typeClass != null) {
                return typeClass.isAssignableFrom(entity.getClass());
            }
            throw new IllegalArgumentException(filter + " is not a valid entity type.");
        }
        try {
            String regex = filter.toLowerCase().replaceAll(".", "[$0]").replace("[*]", ".*");
            return entity.func_70005_c_().toLowerCase().matches(regex);
        }
        catch (PatternSyntaxException e) {
            return entity.func_70005_c_().toLowerCase().equals(filter.toLowerCase());
        }
    }

    public static Method getDeclaredMethodIncludingSupertype(Class clazz, String methodName, Class ... methodParms) {
        while (!clazz.equals(Object.class)) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, methodParms);
                return method;
            }
            catch (Exception exception) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static ItemStack exportStackToInventory(IInventory inv, ItemStack stack, ForgeDirection side) {
        return TileEntityHopper.func_145889_a((IInventory)inv, (ItemStack)stack, (int)side.ordinal());
    }

    public static ItemStack exportStackToInventory(TileEntity te, ItemStack stack, ForgeDirection side) {
        if (te instanceof IInventory) {
            return TileEntityHopper.func_145889_a((IInventory)((IInventory)te), (ItemStack)stack, (int)side.ordinal());
        }
        stack = ModInteractionUtils.getInstance().exportStackToTEPipe(te, stack, side);
        stack = ModInteractionUtils.getInstance().exportStackToBCPipe(te, stack, side);
        return stack;
    }

    public static boolean isOutputInventory(TileEntity te) {
        return te instanceof IInventory || ModInteractionUtils.getInstance().isBCPipe(te) || ModInteractionUtils.getInstance().isTEPipe(te);
    }

    public static Set<Integer> getAccessibleSlotsForInventoryAndSides(IInventory inventory, boolean[] accessibleSides) {
        HashSet<Integer> slots = new HashSet<Integer>();
        if (inventory instanceof ISidedInventory) {
            for (int i = 0; i < accessibleSides.length; ++i) {
                int[] accessibleSlots;
                if (!accessibleSides[i]) continue;
                for (int accessibleSlot : accessibleSlots = ((ISidedInventory)inventory).func_94128_d(i)) {
                    slots.add(accessibleSlot);
                }
            }
        } else {
            for (boolean bool : accessibleSides) {
                if (!bool) continue;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    slots.add(i);
                }
                break;
            }
        }
        return slots;
    }

    public static double distBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(PneumaticCraftUtils.distBetweenSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distBetweenSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0);
    }

    public static double distBetween(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static double distBetween(ChunkPosition pos, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween((double)pos.field_151329_a + 0.5, (double)pos.field_151327_b + 0.5, (double)pos.field_151328_c + 0.5, x, y, z);
    }

    public static double distBetween(ChunkPosition pos1, ChunkPosition pos2) {
        return PneumaticCraftUtils.distBetween(pos1, (double)pos2.field_151329_a + 0.5, (double)pos2.field_151327_b + 0.5, (double)pos2.field_151328_c + 0.5);
    }

    public static double distBetween(Vec3 vec, double x, double y, double z) {
        return PneumaticCraftUtils.distBetween(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, x, y, z);
    }

    public static double distBetween(Vec3 vec1, Vec3 vec2) {
        return PneumaticCraftUtils.distBetween(vec1, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean checkMeta, boolean checkNBT, boolean checkOreDict, boolean checkModSimilarity) {
        boolean metaSame;
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null && stack2 != null || stack1 != null && stack2 == null) {
            return false;
        }
        if (checkModSimilarity) {
            GameRegistry.UniqueIdentifier id1 = GameRegistry.findUniqueIdentifierFor((Item)stack1.func_77973_b());
            if (id1 == null || id1.modId == null) {
                return false;
            }
            String modId1 = id1.modId;
            GameRegistry.UniqueIdentifier id2 = GameRegistry.findUniqueIdentifierFor((Item)stack2.func_77973_b());
            if (id2 == null || id2.modId == null) {
                return false;
            }
            String modId2 = id2.modId;
            return modId1.equals(modId2);
        }
        if (checkOreDict) {
            return PneumaticCraftUtils.isSameOreDictStack(stack1, stack2);
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        boolean bl = metaSame = stack1.func_77960_j() == stack2.func_77960_j();
        boolean nbtSame = stack1.func_77942_o() ? stack1.func_77978_p().equals((Object)stack2.func_77978_p()) : !stack2.func_77942_o();
        return !(checkMeta && !metaSame || checkNBT && !nbtSame);
    }

    public static boolean isSameOreDictStack(ItemStack stack1, ItemStack stack2) {
        int[] oredictIds;
        for (int oredictId : oredictIds = OreDictionary.getOreIDs((ItemStack)stack1)) {
            ArrayList oreDictStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)oredictId));
            for (ItemStack oreDictStack : oreDictStacks) {
                if (!OreDictionary.itemMatches((ItemStack)oreDictStack, (ItemStack)stack2, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockLiquid(Block block) {
        return block instanceof BlockLiquid || block instanceof IFluidBlock;
    }

    public static String getOrientationName(ForgeDirection dir) {
        switch (dir) {
            case UP: {
                return "Top";
            }
            case DOWN: {
                return "Bottom";
            }
            case NORTH: {
                return "North";
            }
            case SOUTH: {
                return "South";
            }
            case EAST: {
                return "East";
            }
            case WEST: {
                return "West";
            }
        }
        return "Unknown";
    }

    public static void dropItemOnGround(ItemStack stack, World world, double x, double y, double z) {
        float dX = rand.nextFloat() * 0.8f + 0.1f;
        float dY = rand.nextFloat() * 0.8f + 0.1f;
        float dZ = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j()));
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
        entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        stack.field_77994_a = 0;
    }

    public static World getWorldForDimension(int dimension) {
        for (WorldServer w : MinecraftServer.func_71276_C().field_71305_c) {
            if (w.field_73011_w.field_76574_g != dimension) continue;
            return w;
        }
        return null;
    }

    public static TileEntity getTileEntity(ChunkPosition pos, int dimension) {
        World world = PneumaticCraftUtils.getWorldForDimension(dimension);
        if (world != null && world.func_72899_e(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) {
            return world.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        }
        return null;
    }

    public static EntityPlayer getPlayerFromId(String uuid) {
        for (EntityPlayer checkingPlayer : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!checkingPlayer.func_146103_bH().getId().toString().equals(uuid)) continue;
            return checkingPlayer;
        }
        return null;
    }

    public static EntityPlayer getPlayerFromName(String name) {
        for (EntityPlayer checkingPlayer : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            if (!checkingPlayer.func_146103_bH().getName().equals(name)) continue;
            return checkingPlayer;
        }
        return null;
    }

    public static boolean isPlayerOp(EntityPlayer player) {
        return player.func_70003_b(2, "PneumaticCraftIsPlayerOp");
    }

    private static MovingObjectPosition raytraceEntityBlocks(EntityLivingBase entity, double range) {
        Pair<Vec3, Vec3> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(entity, (float)range);
        return entity.field_70170_p.func_147447_a((Vec3)startAndEnd.getLeft(), (Vec3)startAndEnd.getRight(), false, false, true);
    }

    public static MovingObjectPosition getMouseOverServer(EntityLivingBase lookingEntity, double range) {
        MovingObjectPosition mop = PneumaticCraftUtils.raytraceEntityBlocks(lookingEntity, range);
        double d1 = range;
        Pair<Vec3, Vec3> startAndEnd = PneumaticCraftUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vec3 vec3 = (Vec3)startAndEnd.getLeft();
        if (mop != null) {
            d1 = mop.field_72307_f.func_72438_d(vec3);
        }
        Vec3 vec31 = lookingEntity.func_70040_Z();
        Vec3 vec32 = (Vec3)startAndEnd.getRight();
        Entity pointedEntity = null;
        Vec3 vec33 = null;
        float f1 = 1.0f;
        List list = lookingEntity.field_70170_p.func_72839_b((Entity)lookingEntity, lookingEntity.field_70121_D.func_72321_a(vec31.field_72450_a * range, vec31.field_72448_b * range, vec31.field_72449_c * range).func_72314_b((double)f1, (double)f1, (double)f1));
        double d2 = d1;
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L()) continue;
            float f2 = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
            if (axisalignedbb.func_72318_a(vec3)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity == entity.field_70154_o && !entity.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity;
                vec33 = movingobjectposition.field_72307_f;
                continue;
            }
            pointedEntity = entity;
            vec33 = movingobjectposition.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null && (d2 < d1 || mop == null)) {
            mop = new MovingObjectPosition(pointedEntity, vec33);
        }
        return mop;
    }

    static {
        for (int i = 0; i < 500; ++i) {
            double angle = Math.PI * 2 * (double)i / 500.0;
            PneumaticCraftUtils.sin[i] = Math.sin(angle);
            PneumaticCraftUtils.cos[i] = Math.cos(angle);
            PneumaticCraftUtils.tan[i] = Math.tan(angle);
        }
    }

    public static enum EnumBuildcraftModule {
        BUILDERS,
        CORE,
        ENERGY,
        FACTORY,
        SILICON,
        TRANSPORT;

    }
}

