/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.util;

import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidUtils {
    public static boolean tryInsertingLiquid(TileEntity te, ItemStack liquidContainer, boolean creative, List<ItemStack> returnedItems) {
        if (te instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)te;
            if (liquidContainer != null) {
                IFluidContainerItem container;
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)liquidContainer);
                if (fluid != null) {
                    fluid.amount = 1000;
                    if (fluidHandler.canFill(ForgeDirection.UNKNOWN, fluid.getFluid()) && fluidHandler.fill(ForgeDirection.UNKNOWN, fluid, false) == 1000) {
                        fluidHandler.fill(ForgeDirection.UNKNOWN, fluid, true);
                        if (!creative) {
                            FluidContainerRegistry.FluidContainerData[] allFluidData;
                            --liquidContainer.field_77994_a;
                            ItemStack returnedItem = null;
                            for (FluidContainerRegistry.FluidContainerData fluidData : allFluidData = FluidContainerRegistry.getRegisteredFluidContainerData()) {
                                if (!fluidData.filledContainer.func_77969_a(liquidContainer)) continue;
                                returnedItem = fluidData.emptyContainer;
                                break;
                            }
                            if (returnedItem != null) {
                                returnedItems.add(returnedItem.func_77946_l());
                            }
                        }
                        return true;
                    }
                } else if (liquidContainer.func_77973_b() instanceof IFluidContainerItem && (fluid = (container = (IFluidContainerItem)liquidContainer.func_77973_b()).getFluid(liquidContainer)) != null && fluidHandler.canFill(ForgeDirection.UNKNOWN, (fluid = fluid.copy()).getFluid()) && fluidHandler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount) {
                    ItemStack returnedItem = liquidContainer.func_77946_l();
                    returnedItem.field_77994_a = 1;
                    container.drain(returnedItem, fluid.amount, true);
                    fluidHandler.fill(ForgeDirection.UNKNOWN, fluid, true);
                    if (!creative) {
                        --liquidContainer.field_77994_a;
                        returnedItems.add(returnedItem.func_77946_l());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean tryExtractingLiquid(TileEntity te, ItemStack liquidContainer, List<ItemStack> returnedItems) {
        if (te instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)te;
            if (liquidContainer != null) {
                int containerCapacity = FluidContainerRegistry.getContainerCapacity((ItemStack)liquidContainer);
                if (containerCapacity > 0 || liquidContainer.func_77973_b() == Items.field_151133_ar) {
                    ItemStack filledContainer;
                    FluidStack extractedLiquid;
                    if (containerCapacity == 0) {
                        containerCapacity = 1000;
                    }
                    if ((extractedLiquid = fluidHandler.drain(ForgeDirection.UNKNOWN, containerCapacity, false)) != null && extractedLiquid.amount == containerCapacity && (filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)extractedLiquid, (ItemStack)liquidContainer)) != null) {
                        fluidHandler.drain(ForgeDirection.UNKNOWN, containerCapacity, true);
                        --liquidContainer.field_77994_a;
                        returnedItems.add(filledContainer.func_77946_l());
                        return true;
                    }
                } else if (liquidContainer.func_77973_b() instanceof IFluidContainerItem) {
                    int filledAmount;
                    IFluidContainerItem container = (IFluidContainerItem)liquidContainer.func_77973_b();
                    ItemStack singleItem = liquidContainer.func_77946_l();
                    singleItem.field_77994_a = 1;
                    FluidStack extractedLiquid = fluidHandler.drain(ForgeDirection.UNKNOWN, container.getCapacity(singleItem), false);
                    if (extractedLiquid != null && (filledAmount = container.fill(singleItem, extractedLiquid, true)) > 0) {
                        --liquidContainer.field_77994_a;
                        returnedItems.add(singleItem);
                        FluidStack fluid = extractedLiquid.copy();
                        fluid.amount = filledAmount;
                        fluidHandler.drain(ForgeDirection.UNKNOWN, fluid, true);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isSourceBlock(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 0;
    }
}

