/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.AchievementHandler;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.fluid.FluidPlastic;
import pneumaticCraft.common.fluid.Fluids;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.thirdparty.computercraft.LuaMethod;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityBase;

public class TileEntityPlasticMixer
extends TileEntityBase
implements IFluidHandler,
ISidedInventory,
IHeatExchanger,
IRedstoneControlled {
    private final FluidTank tank = new FluidTank(16000);
    private final ItemStack[] inventory = new ItemStack[9];
    private int lastTickInventoryStacksize;
    private static int BASE_TEMPERATURE = FluidRegistry.WATER.getTemperature();
    @GuiSynced
    private final IHeatExchangerLogic hullLogic = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    @GuiSynced
    private final IHeatExchangerLogic itemLogic = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    @GuiSynced
    public int selectedPlastic = -1;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    public boolean lockSelection;
    @GuiSynced
    public int[] dyeBuffers = new int[3];
    public static final int DYE_PER_DYE = 2550;
    public static final int DYE_BUFFER_MAX = 8160;
    public static final String[] DYES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int INV_INPUT = 4;
    public static final int INV_OUTPUT = 5;
    public static final int INV_DYE_RED = 6;
    public static final int INV_DYE_GREEN = 7;
    public static final int INV_DYE_BLUE = 8;

    public TileEntityPlasticMixer() {
        super(0, 1, 2, 3);
        this.hullLogic.addConnectedExchanger(this.itemLogic);
        this.hullLogic.setThermalCapacity(100.0);
    }

    @SideOnly(value=Side.CLIENT)
    public IHeatExchangerLogic getLogic(int index) {
        switch (index) {
            case 0: {
                return this.hullLogic;
            }
            case 1: {
                return this.itemLogic;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    @SideOnly(value=Side.CLIENT)
    public IFluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.refillDyeBuffers();
            this.itemLogic.update();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                FluidStack moltenPlastic;
                int maxFill;
                if (this.inventory[4] != null && this.inventory[4].field_77994_a > this.lastTickInventoryStacksize) {
                    int stackIncrease = this.inventory[4].field_77994_a - this.lastTickInventoryStacksize;
                    double ratio = (double)this.inventory[4].field_77994_a / (double)(this.inventory[4].field_77994_a + stackIncrease);
                    this.itemLogic.setTemperature((int)(ratio * this.itemLogic.getTemperature() + (1.0 - ratio) * (double)BASE_TEMPERATURE));
                } else if (this.inventory[4] == null) {
                    this.itemLogic.setTemperature(BASE_TEMPERATURE);
                }
                if (this.itemLogic.getTemperature() >= 423.0 && (maxFill = this.fill(ForgeDirection.UNKNOWN, moltenPlastic = new FluidStack(Fluids.plastic, this.inventory[4].field_77994_a * 1000), false) / 1000) > 0) {
                    this.inventory[4].field_77994_a -= maxFill;
                    if (this.inventory[4].field_77994_a <= 0) {
                        this.inventory[4] = null;
                    }
                    this.fill(ForgeDirection.UNKNOWN, new FluidStack(moltenPlastic, maxFill * 1000), true);
                }
                this.lastTickInventoryStacksize = this.inventory[4] != null ? this.inventory[4].field_77994_a : 0;
                this.itemLogic.setThermalCapacity(this.inventory[4] == null ? 0.0 : (double)this.inventory[4].field_77994_a);
            }
            if (this.tank.getFluid() != null && this.selectedPlastic >= 0 && this.redstoneAllows()) {
                ItemStack solidifiedStack = new ItemStack(Itemss.plastic, this.tank.getFluid().amount / 1000, this.selectedPlastic);
                if (solidifiedStack.field_77994_a > 0) {
                    solidifiedStack.field_77994_a = 1;
                    if (this.inventory[5] == null) {
                        solidifiedStack.field_77994_a = this.useDye(solidifiedStack.field_77994_a);
                        if (solidifiedStack.field_77994_a > 0) {
                            this.inventory[5] = solidifiedStack;
                            this.tank.drain(this.inventory[5].field_77994_a * 1000, true);
                            this.sendDescriptionPacket();
                        }
                    } else if (solidifiedStack.func_77969_a(this.inventory[5])) {
                        int solidifiedItems = Math.min(64 - this.inventory[5].field_77994_a, solidifiedStack.field_77994_a);
                        solidifiedItems = this.useDye(solidifiedItems);
                        this.inventory[5].field_77994_a += solidifiedItems;
                        this.tank.drain(solidifiedItems * 1000, true);
                        this.sendDescriptionPacket();
                    }
                }
            }
            if (!this.lockSelection) {
                this.selectedPlastic = -1;
            }
            if (this.redstoneMode == 3) {
                this.selectedPlastic = this.poweredRedstone;
            }
        }
    }

    private void refillDyeBuffers() {
        for (int i = 0; i < 3; ++i) {
            if (this.func_70301_a(6 + i) == null || this.dyeBuffers[i] > 5610) continue;
            this.func_70298_a(6 + i, 1);
            int n = i;
            this.dyeBuffers[n] = this.dyeBuffers[n] + 2550;
        }
    }

    private int useDye(int maxItems) {
        int colorComponent;
        int i;
        int desiredColor = ItemDye.field_150922_c[this.selectedPlastic];
        if (this.selectedPlastic == 15) {
            return maxItems;
        }
        for (i = 0; i < 3; ++i) {
            colorComponent = desiredColor >> 8 * i & 0xFF;
            if ((colorComponent = 255 - colorComponent) <= 0) continue;
            maxItems = Math.min(maxItems, this.dyeBuffers[i] / colorComponent);
        }
        i = 0;
        while (i < 3) {
            colorComponent = desiredColor >> 8 * i & 0xFF;
            colorComponent = 255 - colorComponent;
            int n = i++;
            this.dyeBuffers[n] = this.dyeBuffers[n] - colorComponent * maxItems;
        }
        return maxItems;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        TileEntityPlasticMixer.readInventoryFromNBT(tag, this.inventory, "Items");
        this.lastTickInventoryStacksize = tag.func_74762_e("lastTickInventoryStacksize");
        this.selectedPlastic = tag.func_74762_e("selectedPlastic");
        this.lockSelection = tag.func_74767_n("lockSelection");
        this.dyeBuffers[0] = tag.func_74762_e("dyeBuffer0");
        this.dyeBuffers[1] = tag.func_74762_e("dyeBuffer1");
        this.dyeBuffers[2] = tag.func_74762_e("dyeBuffer2");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.itemLogic.readFromNBT(tag.func_74775_l("itemLogic"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        TileEntityPlasticMixer.writeInventoryToNBT(tag, this.inventory, "Items");
        tag.func_74768_a("lastTickInventoryStacksize", this.lastTickInventoryStacksize);
        tag.func_74768_a("selectedPlastic", this.selectedPlastic);
        tag.func_74757_a("lockSelection", this.lockSelection);
        tag.func_74768_a("dyeBuffer0", this.dyeBuffers[0]);
        tag.func_74768_a("dyeBuffer1", this.dyeBuffers[1]);
        tag.func_74768_a("dyeBuffer2", this.dyeBuffers[2]);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagCompound heatTag = new NBTTagCompound();
        this.itemLogic.writeToNBT(heatTag);
        tag.func_74782_a("itemLogic", (NBTBase)heatTag);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.tank.setFluid(null);
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("fluid", (NBTBase)tankTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !Fluids.areFluidsEqual(resource.getFluid(), Fluids.plastic)) {
            return 0;
        }
        int fillingAmount = Math.min(this.tank.getCapacity() - this.tank.getFluidAmount(), resource.amount);
        if (doFill && fillingAmount > 0) {
            this.tank.setFluid(FluidPlastic.mixFluid(this.tank.getFluid(), new FluidStack(resource, fillingAmount)));
            this.sendDescriptionPacket();
        }
        return fillingAmount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || Fluids.areFluidsEqual(resource.getFluid(), Fluids.plastic)) {
            return this.drain(from, 100, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(Math.min(100, maxDrain), doDrain);
        if (doDrain && drained != null && drained.getFluid() != null) {
            this.sendDescriptionPacket();
        }
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Fluids.areFluidsEqual(fluid, Fluids.plastic);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return Blockss.plasticMixer.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return true;
        }
        switch (i) {
            case 4: {
                return itemstack.func_77973_b() == Itemss.plastic;
            }
            case 5: {
                return false;
            }
            case 6: {
                return TileEntityPlasticMixer.getDyeIndex(itemstack) == 1;
            }
            case 7: {
                return TileEntityPlasticMixer.getDyeIndex(itemstack) == 2;
            }
            case 8: {
                return TileEntityPlasticMixer.getDyeIndex(itemstack) == 4;
            }
        }
        return itemstack.func_77973_b() == Itemss.machineUpgrade;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.hullLogic;
    }

    public static int getDyeIndex(ItemStack stack) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            for (int i = 0; i < DYES.length; ++i) {
                if (!DYES[i].equals(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 5;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (guiID == 0) {
            if (++this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
        } else if (guiID >= 1 && guiID < 17) {
            if (this.selectedPlastic != guiID) {
                this.selectedPlastic = guiID - 1;
                if (this.tank.getFluidAmount() >= 1000) {
                    AchievementHandler.giveAchievement(player, new ItemStack(Itemss.plastic));
                }
            } else {
                this.selectedPlastic = -1;
            }
        } else if (guiID == 17) {
            this.lockSelection = !this.lockSelection;
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 ? true : super.redstoneAllows();
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaMethod("selectColor"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 1) {
                    int selection = ((Double)args[0]).intValue();
                    if (selection >= 0 && selection <= 16) {
                        TileEntityPlasticMixer.this.selectedPlastic = selection - 1;
                        return null;
                    }
                    throw new IllegalArgumentException("selectColor method only accepts a value ranging from 0-16. The value passed was: " + selection);
                }
                throw new IllegalArgumentException("selectColor method requires 1 argument (int color index, with 0 being no color");
            }
        });
    }
}

