/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.util.IOHelper;

public class TileEntityOmnidirectionalHopper
extends TileEntityBase
implements ISidedInventory,
IRedstoneControlled {
    @DescSynced
    protected ForgeDirection inputDir = ForgeDirection.UNKNOWN;
    private ItemStack[] inventory = new ItemStack[this.getInvSize()];
    @GuiSynced
    public int redstoneMode;
    private int cooldown;
    @GuiSynced
    protected boolean leaveMaterial;
    private static final int[] accessibleSlots = new int[]{0, 1, 2, 3, 4};

    public TileEntityOmnidirectionalHopper() {
        this.setUpgradeSlots(5, 6, 7, 8);
    }

    protected int getInvSize() {
        return 9;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.func_145831_w().field_72995_K && --this.cooldown <= 0 && this.redstoneAllows()) {
            int maxItems = this.getMaxItems();
            boolean success = this.suckInItem(maxItems);
            this.cooldown = !(success |= this.exportItem(maxItems)) ? 8 : this.getItemTransferInterval();
        }
    }

    protected boolean exportItem(int maxItems) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
        TileEntity neighbor = IOHelper.getNeighbor(this, dir);
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null || this.leaveMaterial && stack.field_77994_a <= 1) continue;
            ItemStack exportedStack = stack.func_77946_l();
            if (this.leaveMaterial) {
                --exportedStack.field_77994_a;
            }
            if (exportedStack.field_77994_a > maxItems) {
                exportedStack.field_77994_a = maxItems;
            }
            int count = exportedStack.field_77994_a;
            ItemStack remainder = IOHelper.insert(neighbor, exportedStack, dir.getOpposite(), false);
            int exportedItems = count - (remainder == null ? 0 : remainder.field_77994_a);
            stack.field_77994_a -= exportedItems;
            if (stack.field_77994_a <= 0) {
                this.func_70299_a(i, null);
            }
            if ((maxItems -= exportedItems) > 0) continue;
            return true;
        }
        return false;
    }

    protected boolean suckInItem(int maxItems) {
        TileEntity inputInv = IOHelper.getNeighbor(this, this.inputDir);
        boolean success = false;
        for (int i = 0; i < maxItems; ++i) {
            if (this.hasEmptySlot()) {
                ItemStack inserted;
                ItemStack extracted = IOHelper.extractOneItem(inputInv, this.inputDir.getOpposite(), true);
                if (extracted == null || (inserted = IOHelper.insert(this, extracted, ForgeDirection.UNKNOWN, false)) != null) break;
                IOHelper.extractOneItem(inputInv, this.inputDir.getOpposite(), false);
                success = true;
                continue;
            }
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack inserted;
                ItemStack stack = this.inventory[slot];
                stack = stack.func_77946_l();
                stack.field_77994_a = 1;
                ItemStack extracted = IOHelper.extract(inputInv, this.inputDir.getOpposite(), stack, true, true);
                if (extracted == null || (inserted = IOHelper.insert(this, extracted, ForgeDirection.UNKNOWN, false)) != null) continue;
                IOHelper.extract(inputInv, this.inputDir.getOpposite(), stack, true, false);
                success = true;
                break;
            }
            if (!success) break;
        }
        for (EntityItem entity : TileEntityOmnidirectionalHopper.getNeighborItems(this, this.inputDir)) {
            ItemStack remainder;
            if (entity.field_70128_L || (remainder = IOHelper.insert(this, entity.func_92059_d(), ForgeDirection.UNKNOWN, false)) != null) continue;
            entity.func_70106_y();
            success = true;
        }
        return success;
    }

    private boolean hasEmptySlot() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory[i] != null) continue;
            return true;
        }
        return false;
    }

    public static List<EntityItem> getNeighborItems(TileEntity te, ForgeDirection inputDir) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(te.field_145851_c + inputDir.offsetX), (double)(te.field_145848_d + inputDir.offsetY), (double)(te.field_145849_e + inputDir.offsetZ), (double)(te.field_145851_c + inputDir.offsetX + 1), (double)(te.field_145848_d + inputDir.offsetY + 1), (double)(te.field_145849_e + inputDir.offsetZ + 1));
        return te.func_145831_w().func_72872_a(EntityItem.class, box);
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(5, this.getUpgradeSlots());
        if (upgrades > 3) {
            return Math.min((int)Math.pow(2.0, upgrades - 3), 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (int)Math.pow(2.0, this.getUpgrades(5, this.getUpgradeSlots()));
    }

    public void setDirection(ForgeDirection dir) {
        this.inputDir = dir;
    }

    public ForgeDirection getDirection() {
        return this.inputDir;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("inputDir", this.inputDir.ordinal());
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74757_a("leaveMaterial", this.leaveMaterial);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Inventory", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputDir = ForgeDirection.getOrientation((int)tag.func_74762_e("inputDir"));
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.leaveMaterial = tag.func_74767_n("leaveMaterial");
        NBTTagList tagList = tag.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public String func_145825_b() {
        return Blockss.omnidirectionalHopper.func_149739_a();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (buttonID == 1) {
            this.leaveMaterial = false;
        } else if (buttonID == 2) {
            this.leaveMaterial = true;
        }
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 < 5;
    }

    public int[] func_94128_d(int var1) {
        return accessibleSlots;
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return var1 < 5;
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return var1 < 5;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.isGuiUseableByPlayer(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterial;
    }
}

