/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import pneumaticCraft.common.PneumaticCraftAPIHandler;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityLiquidCompressor
extends TileEntityPneumaticBase
implements IInventory,
IRedstoneControlled,
IFluidHandler {
    @GuiSynced
    private final FluidTank tank = new FluidTank(16000);
    private final ItemStack[] inventory = new ItemStack[6];
    @GuiSynced
    public int redstoneMode;
    private double internalFuelBuffer;
    @GuiSynced
    public boolean isProducing;

    public TileEntityLiquidCompressor() {
        this(5.0f, 7.0f, 5000);
    }

    public TileEntityLiquidCompressor(float dangerPressure, float criticalPressure, int volume) {
        super(dangerPressure, criticalPressure, volume);
        this.setUpgradeSlots(0, 1, 2, 3);
    }

    private int getFuelValue(FluidStack fluid) {
        return fluid == null ? 0 : this.getFuelValue(fluid.getFluid());
    }

    private int getFuelValue(Fluid fluid) {
        Integer value = PneumaticCraftAPIHandler.getInstance().liquidFuels.get(fluid.getName());
        return value == null ? 0 : value;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.processFluidItem(4, 5);
            this.isProducing = false;
            if (this.redstoneAllows()) {
                double fuelValue;
                int usageRate = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades());
                if (this.internalFuelBuffer < (double)usageRate && (fuelValue = (double)this.getFuelValue(this.tank.getFluid()) / 1000.0) > 0.0) {
                    int usedFuel = Math.min(this.tank.getFluidAmount(), (int)((double)usageRate / fuelValue) + 1);
                    this.tank.drain(usedFuel, true);
                    this.internalFuelBuffer += (double)usedFuel * fuelValue;
                }
                if (this.internalFuelBuffer >= (double)usageRate) {
                    this.isProducing = true;
                    this.internalFuelBuffer -= (double)usageRate;
                    this.onFuelBurn(usageRate);
                    this.addAir((int)((float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f), ForgeDirection.UNKNOWN);
                }
            }
        }
    }

    protected void onFuelBurn(int burnedFuel) {
    }

    public int getEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    @Override
    public boolean isConnectedTo(ForgeDirection dir) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        return orientation == dir || orientation == dir.getOpposite() || dir == ForgeDirection.UP;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        TileEntityLiquidCompressor.writeInventoryToNBT(tag, this.inventory);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74780_a("internalFuelBuffer", this.internalFuelBuffer);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        TileEntityLiquidCompressor.readInventoryFromNBT(tag, this.inventory);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.internalFuelBuffer = tag.func_74769_h("internalFuelBuffer");
    }

    public String func_145825_b() {
        return Blockss.liquidCompressor.func_149739_a();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 5 ? false : stack != null && (FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack) != null || stack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack) != null);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.isGuiUseableByPlayer(p_70300_1_);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getFuelValue(resource) == 0) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, 100, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(Math.min(100, maxDrain), doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getFuelValue(fluid) > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @SideOnly(value=Side.CLIENT)
    public IFluidTank getFluidTank() {
        return this.tank;
    }
}

