/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.network.DescSynced;
import pneumaticCraft.common.network.LazySynced;
import pneumaticCraft.common.tileentity.IAssemblyMachine;
import pneumaticCraft.common.tileentity.IResettable;
import pneumaticCraft.common.tileentity.TileEntityAssemblyPlatform;
import pneumaticCraft.common.tileentity.TileEntityBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public abstract class TileEntityAssemblyRobot
extends TileEntityBase
implements IAssemblyMachine,
IResettable {
    public float[] oldAngles = new float[5];
    @DescSynced
    @LazySynced
    public float[] angles = new float[5];
    @DescSynced
    public float[] targetAngles = new float[5];
    public ForgeDirection[] targetDirection = new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN};
    @DescSynced
    public boolean slowMode;
    @DescSynced
    protected float speed = 1.0f;

    public TileEntityAssemblyRobot() {
        this.gotoHomePosition();
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = this.targetAngles[i];
            this.oldAngles[i] = this.targetAngles[i];
        }
    }

    @Override
    public void func_145845_h() {
        int i;
        super.func_145845_h();
        for (i = 0; i < 5; ++i) {
            this.oldAngles[i] = this.angles[i];
        }
        for (i = 0; i < 5; ++i) {
            if (this.angles[i] > this.targetAngles[i]) {
                this.angles[i] = Math.max(this.angles[i] - 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
                continue;
            }
            if (!(this.angles[i] < this.targetAngles[i])) continue;
            this.angles[i] = Math.min(this.angles[i] + 1.0f * (this.slowMode ? 0.1f : 1.0f) * this.speed, this.targetAngles[i]);
        }
    }

    public void gotoHomePosition() {
        this.targetAngles[EnumAngles.TURN.ordinal()] = 0.0f;
        this.targetAngles[EnumAngles.BASE.ordinal()] = 0.0f;
        this.targetAngles[EnumAngles.MIDDLE.ordinal()] = 55.0f;
        this.targetAngles[EnumAngles.TAIL.ordinal()] = 35.0f;
        this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
    }

    public boolean gotoTarget() {
        if (this.targetDirection == null) {
            return false;
        }
        this.gotoNeighbour(this.targetDirection[0], this.targetDirection[1]);
        return this.isDoneMoving();
    }

    public void gotoNeighbour(ForgeDirection direction) {
        this.gotoNeighbour(direction, ForgeDirection.UNKNOWN);
    }

    public boolean gotoNeighbour(ForgeDirection primaryDir, ForgeDirection secondaryDir) {
        this.targetDirection = new ForgeDirection[]{primaryDir, secondaryDir};
        boolean diagonal = true;
        boolean diagonalAllowed = this.canMoveToDiagonalNeighbours();
        switch (primaryDir) {
            case SOUTH: {
                if (secondaryDir == ForgeDirection.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = -45.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = 40.0f;
                    break;
                }
                if (secondaryDir == ForgeDirection.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = 45.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = -40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.ordinal()] = 0.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 90.0f;
                diagonal = false;
                break;
            }
            case EAST: {
                this.targetAngles[EnumAngles.TURN.ordinal()] = -90.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
                diagonal = false;
                break;
            }
            case NORTH: {
                if (secondaryDir == ForgeDirection.EAST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = -135.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = -40.0f;
                    break;
                }
                if (secondaryDir == ForgeDirection.WEST && diagonalAllowed) {
                    this.targetAngles[EnumAngles.TURN.ordinal()] = 135.0f;
                    this.targetAngles[EnumAngles.HEAD.ordinal()] = 40.0f;
                    break;
                }
                this.targetAngles[EnumAngles.TURN.ordinal()] = 180.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 90.0f;
                diagonal = false;
                break;
            }
            case WEST: {
                this.targetAngles[EnumAngles.TURN.ordinal()] = 90.0f;
                this.targetAngles[EnumAngles.HEAD.ordinal()] = 0.0f;
                diagonal = false;
            }
        }
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -85.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = -20.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -10.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = 0.0f;
        }
        return diagonal;
    }

    public boolean hoverOverTarget() {
        if (this.targetDirection == null) {
            return false;
        }
        return this.hoverOverNeighbour(this.targetDirection);
    }

    public boolean hoverOverNeighbour(ForgeDirection[] directions) {
        this.hoverOverNeighbour(directions[0], directions[1]);
        return this.isDoneMoving();
    }

    public void hoverOverNeighbour(ForgeDirection primaryDir, ForgeDirection secondaryDir) {
        boolean diagonal = this.gotoNeighbour(primaryDir, secondaryDir);
        if (diagonal) {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 160.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -95.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = -10.0f;
        } else {
            this.targetAngles[EnumAngles.BASE.ordinal()] = 100.0f;
            this.targetAngles[EnumAngles.MIDDLE.ordinal()] = -20.0f;
            this.targetAngles[EnumAngles.TAIL.ordinal()] = 10.0f;
        }
    }

    public TileEntity getTileEntityForCurrentDirection() {
        return this.getTileEntityForDirection(this.targetDirection[0], this.targetDirection[1]);
    }

    public TileEntity getTileEntityForDirection(ForgeDirection[] directions) {
        return this.getTileEntityForDirection(directions[0], directions[1]);
    }

    public TileEntity getTileEntityForDirection(ForgeDirection firstDir, ForgeDirection secondDir) {
        return this.field_145850_b.func_147438_o(this.field_145851_c + firstDir.offsetX + secondDir.offsetX, this.field_145848_d + firstDir.offsetY + secondDir.offsetY, this.field_145849_e + firstDir.offsetZ + secondDir.offsetZ);
    }

    protected boolean isDoneMoving() {
        for (int i = 0; i < 5; ++i) {
            if (PneumaticCraftUtils.areFloatsEqual(this.angles[i], this.targetAngles[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isDoneRotatingYaw() {
        return PneumaticCraftUtils.areFloatsEqual(this.angles[EnumAngles.TURN.ordinal()], this.targetAngles[EnumAngles.TURN.ordinal()]);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 5; ++i) {
            this.angles[i] = tag.func_74760_g("angle" + i);
            this.targetAngles[i] = tag.func_74760_g("targetAngle" + i);
        }
        this.slowMode = tag.func_74767_n("slowMode");
        this.speed = tag.func_74760_g("speed");
        this.targetDirection[0] = ForgeDirection.values()[tag.func_74762_e("targetDir1")];
        this.targetDirection[1] = ForgeDirection.values()[tag.func_74762_e("targetDir2")];
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        for (int i = 0; i < 5; ++i) {
            tag.func_74776_a("angle" + i, this.angles[i]);
            tag.func_74776_a("targetAngle" + i, this.targetAngles[i]);
        }
        tag.func_74757_a("slowMode", this.slowMode);
        tag.func_74776_a("speed", this.speed);
        if (this.targetDirection != null) {
            if (this.targetDirection.length > 0) {
                tag.func_74768_a("targetDir1", this.targetDirection[0].ordinal());
            }
            if (this.targetDirection.length > 1) {
                tag.func_74768_a("targetDir2", this.targetDirection[1].ordinal());
            }
        }
    }

    public abstract boolean canMoveToDiagonalNeighbours();

    public ForgeDirection[] getPlatformDirection() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || !(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ) instanceof TileEntityAssemblyPlatform)) continue;
            return new ForgeDirection[]{dir, ForgeDirection.UNKNOWN};
        }
        if (this.canMoveToDiagonalNeighbours()) {
            if (this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.NORTH.offsetX + ForgeDirection.WEST.offsetX, this.field_145848_d, this.field_145849_e + ForgeDirection.NORTH.offsetZ + ForgeDirection.WEST.offsetZ) instanceof TileEntityAssemblyPlatform) {
                return new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST};
            }
            if (this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.NORTH.offsetX + ForgeDirection.EAST.offsetX, this.field_145848_d, this.field_145849_e + ForgeDirection.NORTH.offsetZ + ForgeDirection.EAST.offsetZ) instanceof TileEntityAssemblyPlatform) {
                return new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST};
            }
            if (this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.SOUTH.offsetX + ForgeDirection.WEST.offsetX, this.field_145848_d, this.field_145849_e + ForgeDirection.SOUTH.offsetZ + ForgeDirection.WEST.offsetZ) instanceof TileEntityAssemblyPlatform) {
                return new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST};
            }
            if (this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.SOUTH.offsetX + ForgeDirection.EAST.offsetX, this.field_145848_d, this.field_145849_e + ForgeDirection.SOUTH.offsetZ + ForgeDirection.EAST.offsetZ) instanceof TileEntityAssemblyPlatform) {
                return new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.EAST};
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    protected static enum EnumAngles {
        TURN,
        BASE,
        MIDDLE,
        TAIL,
        HEAD;

    }
}

