/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.tileentity;

import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.block.Blockss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.tileentity.TileEntityAirCompressor;

public class TileEntityAdvancedAirCompressor
extends TileEntityAirCompressor
implements IHeatExchanger {
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();

    public TileEntityAdvancedAirCompressor() {
        super(20.0f, 25.0f, 10000);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }

    @Override
    protected void onFuelBurn(int burnedFuel) {
        this.heatExchanger.addHeat((double)burnedFuel / 2.0);
    }

    @Override
    public int getBaseProduction() {
        return 50;
    }

    @Override
    public int getEfficiency() {
        return TileEntityAdvancedAirCompressor.getEfficiency(this.heatExchanger.getTemperature());
    }

    public static int getEfficiency(double temperature) {
        return MathHelper.func_76125_a((int)((int)((625.0 - temperature) / 3.0)), (int)0, (int)100);
    }

    @Override
    protected float getSpeedUsageMultiplierFromUpgrades(int[] upgradeSlots) {
        return this.getSpeedMultiplierFromUpgrades(upgradeSlots);
    }

    @Override
    public String func_145825_b() {
        return Blockss.advancedAirCompressor.func_149739_a();
    }
}

