/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.api.IHeatExchangerLogic;
import pneumaticCraft.api.PneumaticRegistry;
import pneumaticCraft.api.tileentity.IHeatExchanger;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.thirdparty.ic2.IC2;
import pneumaticCraft.common.tileentity.IRedstoneControlled;
import pneumaticCraft.common.tileentity.TileEntityAdvancedAirCompressor;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class TileEntityElectricCompressor
extends TileEntityPneumaticBase
implements IEnergySink,
IWrenchable,
IInventory,
IRedstoneControlled,
IHeatExchanger {
    private ItemStack[] inventory;
    private final int INVENTORY_SIZE = 4;
    public static final int UPGRADE_SLOT_START = 0;
    public static final int UPGRADE_SLOT_END = 3;
    public int outputTimer;
    private boolean redstoneAllows;
    @GuiSynced
    public int redstoneMode = 0;
    private int curEnergyProduction;
    @GuiSynced
    public int lastEnergyProduction;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatExchangerLogic();
    public float turbineRotation;
    public float oldTurbineRotation;
    public float turbineSpeed;

    public TileEntityElectricCompressor() {
        super(20.0f, 25.0f, 10000);
        this.inventory = new ItemStack[4];
        this.setUpgradeSlots(0, 1, 2, 3);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return TileEntityAdvancedAirCompressor.getEfficiency(this.heatExchanger.getTemperature());
    }

    @Override
    public void func_145845_h() {
        this.redstoneAllows = this.redstoneAllows();
        this.oldTurbineRotation = this.turbineRotation;
        this.turbineSpeed = this.outputTimer > 0 ? Math.min(this.turbineSpeed + 0.2f, 10.0f) : Math.max(this.turbineSpeed - 0.2f, 0.0f);
        this.turbineRotation += this.turbineSpeed;
        if (!this.field_145850_b.field_72995_K) {
            this.lastEnergyProduction = this.curEnergyProduction;
            this.curEnergyProduction = 0;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            --this.outputTimer;
            if (this.outputTimer == 0) {
                this.sendDescriptionPacket();
            }
        }
    }

    @Override
    protected void onFirstServerUpdate() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    public void func_145843_s() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        }
        super.onChunkUnload();
    }

    @Override
    public boolean redstoneAllows() {
        switch (this.redstoneMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            case 2: {
                return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        return false;
    }

    @Override
    protected void disperseAir() {
        super.disperseAir();
    }

    @Override
    public boolean isConnectedTo(ForgeDirection side) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)this.func_145832_p());
        return orientation == side || orientation == side.getOpposite();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            this.func_70299_a(slot, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return IC2.electricCompressor.func_149739_a();
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.redstoneMode = nbtTagCompound.func_74762_e("redstoneMode");
        this.outputTimer = nbtTagCompound.func_74767_n("outputTimer") ? 20 : 0;
        this.turbineSpeed = nbtTagCompound.func_74760_g("turbineSpeed");
        this.lastEnergyProduction = nbtTagCompound.func_74762_e("energyProduction");
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        nbtTagCompound.func_74757_a("outputTimer", this.outputTimer > 0);
        nbtTagCompound.func_74776_a("turbineSpeed", this.turbineSpeed);
        nbtTagCompound.func_74768_a("energyProduction", this.lastEnergyProduction);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack != null && (itemstack.func_77973_b() == Itemss.machineUpgrade || PneumaticCraftUtils.isIC2Upgrade(itemstack.func_77973_b()));
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction == ForgeDirection.UP;
    }

    public double getDemandedEnergy() {
        return this.redstoneAllows ? Double.MAX_VALUE : 0.0;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double energyUsed = amount;
        int efficiency = Config.electricCompressorEfficiency;
        int airProduction = (int)(energyUsed / 0.25 * (double)efficiency / 100.0 * (double)this.getEfficiency() / 100.0);
        this.heatExchanger.addHeat(energyUsed / 16.0);
        this.addAir(airProduction, ForgeDirection.UNKNOWN);
        this.curEnergyProduction += airProduction;
        boolean clientNeedsUpdate = this.outputTimer <= 0;
        this.outputTimer = 20;
        if (clientNeedsUpdate) {
            this.sendDescriptionPacket();
        }
        return amount - energyUsed;
    }

    public int getMaxSafeInput() {
        int upgradesInserted = this.getIC2Upgrades("transformerUpgrade", this.getUpgradeSlots());
        return 32 * (int)Math.pow(4.0, upgradesInserted);
    }

    public int getSinkTier() {
        int upgradesInserted = this.getIC2Upgrades("transformerUpgrade", this.getUpgradeSlots());
        return 1 + upgradesInserted;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return side != (this.func_145832_p() ^ 1) && side >= 2;
    }

    public short getFacing() {
        return (short)(this.func_145832_p() ^ 1);
    }

    public void setFacing(short facing) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, facing ^ 1, 3);
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(IC2.electricCompressor);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.isGuiUseableByPlayer(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(ForgeDirection side) {
        return this.heatExchanger;
    }
}

