/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.thirdparty.hydraulicraft;

import k4unl.minecraft.Hydraulicraft.api.HydraulicBaseClassSupplier;
import k4unl.minecraft.Hydraulicraft.api.IBaseClass;
import k4unl.minecraft.Hydraulicraft.api.IHydraulicGenerator;
import k4unl.minecraft.Hydraulicraft.api.PressureTier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;

public class TileEntityPneumaticPump
extends TileEntityPneumaticBase
implements IHydraulicGenerator {
    private final IBaseClass handler = HydraulicBaseClassSupplier.getBaseClass((TileEntity)this, (PressureTier)PressureTier.HIGHPRESSURE, (int)10);

    public TileEntityPneumaticPump() {
        super(20.0f, 25.0f, 10000);
    }

    public IBaseClass getHandler() {
        return this.handler;
    }

    public void onFluidLevelChanged(int old) {
    }

    public boolean canConnectTo(ForgeDirection side) {
        return true;
    }

    public void workFunction(ForgeDirection from) {
        int airUsed = (int)(this.getPressure(from) * 10.0f);
        this.handler.addPressureWithRatio((float)(150 * airUsed * Config.pneumaticPumpEfficiency / 100), from);
        this.addAir(-airUsed, from);
    }

    public boolean canWork(ForgeDirection dir) {
        return this.getPressure(dir) > 5.0f && ForgeDirection.UP == dir;
    }

    public int getMaxGenerating(ForgeDirection from) {
        return 100;
    }

    public float getGenerating(ForgeDirection from) {
        return 100.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.handler.readFromNBTI(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.handler.writeToNBTI(tag);
    }

    @Override
    public void func_145829_t() {
        this.handler.init((TileEntity)this);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.handler.updateEntityI();
    }
}

