/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.semiblock;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnection;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.network.GuiSynced;
import pneumaticCraft.common.semiblock.IProvidingInventoryListener;
import pneumaticCraft.common.semiblock.ISpecificRequester;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.lib.Log;
import pneumaticCraft.proxy.CommonProxy;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.IGridBlock", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingProvider", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingWatcherHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.storage.IStackWatcherHost", modid="appliedenergistics2"), @Optional.Interface(iface="pneumaticCraft.common.semiblock.MEInventoryExtension", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.storage.ICellContainer", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.ticking.IGridTickable", modid="appliedenergistics2")})
public class SemiBlockRequester
extends SemiBlockLogistics
implements ISpecificRequester,
IProvidingInventoryListener,
IGridHost,
IGridBlock,
ICraftingProvider,
ICraftingWatcherHost,
IStackWatcherHost,
ICellContainer,
IGridTickable {
    public static final String ID = "logisticFrameRequester";
    @GuiSynced
    private boolean aeMode;
    private Object gridNode;
    private Object craftingGrid;
    private Object stackWatcher;
    private Object craftingWatcher;
    private boolean needToCheckForInterface = true;
    private final Map<TileEntity, Integer> providingInventories = new HashMap<TileEntity, Integer>();

    @Override
    public int getColor() {
        return -16776961;
    }

    @Override
    public int amountRequested(ItemStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            IInventory inv = IOHelper.getInventoryForTE(this.getTileEntity());
            int count = 0;
            if (inv != null) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack s = inv.func_70301_a(i);
                    if (s == null || !this.isItemEqual(s, stack)) continue;
                    count += s.field_77994_a;
                }
                int requested = Math.max(0, Math.min(stack.field_77994_a, totalRequestingAmount - (count += this.getIncomingItems(stack))));
                return requested;
            }
        }
        return 0;
    }

    private int getTotalRequestedAmount(ItemStack stack) {
        int requesting = 0;
        for (int i = 0; i < this.getFilters().func_70302_i_(); ++i) {
            ItemStack requestingStack = this.getFilters().func_70301_a(i);
            if (requestingStack == null || !this.isItemEqual(stack, requestingStack)) continue;
            requesting += requestingStack.field_77994_a;
        }
        return requesting;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        TileEntity te;
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0 && (te = this.getTileEntity()) instanceof IFluidHandler) {
            int count = 0;
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                FluidTankInfo[] infos = ((IFluidHandler)te).getTankInfo(d);
                if (infos == null) continue;
                for (FluidTankInfo info : infos) {
                    if (info.fluid == null || info.fluid.getFluid() != stack.getFluid()) continue;
                    count += info.fluid.amount;
                }
                if (count > 0) break;
            }
            int requested = Math.max(0, Math.min(stack.amount, totalRequestingAmount - (count += this.getIncomingFluid(stack.getFluid()))));
            return requested;
        }
        return 0;
    }

    private int getTotalRequestedAmount(FluidStack stack) {
        int requesting = 0;
        for (int i = 0; i < 9; ++i) {
            FluidStack requestingStack = this.getTankFilter(i).getFluid();
            if (requestingStack == null || requestingStack.getFluid() != stack.getFluid()) continue;
            requesting += requestingStack.amount;
        }
        return requesting;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public CommonProxy.EnumGuiId getGuiID() {
        return CommonProxy.EnumGuiId.LOGISTICS_REQUESTER;
    }

    @Override
    public boolean canFilterStack() {
        return true;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void update() {
        super.update();
        if (!this.world.field_72995_K) {
            if (this.needToCheckForInterface) {
                this.needToCheckForInterface = Loader.isModLoaded((String)"appliedenergistics2") && !this.world.field_72995_K && this.aeMode && this.gridNode == null ? this.checkForInterface() : false;
            }
            Iterator<Map.Entry<TileEntity, Integer>> iterator = this.providingInventories.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TileEntity, Integer> entry = iterator.next();
                if (entry.getValue() == 0 || entry.getKey().func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(entry.getValue() - 1);
            }
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 1) {
            this.needToCheckForInterface = this.aeMode = !this.aeMode;
            if (!this.aeMode && this.gridNode != null) {
                this.disconnectFromInterface();
            }
        }
        super.handleGUIButtonPress(guiID, player);
    }

    public boolean isIntegrationEnabled() {
        return this.aeMode;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("aeMode", this.aeMode);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.aeMode = tag.func_74767_n("aeMode");
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void invalidate() {
        super.invalidate();
        if (this.gridNode != null) {
            this.disconnectFromInterface();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isPlacedOnInterface() {
        return this.getTileEntity() != null && AEApi.instance().definitions().blocks().iface().maybeBlock().get() == this.getTileEntity().func_145838_q();
    }

    @Optional.Method(modid="appliedenergistics2")
    private boolean checkForInterface() {
        TileEntity te;
        if (this.isPlacedOnInterface() && (te = this.getTileEntity()) instanceof IGridHost) {
            if (((IGridHost)te).getGridNode(null) == null) {
                return true;
            }
            if (this.getGridNode(null) == null) {
                return true;
            }
            try {
                AEApi.instance().createGridConnection(this.getGridNode(null), ((IGridHost)te).getGridNode(null));
            }
            catch (FailedConnection e) {
                Log.error("Couldn't connect to an ME Interface!");
                e.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    private void disconnectFromInterface() {
        ((IGridNode)this.gridNode).destroy();
        this.gridNode = null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection arg0) {
        return AECableType.NONE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection d) {
        if (this.gridNode == null) {
            this.gridNode = AEApi.instance().createGridNode((IGridBlock)this);
        }
        return (IGridNode)this.gridNode;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.drop();
    }

    @Optional.Method(modid="appliedenergistics2")
    public EnumSet<ForgeDirection> getConnectableSides() {
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    @Optional.Method(modid="appliedenergistics2")
    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public double getIdlePowerUsage() {
        return 1.0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.world, this.getX(), this.getY(), this.getZ());
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridHost getMachine() {
        return this;
    }

    public ItemStack getMachineRepresentation() {
        return new ItemStack(Itemss.logisticsFrameRequester);
    }

    public void gridChanged() {
    }

    public boolean isWorldAccessible() {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onGridNotification(GridNotification arg0) {
    }

    @Optional.Method(modid="appliedenergistics2")
    public void setNetworkStatus(IGrid arg0, int arg1) {
    }

    public boolean isBusy() {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean pushPattern(ICraftingPatternDetails details, InventoryCrafting inventoryCrafting) {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void provideCrafting(ICraftingProviderHelper helper) {
        this.updateProvidingItems(helper);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onRequestChange(ICraftingGrid grid, IAEItemStack aeStack) {
        this.craftingGrid = grid;
        ItemStack stack = aeStack.getItemStack().func_77946_l();
        int freeSlot = -1;
        for (int i = 0; i < this.getFilters().func_70302_i_(); ++i) {
            ItemStack s = this.getFilters().func_70301_a(i);
            if (s != null) {
                if (!stack.func_77969_a(s)) continue;
                s.field_77994_a = stack.field_77994_a;
                if (s.field_77994_a == 0) {
                    this.getFilters().func_70299_a(i, null);
                }
                return;
            }
            if (freeSlot != -1) continue;
            freeSlot = i;
        }
        if (freeSlot >= 0) {
            this.getFilters().func_70299_a(freeSlot, stack.func_77946_l());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void updateWatcher(ICraftingWatcher watcher) {
        this.craftingWatcher = watcher;
        this.updateProvidingItems();
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onStackChange(IItemList arg0, IAEStack arg1, IAEStack arg2, BaseActionSource arg3, StorageChannel arg4) {
        if (this.craftingGrid != null) {
            ICraftingGrid grid = (ICraftingGrid)this.craftingGrid;
            for (int i = 0; i < this.getFilters().func_70302_i_(); ++i) {
                ItemStack s = this.getFilters().func_70301_a(i);
                if (s == null || grid.isRequesting(AEApi.instance().storage().createItemStack(s))) continue;
                this.getFilters().func_70299_a(i, null);
                this.notifyNetworkOfCraftingChange();
            }
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void updateWatcher(IStackWatcher watcher) {
        this.stackWatcher = watcher;
        this.updateProvidingItems();
    }

    @Optional.Method(modid="appliedenergistics2")
    private void updateProvidingItems() {
        this.updateProvidingItems(null);
    }

    @Optional.Method(modid="appliedenergistics2")
    private void notifyNetworkOfCraftingChange() {
        IGrid grid;
        if (this.gridNode != null && (grid = ((IGridNode)this.gridNode).getGrid()) != null) {
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, (IGridNode)this.gridNode));
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private void updateProvidingItems(ICraftingProviderHelper cHelper) {
        IStackWatcher sWatcher = (IStackWatcher)this.stackWatcher;
        ICraftingWatcher cWatcher = (ICraftingWatcher)this.craftingWatcher;
        if (sWatcher != null) {
            sWatcher.clear();
        }
        if (cWatcher != null) {
            cWatcher.clear();
        }
        for (IAEItemStack stack : this.getProvidingItems()) {
            if (sWatcher != null) {
                sWatcher.add((Object)stack);
            }
            if (cWatcher != null) {
                cWatcher.add((Object)stack);
            }
            if (cHelper == null) continue;
            cHelper.setEmitable(stack);
        }
    }

    @Override
    public void notify(TileEntity te) {
        if (this.gridNode != null) {
            this.providingInventories.put(te, 40);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public List<IAEItemStack> getProvidingItems() {
        ArrayList<IAEItemStack> stacks = new ArrayList<IAEItemStack>();
        for (TileEntity te : this.providingInventories.keySet()) {
            IInventory inv = IOHelper.getInventoryForTE(te);
            if (inv == null) continue;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                stacks.add(AEApi.instance().storage().createItemStack(stack));
            }
        }
        return stacks;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.getGridNode(null);
    }

    @Optional.Method(modid="appliedenergistics2")
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (channel == StorageChannel.ITEMS) {
            return Arrays.asList((IMEInventoryHandler)this);
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Optional.Method(modid="appliedenergistics2")
    public void saveChanges(IMEInventory arg0) {
    }

    public void blinkCell(int arg0) {
    }

    @Optional.Method(modid="appliedenergistics2")
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(120, 120, false, false);
    }

    @Optional.Method(modid="appliedenergistics2")
    public TickRateModulation tickingRequest(IGridNode arg0, int arg1) {
        this.notifyNetworkOfCraftingChange();
        if (this.gridNode != null) {
            this.getGridNode(null).getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        return TickRateModulation.SAME;
    }
}

