/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pneumaticCraft.client.gui.widget.IGuiWidget;
import pneumaticCraft.common.remote.ActionWidget;
import pneumaticCraft.common.remote.ActionWidgetButton;
import pneumaticCraft.common.remote.ActionWidgetCheckBox;
import pneumaticCraft.common.remote.ActionWidgetDropdown;
import pneumaticCraft.common.remote.ActionWidgetLabel;

public class RemoteLayout {
    private final List<ActionWidget> actionWidgets = new ArrayList<ActionWidget>();
    private static final Map<String, Class<? extends ActionWidget>> registeredWidgets = new HashMap<String, Class<? extends ActionWidget>>();

    private static void registerWidget(Class<? extends ActionWidget> widgetClass) {
        try {
            ActionWidget widget = widgetClass.newInstance();
            registeredWidgets.put(widget.getId(), widgetClass);
            return;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Widget " + widgetClass + " couldn't be registered");
    }

    public RemoteLayout(ItemStack remote, int guiLeft, int guiTop) {
        NBTTagCompound tag = remote.func_77978_p();
        if (tag != null) {
            NBTTagList tagList = tag.func_150295_c("actionWidgets", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound widgetTag = tagList.func_150305_b(i);
                String id = widgetTag.func_74779_i("id");
                Class<? extends ActionWidget> clazz = registeredWidgets.get(id);
                try {
                    ActionWidget widget = clazz.newInstance();
                    widget.readFromNBT(widgetTag, guiLeft, guiTop);
                    this.actionWidgets.add(widget);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public NBTTagCompound toNBT(int guiLeft, int guiTop) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (ActionWidget actionWidget : this.actionWidgets) {
            tagList.func_74742_a((NBTBase)actionWidget.toNBT(guiLeft, guiTop));
        }
        tag.func_74782_a("actionWidgets", (NBTBase)tagList);
        return tag;
    }

    public void addWidget(ActionWidget widget) {
        this.actionWidgets.add(widget);
    }

    public List<ActionWidget> getActionWidgets() {
        return this.actionWidgets;
    }

    public List<IGuiWidget> getWidgets(boolean filterDisabledWidgets) {
        ArrayList<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
        for (ActionWidget actionWidget : this.actionWidgets) {
            if (filterDisabledWidgets && !actionWidget.isEnabled()) continue;
            widgets.add((IGuiWidget)actionWidget.getWidget());
        }
        return widgets;
    }

    static {
        RemoteLayout.registerWidget(ActionWidgetCheckBox.class);
        RemoteLayout.registerWidget(ActionWidgetLabel.class);
        RemoteLayout.registerWidget(ActionWidgetButton.class);
        RemoteLayout.registerWidget(ActionWidgetDropdown.class);
    }
}

