/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pneumaticCraft.lib.Log;

public class AmadronOffer {
    protected Object input;
    protected Object output;

    public AmadronOffer(Object input, Object output) {
        if (input == null) {
            throw new NullPointerException("Input item/fluid can't be null!");
        }
        if (output == null) {
            throw new NullPointerException("Output item/fluid can't be null!");
        }
        if (input instanceof ItemStack) {
            if (((ItemStack)input).field_77994_a <= 0) {
                throw new IllegalArgumentException("Input item needs to have a stacksize of > 0!");
            }
            if (((ItemStack)input).func_77973_b() == null) {
                throw new IllegalArgumentException("Input item can't be null!");
            }
        } else if (input instanceof FluidStack) {
            if (((FluidStack)input).amount <= 0) {
                throw new IllegalArgumentException("Input fluid needs to have an amount of > 0!");
            }
        } else {
            throw new IllegalArgumentException("Input must be of type ItemStack or FluidStack. Input: " + input);
        }
        if (output instanceof ItemStack) {
            if (((ItemStack)output).field_77994_a <= 0) {
                throw new IllegalArgumentException("Output item needs to have a stacksize of > 0!");
            }
            if (((ItemStack)output).func_77973_b() == null) {
                throw new IllegalArgumentException("Output item can't be null!");
            }
        } else if (output instanceof FluidStack) {
            if (((FluidStack)output).amount <= 0) {
                throw new IllegalArgumentException("Output fluid needs to have an amount of > 0!");
            }
        } else {
            throw new IllegalArgumentException("Output must be of type ItemStack or FluidStack. Output: " + input);
        }
        this.input = input;
        this.output = output;
    }

    public Object getInput() {
        return this.input;
    }

    public Object getOutput() {
        return this.output;
    }

    public String getVendor() {
        return StatCollector.func_74838_a((String)"gui.amadron");
    }

    public int getStock() {
        return -1;
    }

    public boolean passesQuery(String query) {
        String queryLow = query.toLowerCase();
        return this.getObjectName(this.getInput()).toLowerCase().contains(queryLow) || this.getObjectName(this.getOutput()).toLowerCase().contains(queryLow) || this.getVendor().toLowerCase().contains(queryLow);
    }

    private String getObjectName(Object object) {
        return object instanceof ItemStack ? ((ItemStack)object).func_82833_r() : ((FluidStack)object).getLocalizedName();
    }

    public void onTrade(int tradingAmount, String buyingPlayer) {
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        if (this.input instanceof ItemStack) {
            ((ItemStack)this.input).func_77955_b(subTag);
            tag.func_74782_a("inputItem", (NBTBase)subTag);
        } else {
            ((FluidStack)this.input).writeToNBT(subTag);
            tag.func_74782_a("inputFluid", (NBTBase)subTag);
        }
        subTag = new NBTTagCompound();
        if (this.output instanceof ItemStack) {
            ((ItemStack)this.output).func_77955_b(subTag);
            tag.func_74782_a("outputItem", (NBTBase)subTag);
        } else {
            ((FluidStack)this.output).writeToNBT(subTag);
            tag.func_74782_a("outputFluid", (NBTBase)subTag);
        }
    }

    public static AmadronOffer loadFromNBT(NBTTagCompound tag) {
        Object input = tag.func_74764_b("inputItem") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("inputItem")) : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("inputFluid"));
        Object output = tag.func_74764_b("outputItem") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("outputItem")) : FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("outputFluid"));
        return new AmadronOffer(input, output);
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        JsonObject inputObject = new JsonObject();
        if (this.input instanceof ItemStack) {
            inputObject.addProperty("id", GameData.getItemRegistry().func_148750_c((Object)((ItemStack)this.input).func_77973_b()));
            inputObject.addProperty("damage", (Number)((ItemStack)this.input).func_77960_j());
            inputObject.addProperty("amount", (Number)((ItemStack)this.input).field_77994_a);
        } else {
            inputObject.addProperty("id", ((FluidStack)this.input).getFluid().getName());
            inputObject.addProperty("amount", (Number)((FluidStack)this.input).amount);
        }
        object.add("input", (JsonElement)inputObject);
        JsonObject outputObject = new JsonObject();
        if (this.output instanceof ItemStack) {
            outputObject.addProperty("id", GameData.getItemRegistry().func_148750_c((Object)((ItemStack)this.output).func_77973_b()));
            outputObject.addProperty("damage", (Number)((ItemStack)this.output).func_77960_j());
            outputObject.addProperty("amount", (Number)((ItemStack)this.output).field_77994_a);
        } else {
            outputObject.addProperty("id", ((FluidStack)this.output).getFluid().getName());
            outputObject.addProperty("amount", (Number)((FluidStack)this.output).amount);
        }
        object.add("output", (JsonElement)outputObject);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static AmadronOffer fromJson(JsonObject object) {
        FluidStack output;
        FluidStack input;
        JsonObject inputObject = object.getAsJsonObject("input");
        if (inputObject.has("damage")) {
            Item item = (Item)GameData.getItemRegistry().func_82594_a(inputObject.get("id").getAsString());
            if (item == null) {
                Log.error("Invalid Amadron Offer input item. Invalid item name: " + inputObject.get("id").getAsString() + ". Offer will be skipped");
                return null;
            }
            input = new ItemStack(item, inputObject.get("amount").getAsInt(), inputObject.get("damage").getAsInt());
        } else {
            Fluid fluid = FluidRegistry.getFluid((String)inputObject.get("id").getAsString());
            if (fluid == null) {
                Log.error("Invalid Amadron Offer input fluid. Invalid fluid name: " + inputObject.get("id").getAsString() + ". Offer will be skipped");
                return null;
            }
            input = new FluidStack(fluid, inputObject.get("amount").getAsInt());
        }
        JsonObject outputObject = object.getAsJsonObject("output");
        if (outputObject.has("damage")) {
            Item item = (Item)GameData.getItemRegistry().func_82594_a(outputObject.get("id").getAsString());
            if (item != null) {
                output = new ItemStack(item, outputObject.get("amount").getAsInt(), outputObject.get("damage").getAsInt());
                return new AmadronOffer(input, output);
            }
            Log.error("Invalid Amadron Offer output item. Invalid item name: " + outputObject.get("id").getAsString() + ". Offer will be skipped");
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)outputObject.get("id").getAsString());
        if (fluid != null) {
            output = new FluidStack(fluid, outputObject.get("amount").getAsInt());
            return new AmadronOffer(input, output);
        }
        Log.error("Invalid Amadron Offer output fluid. Invalid fluid name: " + outputObject.get("id").getAsString() + ". Offer will be skipped");
        return null;
    }

    public int hashCode() {
        int code = this.getObjectHashCode(this.getInput());
        code = 31 * code + this.getObjectHashCode(this.getOutput());
        code = 31 * code + this.getVendor().hashCode();
        return code;
    }

    private int getObjectHashCode(Object o) {
        if (o instanceof FluidStack) {
            return o.hashCode();
        }
        ItemStack stack = (ItemStack)o;
        return GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b()).hashCode() + stack.field_77994_a * 19;
    }

    public boolean equals(Object o) {
        AmadronOffer offer;
        if (o instanceof AmadronOffer && (offer = (AmadronOffer)o).getInput().getClass() == this.getInput().getClass() && offer.getOutput().getClass() == this.getOutput().getClass()) {
            ItemStack s2;
            ItemStack s1;
            if (offer.getInput() instanceof ItemStack ? !ItemStack.func_77989_b((ItemStack)(s1 = (ItemStack)offer.getInput()), (ItemStack)(s2 = (ItemStack)this.getInput())) : !(s1 = (FluidStack)offer.getInput()).isFluidEqual((FluidStack)(s2 = (FluidStack)this.getInput())) || s1.amount != s2.amount) {
                return false;
            }
            if (offer.getOutput() instanceof ItemStack ? !ItemStack.func_77989_b((ItemStack)(s1 = (ItemStack)offer.getOutput()), (ItemStack)(s2 = (ItemStack)this.getOutput())) : !(s1 = (FluidStack)offer.getOutput()).isFluidEqual((FluidStack)(s2 = (FluidStack)this.getOutput())) || s1.amount != s2.amount) {
                return false;
            }
            return this.getVendor().equals(offer.getVendor());
        }
        return false;
    }
}

