/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.progwidgets;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.gui.GuiProgrammer;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.IProgWidget;
import pneumaticCraft.common.progwidgets.IVariableSetWidget;
import pneumaticCraft.common.progwidgets.IVariableWidget;
import pneumaticCraft.lib.Log;

public abstract class ProgWidget
implements IProgWidget {
    private int x;
    private int y;
    private IProgWidget[] connectedParameters;
    private IProgWidget outputStepConnection;
    private IProgWidget parent;

    public ProgWidget() {
        if (this.getParameters() != null) {
            this.connectedParameters = new IProgWidget[this.getParameters().length * 2];
        }
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        curTooltip.add(EnumChatFormatting.DARK_AQUA + I18n.func_135052_a((String)("programmingPuzzle." + this.getWidgetString() + ".name"), (Object[])new Object[0]));
    }

    @Override
    public void renderExtraInfo() {
        if (this.getExtraStringInfo() != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String[] splittedInfo = WordUtils.wrap((String)this.getExtraStringInfo(), (int)40).split(System.getProperty("line.separator"));
            for (int i = 0; i < splittedInfo.length; ++i) {
                int stringLength = fr.func_78256_a(splittedInfo[i]);
                int startX = this.getWidth() / 2 - stringLength / 4;
                int startY = this.getHeight() / 2 - (fr.field_78288_b + 1) * (splittedInfo.length - 1) / 4 + (fr.field_78288_b + 1) * i / 2 - fr.field_78288_b / 4;
                Gui.func_73734_a((int)(startX * 2 - 1), (int)(startY * 2 - 1), (int)(startX * 2 + stringLength + 1), (int)(startY * 2 + fr.field_78288_b + 1), (int)-1);
                fr.func_78276_b(splittedInfo[i], startX * 2, startY * 2, -16777216);
            }
            GL11.glPopMatrix();
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        }
    }

    public String getExtraStringInfo() {
        return null;
    }

    @Override
    public void addWarnings(List<String> curInfo, List<IProgWidget> widgets) {
        if (this instanceof IVariableWidget) {
            HashSet<String> variables = new HashSet<String>();
            ((IVariableWidget)((Object)this)).addVariables(variables);
            for (String variable : variables) {
                if (variable.equals("") || variable.startsWith("#") || variable.startsWith("$") || this.isVariableSetAnywhere(widgets, variable)) continue;
                curInfo.add(StatCollector.func_74837_a((String)"gui.progWidget.general.warning.variableNeverSet", (Object[])new Object[]{variable}));
            }
        }
    }

    private boolean isVariableSetAnywhere(List<IProgWidget> widgets, String variable) {
        if (variable.equals("")) {
            return true;
        }
        for (IProgWidget widget : widgets) {
            if (!(widget instanceof IVariableSetWidget)) continue;
            HashSet<String> variables = new HashSet<String>();
            ((IVariableSetWidget)((Object)widget)).addVariables(variables);
            if (!variables.contains(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        if (!this.hasStepInput() && this.hasStepOutput() && this.outputStepConnection == null) {
            curInfo.add("gui.progWidget.general.error.noPieceConnected");
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return 30;
    }

    @Override
    public int getHeight() {
        return this.getParameters() != null ? this.getParameters().length * 22 : 22;
    }

    @Override
    public void setParent(IProgWidget widget) {
        this.parent = widget;
    }

    @Override
    public IProgWidget getParent() {
        return this.parent;
    }

    @Override
    public void render() {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.getTexture());
        int width = this.getWidth() + (this.getParameters() != null && this.getParameters().length > 0 ? 10 : 0);
        int height = this.getHeight() + (this.hasStepOutput() ? 10 : 0);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        t.func_78374_a(0.0, (double)height, 0.0, 0.0, 1.0);
        t.func_78374_a((double)width, (double)height, 0.0, 1.0, 1.0);
        t.func_78374_a((double)width, 0.0, 0.0, 1.0, 0.0);
        t.func_78381_a();
    }

    protected abstract ResourceLocation getTexture();

    @Override
    public boolean hasStepOutput() {
        return this.hasStepInput();
    }

    @Override
    public EntityAIBase getWidgetTargetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return null;
    }

    @Override
    public void setParameter(int index, IProgWidget parm) {
        if (this.connectedParameters != null) {
            this.connectedParameters[index] = parm;
        }
    }

    @Override
    public boolean canSetParameter(int index) {
        if (this.connectedParameters != null) {
            return this.hasBlacklist() || index < this.connectedParameters.length / 2;
        }
        return false;
    }

    protected boolean hasBlacklist() {
        return true;
    }

    @Override
    public IProgWidget[] getConnectedParameters() {
        return this.connectedParameters;
    }

    @Override
    public void setOutputWidget(IProgWidget widget) {
        this.outputStepConnection = widget;
    }

    @Override
    public IProgWidget getOutputWidget() {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        return this.outputStepConnection;
    }

    @Override
    public IProgWidget copy() {
        try {
            IProgWidget copy = (IProgWidget)this.getClass().newInstance();
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag);
            copy.readFromNBT(tag);
            return copy;
        }
        catch (Exception e) {
            Log.error("Error occured when trying to copy an " + this.getWidgetString() + " widget.");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.getWidgetString());
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return null;
    }

    public static List getConnectedWidgetList(IProgWidget widget, int parameterIndex) {
        IProgWidget connectingWidget = widget.getConnectedParameters()[parameterIndex];
        if (connectingWidget != null) {
            ArrayList<IProgWidget> list = new ArrayList<IProgWidget>();
            while (connectingWidget != null) {
                list.add(connectingWidget);
                connectingWidget = connectingWidget.getConnectedParameters()[0];
            }
            return list;
        }
        return null;
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return this.getWidgetAI(drone, widget) != null;
    }
}

