/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import pneumaticCraft.common.network.LocationIntPacket;
import pneumaticCraft.common.tileentity.IGUITextFieldSensitive;

public class PacketUpdateTextfield
extends LocationIntPacket<PacketUpdateTextfield> {
    private int textFieldID;
    private String text;

    public PacketUpdateTextfield() {
    }

    public PacketUpdateTextfield(TileEntity te, int textfieldID) {
        super(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        this.textFieldID = textfieldID;
        this.text = ((IGUITextFieldSensitive)te).getText(textfieldID);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.textFieldID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.text);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.textFieldID = buffer.readInt();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(PacketUpdateTextfield message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketUpdateTextfield message, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof IGUITextFieldSensitive) {
            ((IGUITextFieldSensitive)te).setText(message.textFieldID, message.text);
        }
    }
}

