/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.minigun;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.item.IPressurizable;
import pneumaticCraft.client.render.RenderProgressingLine;
import pneumaticCraft.client.util.RenderUtils;
import pneumaticCraft.common.config.Config;
import pneumaticCraft.common.item.ItemGunAmmo;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public abstract class Minigun {
    private final boolean requiresTarget;
    private final double raytraceRange = 50.0;
    private double minigunSpeed;
    private int minigunTriggerTimeOut;
    public static final double MAX_GUN_SPEED = 0.4;
    private static final double MAX_GUN_YAW_CHANGE = 10.0;
    private static final double MAX_GUN_PITCH_CHANGE = 10.0;
    private int minigunSoundCounter = -1;
    private final Random rand = new Random();
    private double minigunRotation;
    private double oldMinigunRotation;
    public double minigunYaw;
    public double oldMinigunYaw;
    public double minigunPitch;
    public double oldMinigunPitch;
    private final RenderProgressingLine minigunFire = new RenderProgressingLine().setProgress(1.0f);
    private boolean sweeping;
    private double sweepingProgress;
    private boolean gunAimedAtTarget;
    protected IPressurizable pressurizable;
    private int airUsage;
    protected ItemStack stack;
    protected ItemStack ammo;
    protected EntityPlayer player;
    protected World world;
    protected EntityLivingBase attackTarget;

    public Minigun(boolean requiresTarget) {
        this.requiresTarget = requiresTarget;
    }

    public Minigun setPressurizable(IPressurizable pressurizable, int airUsage) {
        this.pressurizable = pressurizable;
        this.airUsage = airUsage;
        return this;
    }

    public Minigun setItemStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public Minigun setAmmo(ItemStack ammo) {
        this.ammo = ammo;
        return this;
    }

    public Minigun setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public Minigun setWorld(World world) {
        this.world = world;
        return this;
    }

    public Minigun setAttackTarget(EntityLivingBase entity) {
        this.attackTarget = entity;
        return this;
    }

    public abstract boolean isMinigunActivated();

    public abstract void setMinigunActivated(boolean var1);

    public abstract void setAmmoColorStack(ItemStack var1);

    public abstract int getAmmoColor();

    public abstract void playSound(String var1, float var2, float var3);

    protected int getAmmoColor(ItemStack stack) {
        return stack != null ? stack.func_77973_b().func_82790_a(stack, 1) : -13553359;
    }

    public double getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void setMinigunSpeed(double minigunSpeed) {
        this.minigunSpeed = minigunSpeed;
    }

    public int getMinigunTriggerTimeOut() {
        return this.minigunTriggerTimeOut;
    }

    public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
        this.minigunTriggerTimeOut = minigunTriggerTimeOut;
    }

    public int getMinigunSoundCounter() {
        return this.minigunSoundCounter;
    }

    public void setMinigunSoundCounter(int minigunSoundCounter) {
        this.minigunSoundCounter = minigunSoundCounter;
    }

    public double getMinigunRotation() {
        return this.minigunRotation;
    }

    public void setMinigunRotation(double minigunRotation) {
        this.minigunRotation = minigunRotation;
    }

    public double getOldMinigunRotation() {
        return this.oldMinigunRotation;
    }

    public void setOldMinigunRotation(double oldMinigunRotation) {
        this.oldMinigunRotation = oldMinigunRotation;
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public void setSweeping(boolean sweeping) {
        this.sweeping = sweeping;
    }

    public boolean isSweeping() {
        return this.sweeping;
    }

    public boolean tryFireMinigun(EntityLivingBase target) {
        boolean lastShotOfAmmo = false;
        if (this.ammo != null && (this.pressurizable == null || this.pressurizable.getPressure(this.stack) > 0.0f)) {
            this.setMinigunTriggerTimeOut(Math.max(10, this.getMinigunSoundCounter()));
            if (this.getMinigunSpeed() == 0.4 && (!this.requiresTarget || this.gunAimedAtTarget)) {
                if (!this.requiresTarget) {
                    target = this.raytraceTarget();
                }
                lastShotOfAmmo = this.ammo.func_96631_a(1, this.rand);
                if (this.pressurizable != null) {
                    this.pressurizable.addAir(this.stack, -this.airUsage);
                }
                if (target != null) {
                    ItemStack potion = ItemGunAmmo.getPotion(this.ammo);
                    if (potion != null) {
                        List effects;
                        if (this.rand.nextInt(20) == 0 && (effects = Items.field_151068_bn.func_77832_l(potion)) != null) {
                            for (PotionEffect effect : effects) {
                                target.func_70690_d(new PotionEffect(effect));
                            }
                        }
                    } else {
                        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.player), Config.configMinigunDamage);
                    }
                }
            }
        }
        return lastShotOfAmmo;
    }

    private EntityLivingBase raytraceTarget() {
        MovingObjectPosition mop = PneumaticCraftUtils.getMouseOverServer((EntityLivingBase)this.player, 50.0);
        return mop != null && mop.field_72308_g instanceof EntityLivingBase ? (EntityLivingBase)mop.field_72308_g : null;
    }

    public void update(double posX, double posY, double posZ) {
        this.setOldMinigunRotation(this.getMinigunRotation());
        this.oldMinigunYaw = this.minigunYaw;
        this.oldMinigunPitch = this.minigunPitch;
        if (this.attackTarget != null && this.attackTarget.field_70128_L) {
            this.attackTarget = null;
        }
        if (!this.world.field_72995_K) {
            this.setMinigunActivated(this.getMinigunTriggerTimeOut() > 0);
            this.setAmmoColorStack(this.ammo);
            if (this.getMinigunTriggerTimeOut() > 0) {
                this.setMinigunTriggerTimeOut(this.getMinigunTriggerTimeOut() - 1);
                if (this.getMinigunSpeed() == 0.0) {
                    this.playSound("pneumaticcraft:hudInit", 2.0f, 0.9f);
                }
            }
            if (this.getMinigunSoundCounter() == 0 && this.getMinigunTriggerTimeOut() == 0) {
                this.playSound("pneumaticcraft:minigunStop", 3.0f, 0.5f);
                this.setMinigunSoundCounter(-1);
            }
        }
        if (this.isMinigunActivated()) {
            this.setMinigunSpeed(Math.min(this.getMinigunSpeed() + 0.01, 0.4));
        } else {
            this.setMinigunSpeed(Math.max(0.0, this.getMinigunSpeed() - 0.003));
        }
        this.setMinigunRotation(this.getMinigunRotation() + this.getMinigunSpeed());
        double targetYaw = 0.0;
        double targetPitch = 0.0;
        if (this.attackTarget != null) {
            double deltaX = posX - this.attackTarget.field_70165_t;
            double deltaZ = posZ - this.attackTarget.field_70161_v;
            targetYaw = deltaX >= 0.0 && deltaZ < 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 : (deltaX >= 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 90.0 : (deltaX < 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 + 180.0 : Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 270.0));
            if (targetYaw - this.minigunYaw > 180.0) {
                targetYaw -= 360.0;
            } else if (this.minigunYaw - targetYaw > 180.0) {
                targetYaw += 360.0;
            }
            targetPitch = Math.toDegrees(Math.atan((posY - this.attackTarget.field_70163_u - (double)(this.attackTarget.field_70131_O / 2.0f)) / PneumaticCraftUtils.distBetween(posX, posZ, this.attackTarget.field_70165_t, this.attackTarget.field_70161_v)));
            this.minigunPitch = this.minigunPitch > targetPitch ? (this.minigunPitch - 10.0 > targetPitch ? (this.minigunPitch -= 10.0) : targetPitch) : (this.minigunPitch + 10.0 < targetPitch ? (this.minigunPitch += 10.0) : targetPitch);
            this.minigunYaw = this.minigunPitch < -80.0 || this.minigunPitch > 80.0 ? targetYaw : (this.minigunYaw > targetYaw ? (this.minigunYaw - 10.0 > targetYaw ? (this.minigunYaw -= 10.0) : targetYaw) : (this.minigunYaw + 10.0 < targetYaw ? (this.minigunYaw += 10.0) : targetYaw));
            this.gunAimedAtTarget = this.minigunYaw == targetYaw && this.minigunPitch == targetPitch;
        } else if (this.isSweeping()) {
            this.minigunYaw -= Math.cos(this.sweepingProgress) * 22.0;
            this.sweepingProgress += 0.05;
            this.minigunYaw += Math.cos(this.sweepingProgress) * 22.0;
            this.minigunPitch = this.minigunPitch > targetPitch ? (this.minigunPitch - 10.0 > targetPitch ? (this.minigunPitch -= 10.0) : targetPitch) : (this.minigunPitch + 10.0 < targetPitch ? (this.minigunPitch += 10.0) : targetPitch);
        }
        if (!this.world.field_72995_K && this.isMinigunActivated() && this.getMinigunSpeed() == 0.4 && (!this.requiresTarget || this.gunAimedAtTarget && this.attackTarget != null) && this.getMinigunSoundCounter() <= 0) {
            this.playSound("pneumaticcraft:minigun", 0.3f, 1.0f);
            this.setMinigunSoundCounter(20);
        }
        if (this.getMinigunSoundCounter() > 0) {
            this.setMinigunSoundCounter(this.getMinigunSoundCounter() - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(double x, double y, double z, double gunRadius) {
        if (this.isMinigunActivated() && this.getMinigunSpeed() == 0.4 && this.gunAimedAtTarget && this.attackTarget != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
            GL11.glDisable((int)3553);
            RenderUtils.glColorHex(0xFF000000 | this.getAmmoColor());
            for (int i = 0; i < 5; ++i) {
                Vec3 vec = Vec3.func_72443_a((double)(this.attackTarget.field_70165_t - x), (double)(this.attackTarget.field_70163_u - y), (double)(this.attackTarget.field_70161_v - z)).func_72432_b();
                this.minigunFire.startX = x + vec.field_72450_a * gunRadius;
                this.minigunFire.startY = y + vec.field_72448_b * gunRadius;
                this.minigunFire.startZ = z + vec.field_72449_c * gunRadius;
                this.minigunFire.endX = this.attackTarget.field_70165_t + this.rand.nextDouble() - 0.5;
                this.minigunFire.endY = this.attackTarget.field_70163_u + (double)(this.attackTarget.field_70131_O / 2.0f) + this.rand.nextDouble() - 0.5;
                this.minigunFire.endZ = this.attackTarget.field_70161_v + this.rand.nextDouble() - 0.5;
                this.minigunFire.render();
            }
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }
    }
}

