/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.thirdparty.ModInteractionUtils;
import pneumaticCraft.common.tileentity.TileEntityPneumaticBase;
import pneumaticCraft.common.tileentity.TileEntityPressureTube;
import pneumaticCraft.common.util.TileEntityCache;

public class ModuleNetworkManager {
    private static ModuleNetworkManager INSTANCE = new ModuleNetworkManager();
    private final List<Set<TubeModule>> connectedModules = new ArrayList<Set<TubeModule>>();

    public static ModuleNetworkManager getInstance() {
        return INSTANCE;
    }

    public void addModule(TubeModule module) {
    }

    public Set<TubeModule> getConnectedModules(TubeModule module) {
        HashSet<TubeModule> modules = new HashSet<TubeModule>();
        HashSet<TileEntityPressureTube> traversedTubes = new HashSet<TileEntityPressureTube>();
        Stack<TileEntityPressureTube> pendingTubes = new Stack<TileEntityPressureTube>();
        pendingTubes.push((TileEntityPressureTube)module.getTube());
        while (!pendingTubes.isEmpty()) {
            TileEntityPressureTube tube = (TileEntityPressureTube)pendingTubes.pop();
            for (TubeModule m : tube.modules) {
                if (m == null) continue;
                modules.add(m);
            }
            TileEntityCache[] cache = ((TileEntityPneumaticBase)tube.getAirHandler()).getTileCache();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                TileEntityPressureTube newTube;
                if (!tube.sidesConnected[d.ordinal()] || (newTube = ModInteractionUtils.getInstance().getTube(cache[d.ordinal()].getTileEntity())) == null || traversedTubes.contains(newTube)) continue;
                pendingTubes.add(newTube);
                traversedTubes.add(newTube);
            }
        }
        return modules;
    }
}

