/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.block.tubes;

import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.client.model.IBaseModel;
import pneumaticCraft.client.model.tubemodules.ModelLogisticsModule;
import pneumaticCraft.client.util.RenderUtils;
import pneumaticCraft.common.ai.LogisticsManager;
import pneumaticCraft.common.block.tubes.ModuleNetworkManager;
import pneumaticCraft.common.block.tubes.TubeModule;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketUpdateLogisticModule;
import pneumaticCraft.common.semiblock.ISemiBlock;
import pneumaticCraft.common.semiblock.SemiBlockLogistics;
import pneumaticCraft.common.semiblock.SemiBlockManager;
import pneumaticCraft.common.tileentity.TileEntityPlasticMixer;
import pneumaticCraft.common.util.IOHelper;
import pneumaticCraft.common.util.PneumaticCraftUtils;
import pneumaticCraft.proxy.CommonProxy;

public class ModuleLogistics
extends TubeModule {
    private static final ModelLogisticsModule model = new ModelLogisticsModule();
    private SemiBlockLogistics cachedFrame;
    private int colorChannel;
    private int ticksSinceAction = -1;
    private int ticksSinceNotEnoughAir = -1;
    private int ticksUntilNextCycle;
    private boolean powered;
    private static final double MIN_PRESSURE = 3.0;
    private static final double ITEM_TRANSPORT_COST = 5.0;
    private static final double FLUID_TRANSPORT_COST = 0.1;

    @Override
    public double getWidth() {
        return 0.8125;
    }

    @Override
    protected double getHeight() {
        return 0.28125;
    }

    @Override
    public String getType() {
        return "logisticsModule";
    }

    @Override
    public IBaseModel getModel() {
        ModuleLogistics.model.base1 = this.ticksSinceAction >= 0 ? ModuleLogistics.model.action : (this.ticksSinceNotEnoughAir >= 0 ? ModuleLogistics.model.notEnoughAir : (this.hasPower() ? ModuleLogistics.model.powered : ModuleLogistics.model.notPowered));
        return model;
    }

    @Override
    protected void renderModule() {
        super.renderModule();
        RenderUtils.glColorHex(0xFF000000 | ItemDye.field_150922_c[this.getColorChannel()]);
        model.renderChannelColorFrame(0.0625f);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    @Override
    protected CommonProxy.EnumGuiId getGuiId() {
        return null;
    }

    public int getColorChannel() {
        return this.colorChannel;
    }

    public void setColorChannel(int colorChannel) {
        this.colorChannel = colorChannel;
    }

    public boolean hasPower() {
        return this.powered;
    }

    public void onUpdatePacket(int status, int colorChannel) {
        boolean bl = this.powered = status > 0;
        if (status == 2) {
            this.ticksSinceAction = 0;
        }
        if (status == 3) {
            this.ticksSinceNotEnoughAir = 0;
        }
        this.colorChannel = colorChannel;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powered", this.powered);
        nbt.func_74774_a("colorChannel", (byte)this.colorChannel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powered = nbt.func_74767_n("powered");
        this.colorChannel = nbt.func_74771_c("colorChannel");
    }

    public SemiBlockLogistics getFrame() {
        ISemiBlock semiBlock;
        if (this.cachedFrame == null && (semiBlock = SemiBlockManager.getInstance(this.getTube().world()).getSemiBlock(this.getTube().world(), this.getTube().x() + this.dir.offsetX, this.getTube().y() + this.dir.offsetY, this.getTube().z() + this.dir.offsetZ)) instanceof SemiBlockLogistics) {
            this.cachedFrame = (SemiBlockLogistics)semiBlock;
        }
        return this.cachedFrame;
    }

    @Override
    public boolean onActivated(EntityPlayer player) {
        int colorIndex;
        if (player.func_71045_bC() != null && (colorIndex = TileEntityPlasticMixer.getDyeIndex(player.func_71045_bC())) >= 0) {
            if (!player.field_70170_p.field_72995_K) {
                this.colorChannel = colorIndex;
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(this, 0), this.getTube().world());
            }
            return true;
        }
        return super.onActivated(player);
    }

    @Override
    public void update() {
        super.update();
        if (this.cachedFrame != null && this.cachedFrame.isInvalid()) {
            this.cachedFrame = null;
        }
        if (!this.getTube().world().field_72995_K) {
            if (this.powered != (double)this.getTube().getAirHandler().getPressure(null) >= 3.0) {
                this.powered = !this.powered;
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(this, 0), this.getTube().world());
            }
            if (--this.ticksUntilNextCycle <= 0) {
                LogisticsManager manager = new LogisticsManager();
                HashMap<SemiBlockLogistics, ModuleLogistics> frameToModuleMap = new HashMap<SemiBlockLogistics, ModuleLogistics>();
                for (TubeModule module : ModuleNetworkManager.getInstance().getConnectedModules(this)) {
                    ModuleLogistics logistics;
                    if (!(module instanceof ModuleLogistics) || (logistics = (ModuleLogistics)module).getColorChannel() != this.getColorChannel()) continue;
                    logistics.ticksUntilNextCycle = 100;
                    if (!logistics.hasPower() || logistics.getFrame() == null) continue;
                    frameToModuleMap.put(logistics.getFrame(), logistics);
                    manager.addLogisticFrame(logistics.getFrame());
                }
                PriorityQueue<LogisticsManager.LogisticsTask> tasks = manager.getTasks(null);
                block1: for (LogisticsManager.LogisticsTask task : tasks) {
                    if (!task.isStillValid(task.transportingItem != null ? task.transportingItem : task.transportingFluid.stack)) continue;
                    if (task.transportingItem != null) {
                        ItemStack extractedStack;
                        ItemStack remainder = IOHelper.insert(task.requester.getTileEntity(), task.transportingItem.func_77946_l(), true);
                        if (remainder != null && remainder.field_77994_a == task.transportingItem.field_77994_a) continue;
                        ItemStack toBeExtracted = task.transportingItem.func_77946_l();
                        if (remainder != null) {
                            toBeExtracted.field_77994_a -= remainder.field_77994_a;
                        }
                        if ((extractedStack = IOHelper.extract(task.provider.getTileEntity(), toBeExtracted, true)) == null) continue;
                        ModuleLogistics provider = (ModuleLogistics)frameToModuleMap.get(task.provider);
                        ModuleLogistics requester = (ModuleLogistics)frameToModuleMap.get(task.requester);
                        int airUsed = (int)(5.0 * (double)extractedStack.field_77994_a * Math.pow(PneumaticCraftUtils.distBetweenSq(provider.getTube().x(), provider.getTube().y(), provider.getTube().z(), requester.getTube().x(), requester.getTube().y(), requester.getTube().z()), 0.25));
                        if (requester.getTube().getAirHandler().getCurrentAir(null) > airUsed) {
                            this.sendModuleUpdate(provider, true);
                            this.sendModuleUpdate(requester, true);
                            requester.getTube().getAirHandler().addAir(-airUsed, (ForgeDirection)null);
                            IOHelper.extract(task.provider.getTileEntity(), extractedStack, false);
                            IOHelper.insert(task.requester.getTileEntity(), extractedStack, false);
                            this.ticksUntilNextCycle = 20;
                            continue;
                        }
                        this.sendModuleUpdate(provider, false);
                        this.sendModuleUpdate(requester, false);
                        continue;
                    }
                    TileEntity providingTE = task.provider.getTileEntity();
                    TileEntity requestingTE = task.requester.getTileEntity();
                    if (!(providingTE instanceof IFluidHandler) || !(requestingTE instanceof IFluidHandler)) continue;
                    IFluidHandler provider = (IFluidHandler)task.provider.getTileEntity();
                    IFluidHandler requester = (IFluidHandler)task.requester.getTileEntity();
                    for (ForgeDirection di : ForgeDirection.VALID_DIRECTIONS) {
                        int amountFilled = requester.fill(di, task.transportingFluid.stack, false);
                        if (amountFilled <= 0) continue;
                        FluidStack drainingFluid = task.transportingFluid.stack.copy();
                        drainingFluid.amount = amountFilled;
                        FluidStack extractedFluid = null;
                        ModuleLogistics p = (ModuleLogistics)frameToModuleMap.get(task.provider);
                        ModuleLogistics r = (ModuleLogistics)frameToModuleMap.get(task.requester);
                        int airUsed = 0;
                        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                            extractedFluid = provider.drain(d, drainingFluid, false);
                            if (extractedFluid == null) continue;
                            airUsed = (int)(0.1 * (double)extractedFluid.amount * PneumaticCraftUtils.distBetween(p.getTube().x(), p.getTube().y(), p.getTube().z(), r.getTube().x(), r.getTube().y(), r.getTube().z()));
                            if (r.getTube().getAirHandler().getCurrentAir(null) > airUsed) {
                                extractedFluid = provider.drain(d, drainingFluid, true);
                                break;
                            }
                            this.sendModuleUpdate(p, false);
                            this.sendModuleUpdate(r, false);
                            extractedFluid = null;
                            break;
                        }
                        if (extractedFluid == null) continue block1;
                        this.sendModuleUpdate(p, true);
                        this.sendModuleUpdate(r, true);
                        r.getTube().getAirHandler().addAir(-airUsed, (ForgeDirection)null);
                        requester.fill(di, extractedFluid, true);
                        this.ticksUntilNextCycle = 20;
                        continue block1;
                    }
                }
            }
        } else {
            if (this.ticksSinceAction >= 0) {
                ++this.ticksSinceAction;
                if (this.ticksSinceAction > 3) {
                    this.ticksSinceAction = -1;
                }
            }
            if (this.ticksSinceNotEnoughAir >= 0) {
                ++this.ticksSinceNotEnoughAir;
                if (this.ticksSinceNotEnoughAir > 20) {
                    this.ticksSinceNotEnoughAir = -1;
                }
            }
        }
    }

    private void sendModuleUpdate(ModuleLogistics module, boolean enoughAir) {
        NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(module, enoughAir ? 1 : 2), module.getTube().world());
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        String status = this.ticksSinceAction >= 0 ? "waila.logisticsModule.transporting" : (this.ticksSinceNotEnoughAir >= 0 ? "waila.logisticsModule.notEnoughAir" : (this.hasPower() ? "waila.logisticsModule.powered" : "waila.logisticsModule.noPower"));
        curInfo.add(StatCollector.func_74838_a((String)"hud.msg.state") + ": " + StatCollector.func_74838_a((String)status));
        curInfo.add(StatCollector.func_74838_a((String)"waila.logisticsModule.channel") + " " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)("item.fireworksCharge." + ItemDye.field_150923_a[this.colorChannel])));
    }
}

