/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import pneumaticCraft.common.ai.DroneClaimManager;
import pneumaticCraft.common.entity.living.EntityDrone;
import pneumaticCraft.common.tileentity.TileEntityChargingStation;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class DroneGoToChargingStation
extends EntityAIBase {
    private final EntityDrone drone;
    public boolean isExecuting;
    public TileEntityChargingStation curCharger;
    private int chargingTime;

    public DroneGoToChargingStation(EntityDrone drone) {
        this.drone = drone;
        this.func_75248_a(63);
    }

    public boolean func_75250_a() {
        ChunkPosition pos;
        ArrayList<TileEntityChargingStation> validChargingStations = new ArrayList<TileEntityChargingStation>();
        if (this.drone.getPressure(null) < 1.0f) {
            for (TileEntity te : this.drone.field_70170_p.field_147482_g) {
                if (!(te instanceof TileEntityChargingStation)) continue;
                TileEntityChargingStation station = (TileEntityChargingStation)te;
                pos = new ChunkPosition(station.field_145851_c, station.field_145848_d, station.field_145849_e);
                if (DroneClaimManager.getInstance(this.drone.field_70170_p).isClaimed(pos)) {
                    this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.claimed", pos);
                    continue;
                }
                if (station.getPressure(ForgeDirection.UNKNOWN) <= 1.0f) {
                    this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.notEnoughPressure", pos);
                    continue;
                }
                if (station.getUpgrades(1) == 0) {
                    this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.noDispenserUpgrades", pos);
                    continue;
                }
                validChargingStations.add(station);
            }
        }
        Collections.sort(validChargingStations, new Comparator(){

            public int compare(Object arg1, Object arg2) {
                TileEntity te1 = (TileEntity)arg1;
                TileEntity te2 = (TileEntity)arg2;
                return Double.compare(PneumaticCraftUtils.distBetween(te1.field_145851_c, te1.field_145848_d, te1.field_145849_e, ((DroneGoToChargingStation)DroneGoToChargingStation.this).drone.field_70165_t, ((DroneGoToChargingStation)DroneGoToChargingStation.this).drone.field_70163_u, ((DroneGoToChargingStation)DroneGoToChargingStation.this).drone.field_70161_v), PneumaticCraftUtils.distBetween(te2.field_145851_c, te2.field_145848_d, te2.field_145849_e, ((DroneGoToChargingStation)DroneGoToChargingStation.this).drone.field_70165_t, ((DroneGoToChargingStation)DroneGoToChargingStation.this).drone.field_70163_u, ((DroneGoToChargingStation)DroneGoToChargingStation.this).drone.field_70161_v));
            }
        });
        for (TileEntityChargingStation station : validChargingStations) {
            boolean protect = PneumaticCraftUtils.getProtectingSecurityStations(this.drone.field_70170_p, station.field_145851_c, station.field_145848_d, station.field_145849_e, (EntityPlayer)this.drone.getFakePlayer(), false, false) > 0;
            pos = new ChunkPosition(station.field_145851_c, station.field_145848_d, station.field_145849_e);
            if (protect) {
                this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.protected", pos);
                continue;
            }
            if (this.drone.getPathNavigator().moveToXYZ(station.field_145851_c, (double)station.field_145848_d + 1.5, station.field_145849_e) || this.drone.getPathNavigator().isGoingToTeleport()) {
                this.isExecuting = true;
                this.curCharger = station;
                DroneClaimManager.getInstance(this.drone.field_70170_p).claim(pos);
                return true;
            }
            this.drone.addDebugEntry("gui.progWidget.chargingStation.debug.cantNavigate", pos);
        }
        this.isExecuting = false;
        return false;
    }

    public boolean func_75253_b() {
        if (this.curCharger.getUpgrades(1) == 0 || this.curCharger.func_145837_r()) {
            this.isExecuting = false;
            return false;
        }
        if (!this.drone.getPathNavigator().isGoingToTeleport() && (this.drone.func_70661_as().func_75505_d() == null || this.drone.func_70661_as().func_75505_d().func_75879_b())) {
            boolean bl = this.isExecuting = this.drone.getPressure(null) < 9.9f && this.curCharger.getPressure(ForgeDirection.UNKNOWN) > this.drone.getPressure(null) + 0.1f;
            if (this.isExecuting) {
                ++this.chargingTime;
                if (this.chargingTime > 20) {
                    this.drone.getPathNavigator().moveToXYZ(this.curCharger.field_145851_c, (double)this.curCharger.field_145848_d + 1.5, this.curCharger.field_145849_e);
                    if (this.drone.func_70661_as().func_75505_d() == null || this.drone.func_70661_as().func_75505_d().func_75879_b()) {
                        this.drone.setStandby(true);
                    } else {
                        this.chargingTime = 0;
                    }
                }
                DroneClaimManager.getInstance(this.drone.field_70170_p).claim(new ChunkPosition(this.curCharger.field_145851_c, this.curCharger.field_145848_d, this.curCharger.field_145849_e));
            }
            return this.isExecuting;
        }
        this.chargingTime = 0;
        DroneClaimManager.getInstance(this.drone.field_70170_p).claim(new ChunkPosition(this.curCharger.field_145851_c, this.curCharger.field_145848_d, this.curCharger.field_145849_e));
        return this.drone.isAccelerating();
    }
}

