/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.common.ai;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import pneumaticCraft.common.ai.DroneAIImExBase;
import pneumaticCraft.common.ai.IDroneBase;
import pneumaticCraft.common.progwidgets.ICountWidget;
import pneumaticCraft.common.progwidgets.ILiquidExport;
import pneumaticCraft.common.progwidgets.ILiquidFiltered;
import pneumaticCraft.common.progwidgets.ISidedWidget;
import pneumaticCraft.common.progwidgets.ProgWidgetAreaItemBase;

public class DroneAILiquidExport
extends DroneAIImExBase {
    public DroneAILiquidExport(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(ChunkPosition pos) {
        return this.fillTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(ChunkPosition pos, double distToBlock) {
        return this.fillTank(pos, false) && super.doBlockInteraction(pos, distToBlock);
    }

    private boolean fillTank(ChunkPosition pos, boolean simulate) {
        if (this.drone.getTank().getFluidAmount() == 0) {
            this.drone.addDebugEntry("gui.progWidget.liquidExport.debug.emptyDroneTank");
            this.abort();
            return false;
        }
        TileEntity te = this.drone.getWorld().func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
        if (te instanceof IFluidHandler) {
            IFluidHandler tank = (IFluidHandler)te;
            FluidStack exportedFluid = this.drone.getTank().drain(Integer.MAX_VALUE, false);
            if (exportedFluid != null && ((ILiquidFiltered)((Object)this.widget)).isFluidValid(exportedFluid.getFluid())) {
                for (int i = 0; i < 6; ++i) {
                    int filledAmount;
                    if (!((ISidedWidget)((Object)this.widget)).getSides()[i] || (filledAmount = tank.fill(ForgeDirection.getOrientation((int)i), exportedFluid, false)) <= 0) continue;
                    if (((ICountWidget)((Object)this.widget)).useCount()) {
                        filledAmount = Math.min(filledAmount, this.getRemainingCount());
                    }
                    if (!simulate) {
                        this.decreaseCount(tank.fill(ForgeDirection.getOrientation((int)i), this.drone.getTank().drain(filledAmount, true), true));
                    }
                    return true;
                }
                this.drone.addDebugEntry("gui.progWidget.liquidExport.debug.filledToMax", pos);
            } else {
                this.drone.addDebugEntry("gui.progWidget.liquidExport.debug.noValidFluid");
            }
        } else if (((ILiquidExport)((Object)this.widget)).isPlacingFluidBlocks() && (!((ICountWidget)((Object)this.widget)).useCount() || this.getRemainingCount() >= 1000)) {
            Block fluidBlock = this.drone.getTank().getFluid().getFluid().getBlock();
            if (this.drone.getTank().getFluidAmount() >= 1000 && fluidBlock != null && this.drone.getWorld().func_147437_c(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) {
                if (!simulate) {
                    this.decreaseCount(1000);
                    this.drone.getTank().drain(1000, true);
                    this.drone.getWorld().func_147449_b(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, fluidBlock);
                }
                return true;
            }
        }
        return false;
    }
}

