/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client.render.pneumaticArmor;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import pneumaticCraft.api.client.pneumaticHelmet.IHackableBlock;
import pneumaticCraft.client.gui.widget.GuiAnimatedStat;
import pneumaticCraft.client.render.RenderProgressBar;
import pneumaticCraft.client.render.pneumaticArmor.BlockTrackUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.RenderBlockArrows;
import pneumaticCraft.client.render.pneumaticArmor.blockTracker.BlockTrackEntryInventory;
import pneumaticCraft.client.render.pneumaticArmor.blockTracker.BlockTrackEntryList;
import pneumaticCraft.client.render.pneumaticArmor.hacking.HackableHandler;
import pneumaticCraft.common.CommonHUDHandler;
import pneumaticCraft.common.network.NetworkHandler;
import pneumaticCraft.common.network.PacketDescriptionPacketRequest;
import pneumaticCraft.common.network.PacketHackingBlockStart;

public class RenderBlockTarget {
    private final World world;
    private final int blockX;
    private final int blockY;
    private final int blockZ;
    private final RenderBlockArrows arrowRenderer = new RenderBlockArrows();
    public int ticksExisted = 0;
    public final GuiAnimatedStat stat;
    private final EntityPlayer player;
    private boolean playerIsLooking;
    public List<String> textList = new ArrayList<String>();
    private int hackTime;
    private final BlockTrackUpgradeHandler blockTracker;
    private TileEntity te;

    public RenderBlockTarget(World world, EntityPlayer player, int x, int y, int z, TileEntity te, BlockTrackUpgradeHandler blockTracker) {
        this.world = world;
        this.player = player;
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.te = te;
        this.blockTracker = blockTracker;
        String title = world.func_147439_a(x, y, z).func_149732_F();
        if (title.contains(".name")) {
            try {
                ItemStack stack = world.func_147439_a(x, y, z).getPickBlock(FMLClientHandler.instance().getClient().field_71476_x, world, x, y, z, (EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
                if (stack != null) {
                    title = stack.func_82833_r();
                }
            }
            catch (Throwable stack) {
                // empty catch block
            }
        }
        if (title.contains(".name") && te instanceof IInventory) {
            try {
                title = I18n.func_135052_a((String)((IInventory)te).func_145825_b(), (Object[])new Object[0]);
            }
            catch (Throwable e) {
                BlockTrackEntryInventory.addTileEntityToBlackList(te, e);
            }
        }
        this.stat = new GuiAnimatedStat(null, title, "", 20, -20, 0x3000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public void setTileEntity(TileEntity te) {
        this.te = te;
    }

    public boolean isTargetStillValid() {
        return this.getApplicableEntries().size() > 0;
    }

    public List<IBlockTrackEntry> getApplicableEntries() {
        return BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ, this.te);
    }

    public boolean isSameTarget(World world, int x, int y, int z) {
        return this.blockX == x && this.blockY == y && this.blockZ == z;
    }

    public Block getBlock() {
        return this.world.func_147439_a(this.blockX, this.blockY, this.blockZ);
    }

    public double getDistanceToEntity(Entity entity) {
        return entity.func_70011_f((double)this.blockX + 0.5, (double)this.blockY + 0.5, (double)this.blockZ + 0.5);
    }

    public void update() {
        if (this.te != null && this.te.func_145837_r()) {
            this.te = null;
        }
        this.stat.update();
        List<IBlockTrackEntry> applicableTrackEntries = this.getApplicableEntries();
        if (CommonHUDHandler.getHandlerForPlayer().ticksExisted % 100 == 0) {
            boolean sentUpdate = false;
            for (IBlockTrackEntry entry : applicableTrackEntries) {
                if (!entry.shouldBeUpdatedFromServer(this.te) || sentUpdate) continue;
                NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(this.blockX, this.blockY, this.blockZ));
                sentUpdate = true;
            }
        }
        this.playerIsLooking = this.isPlayerLookingAtTarget();
        ++this.arrowRenderer.ticksExisted;
        if (!this.getBlock().isAir((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ)) {
            this.textList = new ArrayList<String>();
            if (this.ticksExisted > 120) {
                this.stat.closeWindow();
                for (IBlockTrackEntry entry : applicableTrackEntries) {
                    if (this.blockTracker.countBlockTrackersOfType(entry) > entry.spamThreshold()) continue;
                    this.stat.openWindow();
                    break;
                }
                if (this.playerIsLooking) {
                    this.stat.openWindow();
                    this.addBlockTrackInfo(this.textList);
                }
                this.stat.setText(this.textList);
            } else if (this.ticksExisted < -30) {
                this.stat.closeWindow();
                this.stat.setText(this.textList);
            }
        }
        if (this.hackTime > 0) {
            IHackableBlock hackableBlock = HackableHandler.getHackableForCoord((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ, this.player);
            this.hackTime = hackableBlock != null ? ++this.hackTime : 0;
        }
    }

    public void render(float partialTicks) {
        double x = (double)this.blockX + 0.5;
        double y = (double)this.blockY + 0.5;
        double z = (double)this.blockZ + 0.5;
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glClear((int)256);
        float red = 0.5f;
        float green = 0.5f;
        float blue = 1.0f;
        float alpha = 0.5f;
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (!this.getBlock().isAir((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ)) {
            this.arrowRenderer.render(this.world, this.blockX, this.blockY, this.blockZ, partialTicks);
        }
        int targetAcquireProgress = (int)((float)(this.ticksExisted - 50) / 0.7f);
        GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        if (this.ticksExisted <= 120 && this.ticksExisted > 50) {
            GL11.glColor4d((double)0.0, (double)1.0, (double)0.0, (double)0.8);
            RenderProgressBar.render(0.0, 0.4, 1.8, 0.9, 0.0, targetAcquireProgress);
        }
        GL11.glEnable((int)3553);
        if (!this.getBlock().isAir((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ)) {
            FontRenderer fontRenderer = RenderManager.field_78727_a.func_78716_a();
            GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
            if (this.ticksExisted > 120) {
                GL11.glScaled((double)0.02, (double)0.02, (double)0.02);
                this.stat.render(-1, -1, partialTicks);
            } else if (this.ticksExisted > 50) {
                GL11.glScaled((double)0.02, (double)0.02, (double)0.02);
                fontRenderer.func_78276_b("Acquiring Target...", 0, 0, 0x7F7F7F);
                fontRenderer.func_78276_b(targetAcquireProgress + "%", 37, 28, 12032);
            } else if (this.ticksExisted < -30) {
                GL11.glScaled((double)0.03, (double)0.03, (double)0.03);
                this.stat.render(-1, -1, partialTicks);
                fontRenderer.func_78276_b("Lost Target!", 0, 0, 0xFF0000);
            }
        }
        GL11.glPopMatrix();
    }

    public boolean isInitialized() {
        return this.ticksExisted >= 120;
    }

    public void addBlockTrackInfo(List<String> textList) {
        for (IBlockTrackEntry blockTrackEntry : this.getApplicableEntries()) {
            blockTrackEntry.addInformation(this.world, this.blockX, this.blockY, this.blockZ, this.te, textList);
        }
    }

    public boolean isPlayerLooking() {
        return this.playerIsLooking;
    }

    private boolean isPlayerLookingAtTarget() {
        Vec3 vec3 = this.player.func_70676_i(1.0f).func_72432_b();
        Vec3 vec31 = Vec3.func_72443_a((double)((double)this.blockX + 0.5 - this.player.field_70165_t), (double)((double)this.blockY + 0.5 - this.player.field_70163_u + (double)this.player.func_70047_e()), (double)((double)this.blockZ + 0.5 - this.player.field_70161_v));
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.025 / d0;
    }

    public void hack() {
        IHackableBlock block;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (block = HackableHandler.getHackableForCoord((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ, this.player)) != null && (this.hackTime == 0 || this.hackTime > block.getHackTime((IBlockAccess)this.world, this.blockX, this.blockY, this.blockZ, this.player))) {
            NetworkHandler.sendToServer(new PacketHackingBlockStart(this.blockX, this.blockY, this.blockZ));
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(MouseEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.handleMouseWheel(event.dwheel);
        }
        return false;
    }
}

