/*
 * Decompiled with CFR 0.152.
 */
package pneumaticCraft.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import pneumaticCraft.PneumaticCraft;
import pneumaticCraft.client.AreaShowHandler;
import pneumaticCraft.client.render.pneumaticArmor.DroneDebugUpgradeHandler;
import pneumaticCraft.client.render.pneumaticArmor.HUDHandler;
import pneumaticCraft.common.item.ItemGPSTool;
import pneumaticCraft.common.item.Itemss;
import pneumaticCraft.common.util.PneumaticCraftUtils;

public class AreaShowManager {
    private static AreaShowManager INSTANCE = new AreaShowManager();
    private final Map<ChunkPosition, AreaShowHandler> showHandlers = new HashMap<ChunkPosition, AreaShowHandler>();
    private World world;
    private DroneDebugUpgradeHandler droneDebugger;

    public static AreaShowManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        ItemStack helmet;
        HashSet<ChunkPosition> set;
        ChunkPosition gpsLocation;
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.partialTicks;
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.partialTicks;
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (AreaShowHandler handler : this.showHandlers.values()) {
            handler.render();
        }
        ItemStack curItem = player.func_71045_bC();
        if (curItem != null && curItem.func_77973_b() == Itemss.GPSTool && (gpsLocation = ItemGPSTool.getGPSLocation(curItem)) != null) {
            set = new HashSet<ChunkPosition>();
            set.add(gpsLocation);
            GL11.glDisable((int)2929);
            new AreaShowHandler(set, 0xFFFF00).render();
            GL11.glEnable((int)2929);
        }
        if ((helmet = player.func_82169_q(3)) != null && helmet.func_77973_b() == Itemss.pneumaticHelmet) {
            if (this.droneDebugger == null) {
                this.droneDebugger = HUDHandler.instance().getSpecificRenderer(DroneDebugUpgradeHandler.class);
            }
            set = this.droneDebugger.getShowingPositions();
            GL11.glDisable((int)2929);
            new AreaShowHandler(set, 0xFF0000).render();
            GL11.glEnable((int)2929);
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public AreaShowHandler showArea(ChunkPosition[] area, int color, TileEntity areaShower) {
        return this.showArea(new HashSet<ChunkPosition>(Arrays.asList(area)), color, areaShower);
    }

    public AreaShowHandler showArea(Set<ChunkPosition> area, int color, TileEntity areaShower) {
        if (areaShower == null) {
            return null;
        }
        this.removeHandlers(areaShower);
        AreaShowHandler handler = new AreaShowHandler(area, color);
        this.showHandlers.put(new ChunkPosition(areaShower.field_145851_c, areaShower.field_145848_d, areaShower.field_145849_e), handler);
        return handler;
    }

    public boolean isShowing(TileEntity te) {
        return this.showHandlers.containsKey(new ChunkPosition(te.field_145851_c, te.field_145848_d, te.field_145849_e));
    }

    public void removeHandlers(TileEntity te) {
        this.showHandlers.remove(new ChunkPosition(te.field_145851_c, te.field_145848_d, te.field_145849_e));
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        EntityPlayer player = PneumaticCraft.proxy.getPlayer();
        if (player != null) {
            if (player.field_70170_p != this.world) {
                this.world = player.field_70170_p;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                Iterator<ChunkPosition> iterator = this.showHandlers.keySet().iterator();
                while (iterator.hasNext()) {
                    ChunkPosition pos = iterator.next();
                    if (!(PneumaticCraftUtils.distBetween(pos, player.field_70165_t, player.field_70163_u, player.field_70161_v) < 32.0) || !this.world.func_147437_c(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) continue;
                    iterator.remove();
                }
            }
        }
    }
}

