/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.waterhooks.config;

import info.loenwind.waterhooks.config.Section;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;

public enum Config {
    disableInfiniteWaterGlobally(Section.WATERHOOK, false, "Disable vanilla infinite water forming completely");

    @Nonnull
    private final Section section;
    @Nonnull
    private final Boolean defaultValue;
    @Nonnull
    private final String description;
    @Nonnull
    private Boolean currentValue;

    private Config(@Nonnull Section section, Boolean defaultValue, String description) {
        this.section = section;
        this.description = description;
        this.currentValue = this.defaultValue = defaultValue;
    }

    void load(Configuration config) {
        this.setField(config.get(this.section.name, this.name(), this.defaultValue.booleanValue(), this.description).getBoolean(this.defaultValue.booleanValue()));
    }

    private void setField(Boolean value) {
        if (value != null) {
            this.currentValue = value;
        }
    }

    void store(ByteBuf buf) {
        buf.writeBoolean(this.getBoolean());
    }

    void read(ByteBuf buf) {
        this.setField(buf.readBoolean());
    }

    protected void resetToDefault() {
        this.setField(this.defaultValue);
    }

    public Section getSection() {
        return this.section;
    }

    public boolean getDefaultBoolean() {
        return this.defaultValue;
    }

    public boolean getBoolean() {
        return this.currentValue;
    }
}

