/*
 * Decompiled with CFR 0.152.
 */
package com.tamashenning.forgeanalytics.client;

import com.tamashenning.forgeanalytics.AnalyticsClient;
import com.tamashenning.forgeanalytics.client.ForgeAnalyticsConstants;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class ForgeAnalyticsSingleton {
    private static ForgeAnalyticsSingleton instance = null;
    private AnalyticsClient ac = new AnalyticsClient();
    private Timer timer = new Timer();
    public String SessionID = this.CreateID();
    public UUID SessionUUID = UUID.randomUUID();

    protected ForgeAnalyticsSingleton() {
    }

    public static ForgeAnalyticsSingleton getInstance() {
        if (instance == null) {
            instance = new ForgeAnalyticsSingleton();
        }
        return instance;
    }

    public String CreateID() {
        String id = "";
        SecureRandom random = new SecureRandom();
        try {
            id = this.ac.Anonymize(new BigInteger(130, random).toString(32));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return id;
    }

    public void StartKeepAliveTimer(final boolean isClient) {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!isClient) {
                        ForgeAnalyticsSingleton.this.ac.UploadModel(ForgeAnalyticsSingleton.this.ac.CreateServerKeepAlivePing(), isClient);
                    } else {
                        ForgeAnalyticsSingleton.this.ac.UploadModel(ForgeAnalyticsSingleton.this.ac.CreateClientKeepAlivePing(), isClient);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, ForgeAnalyticsConstants.KEEPALIVETIME, (long)ForgeAnalyticsConstants.KEEPALIVETIME);
    }

    public void CancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

