/*
 * Decompiled with CFR 0.152.
 */
package com.tamashenning.forgeanalytics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tamashenning.forgeanalytics.ForgeAnalyticsMod;
import com.tamashenning.forgeanalytics.client.ForgeAnalyticsConstants;
import com.tamashenning.forgeanalytics.client.ForgeAnalyticsSingleton;
import com.tamashenning.forgeanalytics.events.AnalyticsEvent;
import com.tamashenning.forgeanalytics.models.AnalyticsModel;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class AnalyticsClient {
    protected final char[] hexArray = "0123456789abcdef".toCharArray();

    public boolean UploadModel(AnalyticsModel model, boolean isClient) throws Exception {
        if (!this.FireEvent(isClient)) {
            return false;
        }
        model.Properties.putAll(ForgeAnalyticsConstants.CustomProperties);
        JsonObject data = new JsonObject();
        data.add("PartitionKey", (JsonElement)new JsonPrimitive(model.PartitionKey));
        data.add("ClientDateTimeEpoch", (JsonElement)new JsonPrimitive((Number)model.ClientDateTimeEpoch));
        data.add("Table", (JsonElement)new JsonPrimitive(model.Table));
        JsonObject propertiesMap = new JsonObject();
        for (Map.Entry<String, String> entry : model.Properties.entrySet()) {
            if (ForgeAnalyticsConstants.dataConfig.get("general", entry.getKey() + "_OptOut", false).getBoolean()) continue;
            propertiesMap.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
        }
        data.add("Properties", (JsonElement)propertiesMap);
        String json = data.toString();
        JsonObject dataForge = new JsonObject();
        dataForge.add("cmd", (JsonElement)new JsonPrimitive(model.PartitionKey));
        for (Map.Entry<String, String> entry : model.Properties.entrySet()) {
            if (ForgeAnalyticsConstants.dataConfig.get("general", entry.getKey() + "_OptOut", false).getBoolean()) continue;
            dataForge.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
        }
        ForgeAnalyticsMod.logger.debug("JSON: " + json);
        ForgeAnalyticsMod.logger.debug("JSON: " + dataForge.toString());
        this.UploadForge(dataForge.toString());
        return this.UploadModel(json, isClient);
    }

    public AnalyticsModel CreateClientStartupPing() {
        AnalyticsModel am = new AnalyticsModel();
        am.Table = ForgeAnalyticsConstants.pingClientTable;
        am.Properties = new HashMap<String, String>();
        am.PartitionKey = ForgeAnalyticsConstants.pingClientStartCommand;
        am.ClientDateTimeEpoch = System.currentTimeMillis() / 1000L;
        am.Properties.putAll(this.getCommonValues());
        return am;
    }

    public AnalyticsModel CreateServerStartupPing() {
        AnalyticsModel am = new AnalyticsModel();
        am.Table = ForgeAnalyticsConstants.pingServerTable;
        am.Properties = new HashMap<String, String>();
        am.PartitionKey = ForgeAnalyticsConstants.pingServerStartCommand;
        am.ClientDateTimeEpoch = System.currentTimeMillis() / 1000L;
        am.Properties.putAll(this.getCommonValues());
        return am;
    }

    public AnalyticsModel CreateServerStoppedPing() {
        AnalyticsModel am = new AnalyticsModel();
        am.Table = ForgeAnalyticsConstants.pingServerTable;
        am.Properties = new HashMap<String, String>();
        am.PartitionKey = ForgeAnalyticsConstants.pingServerStopCommand;
        am.ClientDateTimeEpoch = System.currentTimeMillis() / 1000L;
        am.Properties.putAll(this.getCommonValues());
        return am;
    }

    public AnalyticsModel CreateClientKeepAlivePing() {
        AnalyticsModel am = new AnalyticsModel();
        am.Table = ForgeAnalyticsConstants.pingClientTable;
        am.Properties = new HashMap<String, String>();
        am.PartitionKey = ForgeAnalyticsConstants.pingClientKeepAlive;
        am.ClientDateTimeEpoch = System.currentTimeMillis() / 1000L;
        am.Properties.putAll(this.getCommonValues());
        return am;
    }

    public AnalyticsModel CreateServerKeepAlivePing() {
        AnalyticsModel am = new AnalyticsModel();
        am.Table = ForgeAnalyticsConstants.pingServerTable;
        am.Properties = new HashMap<String, String>();
        am.PartitionKey = ForgeAnalyticsConstants.pingServerKeepAlive;
        am.ClientDateTimeEpoch = System.currentTimeMillis() / 1000L;
        am.Properties.putAll(this.getCommonValues());
        return am;
    }

    public boolean FireEvent(boolean isClient) {
        if (isClient) {
            if (!Minecraft.func_71410_x().func_70002_Q()) {
                return false;
            }
            MinecraftForge.EVENT_BUS.post((Event)new AnalyticsEvent(Side.CLIENT));
        } else {
            try {
                if (!MinecraftServer.func_71276_C().func_70002_Q()) {
                    return false;
                }
                MinecraftForge.EVENT_BUS.post((Event)new AnalyticsEvent(Side.SERVER));
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private Map<String, String> getCommonValues() {
        HashMap<String, String> commonValues = new HashMap<String, String>();
        String activeModListCount = Integer.toString(Loader.instance().getActiveModList().size());
        String modListCount = Integer.toString(Loader.instance().getModList().size());
        commonValues.put("JavaVersion", System.getProperty("java.version"));
        commonValues.put("JavaMaxRAM", Long.toString(Runtime.getRuntime().maxMemory()));
        commonValues.put("JavaAllocatedRAM", Long.toString(Runtime.getRuntime().totalMemory()));
        commonValues.put("SessionID", ForgeAnalyticsSingleton.getInstance().SessionID);
        commonValues.put("AdID", ForgeAnalyticsConstants.AdID);
        commonValues.put("session_id", ForgeAnalyticsSingleton.getInstance().SessionUUID.toString());
        commonValues.put("instance_id", ForgeAnalyticsConstants.InstanceUUID.toString());
        commonValues.put("MinecraftVersion", Loader.instance().getMCVersionString());
        commonValues.put("ForgeVersion", ForgeVersion.getVersion());
        commonValues.put("MCPVersion", Loader.instance().getMCPVersionString());
        commonValues.put("ActiveModCount", activeModListCount);
        commonValues.put("ModCount", modListCount);
        commonValues.put("ModPack", ForgeAnalyticsConstants.modPack);
        return commonValues;
    }

    private boolean UploadModel(String json, boolean isClient) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpPost request = new HttpPost(ForgeAnalyticsConstants.serverUrl);
            StringEntity params = new StringEntity(json);
            request.addHeader("content-type", "application/json");
            request.setEntity(params);
            HttpResponse response = httpClient.execute(request);
            ForgeAnalyticsMod.logger.debug((Object)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private void UploadForge(String json) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpPost request = new HttpPost(ForgeAnalyticsConstants.forgeServerUrl);
            ArrayList<BasicNameValuePair> nvp = new ArrayList<BasicNameValuePair>();
            nvp.add(new BasicNameValuePair("stat", json));
            request.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)nvp));
            HttpResponse response = httpClient.execute(request);
            ForgeAnalyticsMod.logger.debug((Object)response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String Anonymize(String data) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] dataBytes = data.getBytes();
        for (int i = 0; i < ForgeAnalyticsConstants.HASHCOUNT; ++i) {
            dataBytes = sha256.digest(dataBytes);
        }
        return this.bytesToHex(dataBytes);
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = this.hexArray[v >>> 4];
            hexChars[j * 2 + 1] = this.hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

