/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.lesu;

import java.util.ArrayList;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.misc.Functions;
import reborncore.common.util.Inventory;
import techreborn.config.ConfigTechReborn;
import techreborn.powerSystem.TilePowerAcceptor;
import techreborn.tiles.lesu.LesuNetwork;
import techreborn.tiles.lesu.TileLesuStorage;

public class TileLesu
extends TilePowerAcceptor {
    private ArrayList<LesuNetwork> countedNetworks = new ArrayList();
    public int connectedBlocks = 0;
    private double euLastTick = 0.0;
    private double euChange;
    private int ticks;
    private int output;
    private int maxStorage;
    public Inventory inventory = new Inventory(2, "TileAesu", 64);

    public TileLesu() {
        super(5);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.countedNetworks.clear();
        this.connectedBlocks = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            LesuNetwork network;
            if (!(this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof TileLesuStorage) || ((TileLesuStorage)this.field_145850_b.func_147438_o((int)(this.field_145851_c + dir.offsetX), (int)(this.field_145848_d + dir.offsetY), (int)(this.field_145849_e + dir.offsetZ))).network == null || this.countedNetworks.contains(network = ((TileLesuStorage)this.field_145850_b.func_147438_o((int)(this.field_145851_c + dir.offsetX), (int)(this.field_145848_d + dir.offsetY), (int)(this.field_145849_e + dir.offsetZ))).network) || network.master != null && network.master != this) continue;
            this.connectedBlocks += network.storages.size();
            this.countedNetworks.add(network);
            network.master = this;
            break;
        }
        this.maxStorage = (this.connectedBlocks + 1) * ConfigTechReborn.lesuStoragePerBlock;
        this.output = this.connectedBlocks * ConfigTechReborn.extraOutputPerLesuBlock + ConfigTechReborn.baseLesuOutput;
        if (this.ticks == ConfigTechReborn.aveargeEuOutTickTime) {
            this.euChange = -1.0;
            this.ticks = 0;
        } else {
            ++this.ticks;
            if (this.euChange == -1.0) {
                this.euChange = 0.0;
            }
            this.euChange += this.getEnergy() - this.euLastTick;
            if (this.euLastTick == this.getEnergy()) {
                this.euChange = 0.0;
            }
        }
        this.euLastTick = this.getEnergy();
    }

    public double getEuChange() {
        if (this.euChange == -1.0) {
            return 0.0;
        }
        return this.euChange / (double)this.ticks;
    }

    @Override
    public double getMaxPower() {
        return this.maxStorage;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return Functions.getIntDirFromDirection((ForgeDirection)direction) != this.getRotation();
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return Functions.getIntDirFromDirection((ForgeDirection)direction) == this.getRotation();
    }

    @Override
    public double getMaxOutput() {
        return this.output;
    }

    @Override
    public double getMaxInput() {
        return 8192.0;
    }
}

