/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.api.IListInfoProvider;
import reborncore.common.misc.Location;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.recipe.RecipeCrafter;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.lib.Reference;
import techreborn.powerSystem.TilePowerAcceptor;
import techreborn.tiles.TileMachineCasing;

public class TileIndustrialSawmill
extends TilePowerAcceptor
implements IWrenchable,
IFluidHandler,
IInventory,
ISidedInventory,
IListInfoProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(5, "TileIndustrialSawmill", 64);
    public Tank tank = new Tank("TileSawmill", 16000, (TileEntity)this);
    public RecipeCrafter crafter;

    public TileIndustrialSawmill() {
        super(2);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4};
        this.crafter = new RecipeCrafter(Reference.industrialSawmillRecipe, this, 2, 3, this.inventory, inputs, outputs);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.getMutliBlock()) {
            this.crafter.updateEntity();
        }
        FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)4);
        FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)1, (int)4);
    }

    public boolean getMutliBlock() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!(tileEntity instanceof TileMachineCasing) || !(tileEntity.func_145838_q() instanceof BlockMachineCasing)) continue;
            int heat = BlockMachineCasing.getHeatFromMeta(tileEntity.func_145832_p());
            Location location = new Location(this.field_145851_c, this.field_145848_d, this.field_145849_e, direction);
            location.modifyPositionFromSide(direction, 1);
            if (this.field_145850_b.func_147439_a(location.getX(), location.getY(), location.getZ()).func_149739_a().equals("tile.lava")) {
                heat += 500;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.industrialSawmill, 1);
    }

    public boolean isComplete() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        this.tank.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER || resource.getFluid() == ModFluids.fluidMercury || resource.getFluid() == ModFluids.fluidSodiumpersulfate) {
            int filled = this.tank.fill(resource, doFill);
            this.tank.compareAndUpdate();
            return filled;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack fluidStack = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return fluidStack;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray = nArray2;
            nArray2[4] = 4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray = nArray3;
            nArray3[4] = 4;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemStack, int side) {
        if (slotIndex >= 2) {
            return false;
        }
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 2 || slotIndex == 3 || slotIndex == 4;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    @Override
    public double getMaxPower() {
        return 10000.0;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getMaxInput() {
        return 64.0;
    }
}

