/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import reborncore.api.fuel.FluidPowerManager;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.powerSystem.TilePowerAcceptor;

public class TileDieselGenerator
extends TilePowerAcceptor
implements IWrenchable,
IFluidHandler,
IInventory {
    public Tank tank = new Tank("TileDieselGenerator", 10000, (TileEntity)this);
    public Inventory inventory = new Inventory(3, "TileDieselGenerator", 64);
    public static final int euTick = ConfigTechReborn.ThermalGenertaorOutput;

    public TileDieselGenerator() {
        super(ConfigTechReborn.ThermalGeneratorTier);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.DieselGenerator, 1);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int filled = this.tank.fill(resource, doFill);
        this.tank.compareAndUpdate();
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack fluidStack = this.tank.drain(resource.amount, doDrain);
        this.tank.compareAndUpdate();
        return fluidStack;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        this.tank.compareAndUpdate();
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FluidPowerManager.fluidPowerValues.containsKey(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.inventory.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        this.inventory.writeToNBT(tagCompound);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            FluidUtils.drainContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1);
            FluidUtils.fillContainers((IFluidHandler)this, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType());
            if (this.tank.getFluidType() != null && this.func_70301_a(2) == null) {
                this.inventory.func_70299_a(2, new ItemStack(this.tank.getFluidType().getBlock()));
                this.syncWithAll();
            } else if (this.tank.getFluidType() == null && this.func_70301_a(2) != null) {
                this.func_70299_a(2, null);
                this.syncWithAll();
            }
            if (!this.tank.isEmpty() && this.tank.getFluidType() != null && FluidPowerManager.fluidPowerValues.containsKey(this.tank.getFluidType())) {
                double powerIn = (Double)FluidPowerManager.fluidPowerValues.get(this.tank.getFluidType());
                if (this.getFreeSpace() >= powerIn) {
                    this.addEnergy(powerIn, false);
                    this.tank.drain(1, true);
                }
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.inventory.func_70301_a(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return this.inventory.func_70298_a(p_70298_1_, p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return this.inventory.func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventory.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.inventory.func_70300_a(p_70300_1_);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return this.inventory.func_94041_b(p_94041_1_, p_94041_2_);
    }

    @Override
    public double getMaxPower() {
        return ConfigTechReborn.ThermalGeneratorCharge;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return true;
    }

    @Override
    public double getMaxOutput() {
        return 64.0;
    }

    @Override
    public double getMaxInput() {
        return 0.0;
    }
}

