/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem.parts;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.IC2Classic;
import ic2.api.item.IC2Items;
import ic2.api.network.INetworkTileEntityEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.misc.Functions;
import reborncore.common.misc.Location;
import reborncore.common.misc.vecmath.Vecs3d;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.client.render.RenderCablePart;
import techreborn.partSystem.IModPart;
import techreborn.partSystem.IPartDesc;
import techreborn.partSystem.ModPart;
import techreborn.partSystem.ModPartUtils;

public class CablePart
extends ModPart
implements IEnergyConductor,
INetworkTileEntityEventListener,
IPartDesc {
    public Vecs3dCube[] boundingBoxes = new Vecs3dCube[14];
    public float center = 0.6f;
    public float offset = 0.1f;
    public Map<ForgeDirection, TileEntity> connectedSides;
    public int ticks = 0;
    public boolean addedToEnergyNet = false;
    public ItemStack stack;
    public int type = 0;
    protected ForgeDirection[] dirs = ForgeDirection.values();
    private boolean[] connections = new boolean[6];
    private boolean hasCheckedSinceStartup;

    public CablePart() {
        this.connectedSides = new HashMap<ForgeDirection, TileEntity>();
    }

    public static int getMaxCapacity(int type) {
        switch (type) {
            case 0: {
                return 128;
            }
            case 1: {
                return 128;
            }
            case 2: {
                return 512;
            }
            case 3: {
                return 512;
            }
            case 4: {
                return 512;
            }
            case 5: {
                return 2048;
            }
            case 6: {
                return 2048;
            }
            case 7: {
                return 2048;
            }
            case 8: {
                return 2048;
            }
            case 9: {
                return 8192;
            }
            case 10: {
                return 32;
            }
            case 11: {
                return 8192;
            }
            case 12: {
                return 8192;
            }
            case 13: {
                return 32;
            }
            case 14: {
                return 32;
            }
        }
        return 0;
    }

    public static float getCableThickness(int cableType) {
        float p = 1.0f;
        switch (cableType) {
            case 0: {
                p = 6.0f;
                break;
            }
            case 1: {
                p = 4.0f;
                break;
            }
            case 2: {
                p = 3.0f;
                break;
            }
            case 3: {
                p = 6.0f;
                break;
            }
            case 4: {
                p = 6.0f;
                break;
            }
            case 5: {
                p = 6.0f;
                break;
            }
            case 6: {
                p = 10.0f;
                break;
            }
            case 7: {
                p = 10.0f;
                break;
            }
            case 8: {
                p = 12.0f;
                break;
            }
            case 9: {
                p = 4.0f;
                break;
            }
            case 10: {
                p = 4.0f;
                break;
            }
            case 11: {
                p = 8.0f;
                break;
            }
            case 12: {
                p = 8.0f;
                break;
            }
            case 13: {
                p = 16.0f;
                break;
            }
            case 14: {
                p = 6.0f;
            }
        }
        return p / 16.0f;
    }

    public static String getNameFromType(int cableType) {
        String p = null;
        switch (cableType) {
            case 0: {
                p = "insulatedCopperCable";
                break;
            }
            case 1: {
                p = "copperCable";
                break;
            }
            case 2: {
                p = "goldCable";
                break;
            }
            case 3: {
                p = "insulatedGoldCable";
                break;
            }
            case 4: {
                p = "doubleInsulatedGoldCable";
                break;
            }
            case 5: {
                p = "ironCable";
                break;
            }
            case 6: {
                p = "insulatedIronCable";
                break;
            }
            case 7: {
                p = "doubleInsulatedIronCable";
                break;
            }
            case 8: {
                p = "trippleInsulatedIronCable";
                break;
            }
            case 9: {
                p = "glassFiberCable";
                break;
            }
            case 10: {
                p = "tinCable";
                break;
            }
            case 11: {
                p = "detectorCableBlock";
                break;
            }
            case 12: {
                p = "splitterCableBlock";
                break;
            }
            case 13: {
                p = "insulatedtinCable";
                break;
            }
            case 14: {
                p = "unused";
            }
        }
        return p;
    }

    public static String getTextureNameFromType(int cableType) {
        String p = null;
        switch (cableType) {
            case 0: {
                p = "insulatedCopperCableItem";
                break;
            }
            case 1: {
                p = "copperCableItem";
                break;
            }
            case 2: {
                p = "goldCableItem";
                break;
            }
            case 3: {
                p = "insulatedGoldCableItem";
                break;
            }
            case 4: {
                p = "doubleInsulatedGoldCableItem";
                break;
            }
            case 5: {
                p = "ironCableItem";
                break;
            }
            case 6: {
                p = "insulatedIronCableItem";
                break;
            }
            case 7: {
                p = "doubleInsulatedIronCableItem";
                break;
            }
            case 8: {
                p = "trippleInsulatedIronCableItem";
                break;
            }
            case 9: {
                p = "glassFiberCableItem";
                break;
            }
            case 10: {
                p = "tinCableItem";
                break;
            }
            case 11: {
                p = "detectorCableItem";
                break;
            }
            case 12: {
                p = "splitterCableItem";
                break;
            }
            case 13: {
                p = "insulatedTinCableItem";
                break;
            }
            case 14: {
                p = "unused";
            }
        }
        return p;
    }

    public void setType(int newType) {
        this.type = newType;
        this.refreshBounding();
    }

    public void refreshBounding() {
        float centerFirst = this.center - this.offset;
        double w = CablePart.getCableThickness(this.type) / 2.0f;
        this.boundingBoxes[6] = new Vecs3dCube((double)centerFirst - w - 0.03, (double)centerFirst - w - 0.08, (double)centerFirst - w - 0.03, (double)centerFirst + w + 0.08, (double)centerFirst + w + 0.04, (double)centerFirst + w + 0.08);
        this.boundingBoxes[6] = new Vecs3dCube((double)centerFirst - w, (double)centerFirst - w, (double)centerFirst - w, (double)centerFirst + w, (double)centerFirst + w, (double)centerFirst + w);
        int i = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            double zMin1;
            double yMax1;
            double yMin1;
            double xMax1;
            double xMin1;
            double d = dir.offsetX < 0 ? 0.0 : (xMin1 = dir.offsetX == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double d2 = dir.offsetX > 0 ? 1.0 : (xMax1 = dir.offsetX == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            double d3 = dir.offsetY < 0 ? 0.0 : (yMin1 = dir.offsetY == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double d4 = dir.offsetY > 0 ? 1.0 : (yMax1 = dir.offsetY == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            double d5 = dir.offsetZ < 0 ? 0.0 : (zMin1 = dir.offsetZ == 0 ? (double)centerFirst - w : (double)centerFirst + w);
            double zMax1 = dir.offsetZ > 0 ? 1.0 : (dir.offsetZ == 0 ? (double)centerFirst + w : (double)centerFirst - w);
            this.boundingBoxes[i] = new Vecs3dCube(xMin1, yMin1, zMin1, xMax1, yMax1, zMax1);
            ++i;
        }
    }

    @Override
    public void addCollisionBoxesToList(List<Vecs3dCube> boxes, Entity entity) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.connectedSides.containsKey(dir)) continue;
            boxes.add(this.boundingBoxes[Functions.getIntDirFromDirection((ForgeDirection)dir)]);
        }
        boxes.add(this.boundingBoxes[6]);
    }

    @Override
    public List<Vecs3dCube> getSelectionBoxes() {
        ArrayList<Vecs3dCube> vec3dCubeList = new ArrayList<Vecs3dCube>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.connectedSides.containsKey(dir)) continue;
            vec3dCubeList.add(this.boundingBoxes[Functions.getIntDirFromDirection((ForgeDirection)dir)]);
        }
        vec3dCubeList.add(this.boundingBoxes[6]);
        return vec3dCubeList;
    }

    @Override
    public List<Vecs3dCube> getOcclusionBoxes() {
        ArrayList<Vecs3dCube> vecs3dCubesList = new ArrayList<Vecs3dCube>();
        vecs3dCubesList.add(this.boundingBoxes[6]);
        return vecs3dCubesList;
    }

    @Override
    public void renderDynamic(Vecs3d translation, double delta) {
    }

    @Override
    public boolean renderStatic(Vecs3d translation, int pass) {
        return RenderCablePart.renderStatic(translation, pass, this);
    }

    public void func_145841_b(NBTTagCompound tag) {
        tag.func_74768_a("type", this.type);
        this.writeConnectedSidesToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.type = tag.func_74762_e("type");
    }

    @Override
    public String getName() {
        return "Cable." + CablePart.getNameFromType(this.type);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getItemTextureName() {
        if (IC2Classic.getLoadedIC2Type() == IC2Classic.IC2Type.SpeigersClassic) {
            return IC2Items.getItem("copperCableBlock").func_77973_b().getIcon(new ItemStack(IC2Items.getItem("copperCableBlock").func_77973_b(), this.type), 1).func_94215_i();
        }
        return IC2Items.getItem(CablePart.getTextureNameFromType(this.type)).func_77954_c().func_94215_i();
    }

    @Override
    public void tick() {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.nearByChange();
        }
        if (!(this.field_145850_b == null || this.field_145850_b.func_82737_E() % 80L != 0L && this.hasCheckedSinceStartup)) {
            this.checkConnectedSides();
            this.hasCheckedSinceStartup = true;
        }
    }

    @Override
    public void nearByChange() {
        this.checkConnectedSides();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.field_145850_b.func_147471_g(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            IModPart part = ModPartUtils.getPartFromWorld(this.world, new Location(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ), this.getName());
            if (part == null) continue;
            CablePart cablePart = (CablePart)part;
            cablePart.checkConnectedSides();
        }
    }

    @Override
    public void onAdded() {
        this.checkConnections(this.world, this.getX(), this.getY(), this.getZ());
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.nearByChange();
        }
        this.nearByChange();
    }

    @Override
    public void onRemoved() {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public IModPart copy() {
        CablePart part = new CablePart();
        part.setType(this.type);
        return part;
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack(IC2Items.getItem("copperCableItem").func_77973_b(), 1, this.type);
    }

    public boolean shouldConnectTo(TileEntity entity, ForgeDirection dir) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof IEnergyTile) {
            return true;
        }
        if (ModPartUtils.hasPart(entity.func_145831_w(), entity.field_145851_c, entity.field_145848_d, entity.field_145849_e, this.getName())) {
            CablePart otherCable = (CablePart)ModPartUtils.getPartFromWorld(entity.func_145831_w(), new Location(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e), this.getName());
            if (otherCable == null || dir == null) {
                return false;
            }
            int thisDir = Functions.getIntDirFromDirection((ForgeDirection)dir);
            int thereDir = Functions.getIntDirFromDirection((ForgeDirection)dir.getOpposite());
            boolean hasconnection = otherCable.connections[thereDir];
            otherCable.connections[thereDir] = false;
            if (ModPartUtils.checkOcclusion(entity.func_145831_w(), entity.field_145851_c, entity.field_145848_d, entity.field_145849_e, this.boundingBoxes[thereDir])) {
                otherCable.connections[thereDir] = true;
                return true;
            }
            otherCable.connections[thereDir] = hasconnection;
        }
        return false;
    }

    public void checkConnectedSides() {
        this.refreshBounding();
        this.connectedSides = new HashMap<ForgeDirection, TileEntity>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int d = Functions.getIntDirFromDirection((ForgeDirection)dir);
            if (this.world == null) {
                return;
            }
            TileEntity te = this.world.func_147438_o(this.getX() + dir.offsetX, this.getY() + dir.offsetY, this.getZ() + dir.offsetZ);
            if (this.shouldConnectTo(te, dir) && ModPartUtils.checkOcclusion(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.boundingBoxes[d])) {
                this.connectedSides.put(dir, te);
            }
            if (te == null) continue;
            te.func_145831_w().func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        this.checkConnections(this.world, this.getX(), this.getY(), this.getZ());
        this.getWorld().func_147471_g(this.getX(), this.getY(), this.getZ());
    }

    public void checkConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            this.connections[i] = this.shouldConnectTo(world.func_147438_o(dx, dy, dz), dir);
            world.func_147479_m(dx, dy, dz);
        }
        world.func_147479_m(x, y, z);
    }

    @Override
    public double getConductionLoss() {
        switch (this.type) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.5;
            }
            case 3: {
                return 0.45;
            }
            case 4: {
                return 0.4;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 0.95;
            }
            case 7: {
                return 0.9;
            }
            case 8: {
                return 0.8;
            }
            case 9: {
                return 0.025;
            }
            case 10: {
                return 0.025;
            }
            case 11: {
                return 0.5;
            }
            case 12: {
                return 0.5;
            }
            default: {
                return 0.025;
            }
            case 14: 
        }
        return 0.2;
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        return CablePart.getMaxCapacity(this.type);
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        return 9001.0;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return CablePart.getMaxCapacity(this.type) + 1;
    }

    @Override
    public void removeInsulation() {
    }

    @Override
    public void removeConductor() {
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return this.connectedSides.containsKey(forgeDirection);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return this.connectedSides.containsKey(forgeDirection);
    }

    @Override
    public void onNetworkEvent(int i) {
        switch (i) {
            case 0: {
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.fizz", 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + Math.random(), (double)this.field_145848_d + 1.2, (double)this.field_145849_e + Math.random(), 0.0, 0.0, 0.0);
                }
                return;
            }
        }
    }

    private void readConnectedSidesFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound ourCompound = tagCompound.func_74775_l("connectedSides");
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.connections[dir.ordinal()] = ourCompound.func_74767_n(dir.ordinal() + "");
        }
        this.checkConnectedSides();
    }

    private void writeConnectedSidesToNBT(NBTTagCompound tagCompound) {
        NBTTagCompound ourCompound = new NBTTagCompound();
        int i = 0;
        for (boolean b : this.connections) {
            ourCompound.func_74757_a(i + "", b);
            ++i;
        }
        tagCompound.func_74782_a("connectedSides", (NBTBase)ourCompound);
    }

    @Override
    public void readDesc(NBTTagCompound tagCompound) {
        this.readConnectedSidesFromNBT(tagCompound);
    }

    @Override
    public void writeDesc(NBTTagCompound tagCompound) {
        this.writeConnectedSidesToNBT(tagCompound);
    }

    @Override
    public boolean needsItem() {
        return false;
    }
}

