/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem.fmp;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.item.IC2Items;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.TileEntityCable;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import reborncore.common.packets.AddDiscriminatorEvent;
import reborncore.common.packets.PacketHandler;
import reborncore.common.packets.SimplePacket;
import techreborn.partSystem.fmp.FMPModPart;
import techreborn.partSystem.fmp.PacketFMPPlacePart;
import techreborn.partSystem.parts.CablePart;

public class CableConverter
implements MultiPartRegistry.IPartConverter {
    private final ThreadLocal<Object> placing = new ThreadLocal();

    public Iterable<Block> blockTypes() {
        return Arrays.asList(Block.func_149634_a((Item)IC2Items.getItem("copperCableBlock").func_77973_b()));
    }

    public TMultiPart convert(World world, BlockCoord blockCoord) {
        TileEntity tileEntity;
        Block block = world.func_147439_a(blockCoord.x, blockCoord.y, blockCoord.z);
        if (block instanceof BlockCable && (tileEntity = world.func_147438_o(blockCoord.x, blockCoord.y, blockCoord.z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tileEntity;
            short type = cable.cableType;
            CablePart newPart = new CablePart();
            newPart.setType(type);
            return new FMPModPart(newPart);
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70170_p.field_72995_K) {
            if (this.placing.get() != null) {
                return;
            }
            this.placing.set(event);
            if (CableConverter.place(event.entityPlayer, event.entityPlayer.field_70170_p)) {
                event.setCanceled(true);
            }
            this.placing.set(null);
        }
    }

    public static boolean place(EntityPlayer player, World world) {
        TileMultipart tile;
        MovingObjectPosition hit = RayTracer.reTrace((World)world, (EntityPlayer)player);
        if (hit == null) {
            return false;
        }
        BlockCoord pos = new BlockCoord(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
        ItemStack held = player.func_70694_bm();
        FMPModPart part = null;
        if (held == null) {
            return false;
        }
        Item heldItem = held.func_77973_b();
        if (heldItem == IC2Items.getItem("copperCableItem").func_77973_b()) {
            CablePart cablePart = new CablePart();
            cablePart.setType(held.func_77960_j());
            part = new FMPModPart(cablePart);
        }
        if (part == null) {
            return false;
        }
        if (world.field_72995_K && !player.func_70093_af()) {
            Vector3 f = new Vector3(hit.field_72307_f).add((double)(-hit.field_72311_b), (double)(-hit.field_72312_c), (double)(-hit.field_72309_d));
            Block block = world.func_147439_a(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            if (!CableConverter.ignoreActivate(block) && block.func_149727_a(world, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, player, hit.field_72310_e, (float)f.x, (float)f.y, (float)f.z)) {
                player.func_71038_i();
                PacketCustom.sendToServer((Packet)new C08PacketPlayerBlockPlacement(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, hit.field_72310_e, player.field_71071_by.func_70448_g(), (float)f.x, (float)f.y, (float)f.z));
                return true;
            }
        }
        if (!((tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)pos)) != null && tile.canAddPart((TMultiPart)part) || (tile = TileMultipart.getOrConvertTile((World)world, (BlockCoord)(pos = pos.offset(hit.field_72310_e)))) != null && tile.canAddPart((TMultiPart)part))) {
            return false;
        }
        if (!world.field_72995_K) {
            TileMultipart.addPart((World)world, (BlockCoord)pos, (TMultiPart)part);
            world.func_72908_a((double)pos.x + 0.5, (double)pos.y + 0.5, (double)pos.z + 0.5, Blocks.field_150325_L.field_149762_H.func_150496_b(), (Blocks.field_150325_L.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150325_L.field_149762_H.func_150494_d() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                --held.field_77994_a;
                if (held.field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, held));
                }
            }
        } else {
            player.func_71038_i();
            PacketHandler.sendPacketToServer((SimplePacket)new PacketFMPPlacePart());
        }
        return true;
    }

    private static boolean ignoreActivate(Block block) {
        return block instanceof BlockFence;
    }

    @SubscribeEvent
    public void addDiscriminator(AddDiscriminatorEvent event) {
        event.getPacketHandler().addDiscriminator(event.getPacketHandler().nextDiscriminator, PacketFMPPlacePart.class);
    }
}

