/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import cpw.mods.fml.common.registry.GameRegistry;
import java.security.InvalidParameterException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import reborncore.common.util.CraftingHelper;
import reborncore.common.util.OreUtil;
import techreborn.Core;
import techreborn.api.TechRebornAPI;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.api.recipe.RecipeHandler;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.api.recipe.machines.CentrifugeRecipe;
import techreborn.api.recipe.machines.ChemicalReactorRecipe;
import techreborn.api.recipe.machines.GrinderRecipe;
import techreborn.api.recipe.machines.IndustrialElectrolyzerRecipe;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.api.recipe.machines.PlateCuttingMachineRecipe;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.blocks.BlockOre;
import techreborn.blocks.BlockStorage;
import techreborn.blocks.BlockStorage2;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.init.ModItems;
import techreborn.items.ItemCells;
import techreborn.items.ItemDusts;
import techreborn.items.ItemDustsSmall;
import techreborn.items.ItemGems;
import techreborn.items.ItemIngots;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;

public class ModRecipes {
    public static ConfigTechReborn config;

    public static void init() {
        ModRecipes.addShapelessRecipes();
        ModRecipes.addGeneralShapedRecipes();
        ModRecipes.addMachineRecipes();
        ModRecipes.addSmeltingRecipes();
        ModRecipes.addUUrecipes();
        ModRecipes.addAlloySmelterRecipes();
        ModRecipes.addPlateCuttingMachineRecipes();
        ModRecipes.addIndustrialCentrifugeRecipes();
        ModRecipes.addChemicalReactorRecipes();
        ModRecipes.addIndustrialElectrolyzerRecipes();
        ModRecipes.addIndustrialSawmillRecipes();
        ModRecipes.addBlastFurnaceRecipes();
        ModRecipes.addIndustrialGrinderRecipes();
        ModRecipes.addImplosionCompressorRecipes();
        ModRecipes.addReactorRecipes();
    }

    static void addReactorRecipes() {
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("tritium"), ItemCells.getCellByName("deuterium"), ItemCells.getCellByName("helium"), 4.0E7, 32768.0, 1024));
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("tritium"), ItemCells.getCellByName("deuterium"), ItemCells.getCellByName("helium3"), 6.0E7, 32768.0, 2048));
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("wolframium"), ItemCells.getCellByName("Berylium"), ItemDusts.getDustByName("platinum"), 8.0E7, -2048.0, 1024));
    }

    static void addGeneralShapedRecipes() {
        for (String name : (String[])ArrayUtils.addAll((Object[])BlockStorage.types, (Object[])BlockStorage2.types)) {
            CraftingHelper.addShapedOreRecipe((ItemStack)BlockStorage.getStorageBlockByName(name), (Object[])new Object[]{"AAA", "AAA", "AAA", Character.valueOf('A'), "ingot" + name.substring(0, 1).toUpperCase() + name.substring(1)});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)BlockStorage.getStorageBlockByName("sapphire"), (Object[])new Object[]{"AAA", "AAA", "AAA", Character.valueOf('A'), "gemSapphire"});
        CraftingHelper.addShapedOreRecipe((ItemStack)BlockStorage.getStorageBlockByName("ruby"), (Object[])new Object[]{"AAA", "AAA", "AAA", Character.valueOf('A'), "gemRuby"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.parts, 1, 40), (Object[])new Object[]{"PLP", "RGB", "PYP", Character.valueOf('P'), "plateAluminum", Character.valueOf('L'), "dyeLime", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "paneGlass", Character.valueOf('B'), "dyeBlue", Character.valueOf('Y'), Items.field_151114_aO});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("dataStorageCircuit"), (Object[])new Object[]{"EEE", "ECE", "EEE", Character.valueOf('E'), new ItemStack(Items.field_151166_bC), Character.valueOf('C'), ItemParts.getPartByName("basicCircuitBoard")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.parts, 4, 8), (Object[])new Object[]{"DSD", "S S", "DSD", Character.valueOf('D'), "dustDiamond", Character.valueOf('S'), "ingotSteel"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.parts, 1, 15), (Object[])new Object[]{"AAA", "AMA", "AAA", Character.valueOf('A'), "ingotAluminium", Character.valueOf('M'), new ItemStack(ModItems.parts, 1, 13)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.Supercondensator), (Object[])new Object[]{"EOE", "SAS", "EOE", Character.valueOf('E'), ItemParts.getPartByName("energyFlowCircuit"), Character.valueOf('O'), ModItems.lapotronicOrb, Character.valueOf('S'), ItemParts.getPartByName("superconductor"), Character.valueOf('A'), ModBlocks.HighAdvancedMachineBlock});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("diamondSawBlade"), (Object[])new Object[]{"DSD", "S S", "DSD", Character.valueOf('S'), "plateSteel", Character.valueOf('D'), "dustDiamond"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("tungstenGrindingHead", 2), (Object[])new Object[]{"TST", "SBS", "TST", Character.valueOf('T'), "plateTungsten", Character.valueOf('S'), "plateSteel", Character.valueOf('B'), "blockSteel"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("destructoPack"), (Object[])new Object[]{"CIC", "IBI", "CIC", Character.valueOf('C'), ItemParts.getPartByName("basicCircuitBoard"), Character.valueOf('I'), "ingotAluminum", Character.valueOf('B'), new ItemStack(Items.field_151129_at)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.cloakingDevice), (Object[])new Object[]{"CIC", "IOI", "CIC", Character.valueOf('C'), "ingotChrome", Character.valueOf('I'), "plateIridium", Character.valueOf('O'), new ItemStack(ModItems.lapotronicOrb)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.rockCutter), (Object[])new Object[]{"DT ", "DT ", "DCB", Character.valueOf('D'), ItemParts.getPartByName("rockCutterBlade"), Character.valueOf('T'), "ingotTitanium", Character.valueOf('C'), ItemParts.getPartByName("basicCircuitBoard"), Character.valueOf('B'), new ItemStack(Items.field_151045_i)});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("rockCutterBlade"), (Object[])new Object[]{"SDS", "SDS", "SDS", Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('S'), "ingotSteel"});
        for (String part : ItemParts.types) {
            if (!part.endsWith("Gear")) continue;
            CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName(part), (Object[])new Object[]{" O ", "OIO", " O ", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('O'), "ingot" + ModRecipes.capitalizeFirstLetter(part.replace("Gear", ""))});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("nichromeHeatingCoil"), (Object[])new Object[]{" N ", "NCN", " N ", Character.valueOf('N'), "ingotNickel", Character.valueOf('C'), "ingotChrome"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("kanthalHeatingCoil"), (Object[])new Object[]{"III", "CAA", "AAA", Character.valueOf('I'), "ingotSteel", Character.valueOf('C'), "ingotChrome", Character.valueOf('A'), "ingotAluminum"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("heliumCoolantSimple"), (Object[])new Object[]{" T ", "TCT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemCells.getCellByName("helium", 1, true)});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("heliumCoolantSimple"), (Object[])new Object[]{" T ", "TCT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemCells.getCellByName("helium", 1, false)});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("HeliumCoolantTriple"), (Object[])new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("heliumCoolantSimple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("HeliumCoolantSix"), (Object[])new Object[]{"THT", "TCT", "THT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "ingotCopper", Character.valueOf('H'), ItemParts.getPartByName("HeliumCoolantTriple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("NaKCoolantTriple"), (Object[])new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("NaKCoolantSimple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("NaKCoolantSix"), (Object[])new Object[]{"THT", "TCT", "THT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "ingotCopper", Character.valueOf('H'), ItemParts.getPartByName("NaKCoolantTriple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.Aesu), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), new ItemStack(ModItems.lapotronicOrb), Character.valueOf('C'), new ItemStack(ModBlocks.ComputerCube)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.Idsu), (Object[])new Object[]{"PAP", "ACA", "PAP", Character.valueOf('P'), ItemPlates.getPlateByName("iridium"), Character.valueOf('C'), new ItemStack(Blocks.field_150477_bB), Character.valueOf('A'), new ItemStack(ModBlocks.Aesu)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.FusionControlComputer), (Object[])new Object[]{"CCC", "PTP", "CCC", Character.valueOf('P'), new ItemStack(ModBlocks.ComputerCube), Character.valueOf('T'), new ItemStack(ModBlocks.FusionCoil), Character.valueOf('C'), ItemParts.getPartByName("energyFlowCircuit")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.LightningRod), (Object[])new Object[]{"CAC", "ACA", "CAC", Character.valueOf('A'), new ItemStack(ModBlocks.MachineCasing, 1, 2), Character.valueOf('S'), ItemParts.getPartByName("superConductor"), Character.valueOf('C'), ItemParts.getPartByName("energyFlowCircuit")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.FusionCoil), (Object[])new Object[]{"CSC", "NAN", "CRC", Character.valueOf('A'), new ItemStack(ModBlocks.MachineCasing, 1, 2), Character.valueOf('N'), ItemParts.getPartByName("nichromeHeatingCoil"), Character.valueOf('C'), ItemParts.getPartByName("energyFlowCircuit"), Character.valueOf('S'), ItemParts.getPartByName("superConductor"), Character.valueOf('R'), ItemParts.getPartByName("iridiumNeutronReflector")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("iridiumNeutronReflector"), (Object[])new Object[]{"PPP", "PIP", "PPP", Character.valueOf('P'), ItemParts.getPartByName("thickNeutronReflector"), Character.valueOf('I'), "ingotIridium"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("thickNeutronReflector"), (Object[])new Object[]{" P ", "PCP", " P ", Character.valueOf('P'), ItemParts.getPartByName("neutronReflector"), Character.valueOf('C'), ItemCells.getCellByName("Berylium")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("neutronReflector"), (Object[])new Object[]{"TCT", "CPC", "TCT", Character.valueOf('T'), "dustTin", Character.valueOf('C'), "dustCoal", Character.valueOf('P'), "plateCopper"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("dataOrb"), (Object[])new Object[]{"SSS", "SCS", "SSS", Character.valueOf('S'), ItemParts.getPartByName("dataStorageCircuit"), Character.valueOf('C'), ItemParts.getPartByName("dataControlCircuit")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("computerMonitor"), (Object[])new Object[]{"AGA", "RCB", "AYA", Character.valueOf('A'), "plateAluminum", Character.valueOf('G'), new ItemStack(Items.field_151100_aR, 1, 2), Character.valueOf('R'), new ItemStack(Items.field_151100_aR, 1, 1), Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 5), Character.valueOf('Y'), new ItemStack(Items.field_151114_aO)});
        Core.logHelper.info((Object)"Shapped Recipes Added");
    }

    public static String capitalizeFirstLetter(String original) {
        if (original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    static void addShapelessRecipes() {
        for (String name : (String[])ArrayUtils.addAll((Object[])BlockStorage.types, (Object[])BlockStorage2.types)) {
            ItemStack item = null;
            try {
                item = ItemIngots.getIngotByName(name, 9);
            }
            catch (InvalidParameterException e) {
                try {
                    item = ItemGems.getGemByName(name, 9);
                }
                catch (InvalidParameterException e2) {
                    continue;
                }
            }
            if (item == null) continue;
            GameRegistry.addShapelessRecipe((ItemStack)BlockStorage.getStorageBlockByName(name), (Object[])new Object[]{item, item, item, item, item, item, item, item, item});
            GameRegistry.addShapelessRecipe((ItemStack)item, (Object[])new Object[]{BlockStorage.getStorageBlockByName(name, 9)});
        }
        for (String name : ItemDustsSmall.types) {
            GameRegistry.addShapelessRecipe((ItemStack)ItemDustsSmall.getSmallDustByName(name, 4), (Object[])new Object[]{ItemDusts.getDustByName(name)});
            GameRegistry.addShapelessRecipe((ItemStack)ItemDusts.getDustByName(name, 1), (Object[])new Object[]{ItemDustsSmall.getSmallDustByName(name), ItemDustsSmall.getSmallDustByName(name), ItemDustsSmall.getSmallDustByName(name), ItemDustsSmall.getSmallDustByName(name)});
        }
        Core.logHelper.info((Object)"Shapless Recipes Added");
    }

    static void addMachineRecipes() {
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.quantumTank), (Object[])new Object[]{"EPE", "PCP", "EPE", Character.valueOf('P'), "platePlatinum", Character.valueOf('E'), "circuitMaster", Character.valueOf('C'), ModBlocks.quantumChest});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.digitalChest), (Object[])new Object[]{"PPP", "PDP", "PCP", Character.valueOf('P'), "plateAluminum", Character.valueOf('D'), ItemParts.getPartByName("dataOrb"), Character.valueOf('C'), ItemParts.getPartByName("computerMonitor")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.digitalChest), (Object[])new Object[]{"PPP", "PDP", "PCP", Character.valueOf('P'), "plateSteel", Character.valueOf('D'), ItemParts.getPartByName("dataOrb"), Character.valueOf('C'), ItemParts.getPartByName("computerMonitor")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.AlloySmelter), (Object[])new Object[]{"IHI", "CFC", "IHI", Character.valueOf('I'), "plateInvar", Character.valueOf('C'), "circuitBasic", Character.valueOf('H'), new ItemStack(ModItems.parts, 1, 17), Character.valueOf('F'), ModBlocks.AlloyFurnace});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.LesuStorage), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), "blockLapis", Character.valueOf('C'), "circuitBasic"});
        TechRebornAPI.addRollingOreMachinceRecipe(ItemParts.getPartByName("cupronickelHeatingCoil"), "NCN", "C C", "NCN", Character.valueOf('N'), "ingotCupronickel", Character.valueOf('C'), "ingotCopper");
        RecipeHandler.addRecipe(new VacuumFreezerRecipe(ItemIngots.getIngotByName("hotTungstensteel"), ItemIngots.getIngotByName("tungstensteel"), 440, 128));
        RecipeHandler.addRecipe(new VacuumFreezerRecipe(ItemCells.getCellByName("water"), ItemCells.getCellByName("cell"), 60, 128));
    }

    static void addSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)ItemDusts.getDustByName("iron", 1), (ItemStack)new ItemStack(Items.field_151042_j), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)ItemDusts.getDustByName("gold", 1), (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        Core.logHelper.info((Object)"Smelting Recipes Added");
    }

    static void addAlloySmelterRecipes() {
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemIngots.getIngotByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemDusts.getDustByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemIngots.getIngotByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151043_k, 1), ItemIngots.getIngotByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151043_k, 1), ItemDusts.getDustByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("gold", 1), ItemIngots.getIngotByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("gold", 1), ItemDusts.getDustByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 2), ItemIngots.getIngotByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 2), ItemDusts.getDustByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("iron", 2), ItemIngots.getIngotByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("iron", 2), ItemDusts.getDustByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 1), ItemIngots.getIngotByName("nickel", 1), ItemIngots.getIngotByName("cupronickel", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 1), ItemDusts.getDustByName("nickel", 1), ItemIngots.getIngotByName("cupronickel", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 1), ItemIngots.getIngotByName("nickel", 1), ItemIngots.getIngotByName("cupronickel", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 1), ItemDusts.getDustByName("nickel", 1), ItemIngots.getIngotByName("cupronickel", 2), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("chrome", 1), ItemIngots.getIngotByName("nickel", 4), ItemIngots.getIngotByName("nichrome", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("chrome", 1), ItemDusts.getDustByName("nickel", 4), ItemIngots.getIngotByName("nichrome", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("chrome", 1), ItemIngots.getIngotByName("nickel", 4), ItemIngots.getIngotByName("nichrome", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("chrome", 1), ItemDusts.getDustByName("nickel", 4), ItemIngots.getIngotByName("nichrome", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("magnesium", 1), ItemIngots.getIngotByName("aluminum", 4), ItemIngots.getIngotByName("magnalium", 3), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("magnesium", 1), ItemDusts.getDustByName("aluminum", 4), ItemIngots.getIngotByName("magnalium", 3), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("lead", 4), ItemIngots.getIngotByName("antimony", 1), ItemIngots.getIngotByName("batteryAlloy", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("lead", 4), ItemDusts.getDustByName("antimony", 1), ItemIngots.getIngotByName("batteryAlloy", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("lead", 4), ItemIngots.getIngotByName("antimony", 1), ItemIngots.getIngotByName("batteryAlloy", 5), 200, 16));
        RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("lead", 4), ItemDusts.getDustByName("antimony", 1), ItemIngots.getIngotByName("batteryAlloy", 5), 200, 16));
        if (OreUtil.doesOreExistAndValid((String)"ingotBrass")) {
            ItemStack brassStack = (ItemStack)OreDictionary.getOres((String)"ingotBrass").get(0);
            brassStack.field_77994_a = 4;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemIngots.getIngotByName("zinc", 1), brassStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemDusts.getDustByName("zinc", 1), brassStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemIngots.getIngotByName("zinc", 1), brassStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("zinc", 1), brassStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotRedAlloy")) {
            ItemStack redAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotRedAlloy").get(0);
            redAlloyStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 4), ItemIngots.getIngotByName("copper", 1), redAlloyStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 4), new ItemStack(Items.field_151042_j, 1), redAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotBlueAlloy")) {
            ItemStack blueAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotBlueAlloy").get(0);
            blueAlloyStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("teslatite", 4), ItemIngots.getIngotByName("silver", 1), blueAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotPurpleAlloy") && OreUtil.doesOreExistAndValid((String)"dustInfusedTeslatite")) {
            ItemStack purpleAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotPurpleAlloy").get(0);
            purpleAlloyStack.field_77994_a = 1;
            ItemStack infusedTeslatiteStack = (ItemStack)OreDictionary.getOres((String)"ingotPurpleAlloy").get(0);
            infusedTeslatiteStack.field_77994_a = 8;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("redAlloy", 1), ItemIngots.getIngotByName("blueAlloy", 1), purpleAlloyStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151043_k, 1), infusedTeslatiteStack, purpleAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotAluminumBrass")) {
            ItemStack aluminumBrassStack = (ItemStack)OreDictionary.getOres((String)"ingotAluminumBrass").get(0);
            aluminumBrassStack.field_77994_a = 4;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemIngots.getIngotByName("aluminum", 1), aluminumBrassStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemDusts.getDustByName("aluminum", 1), aluminumBrassStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemIngots.getIngotByName("aluminum", 1), aluminumBrassStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("aluminum", 1), aluminumBrassStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotManyullyn") && OreUtil.doesOreExistAndValid((String)"ingotCobalt") && OreUtil.doesOreExistAndValid((String)"ingotArdite")) {
            ItemStack manyullynStack = (ItemStack)OreDictionary.getOres((String)"ingotManyullyn").get(0);
            manyullynStack.field_77994_a = 1;
            ItemStack cobaltStack = (ItemStack)OreDictionary.getOres((String)"ingotCobalt").get(0);
            cobaltStack.field_77994_a = 1;
            ItemStack arditeStack = (ItemStack)OreDictionary.getOres((String)"ingotArdite").get(0);
            arditeStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(cobaltStack, arditeStack, manyullynStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(cobaltStack, ItemDusts.getDustByName("ardite", 1), manyullynStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("cobalt", 1), arditeStack, manyullynStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(ItemDusts.getDustByName("cobalt", 1), ItemDusts.getDustByName("ardite", 1), manyullynStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotConductiveIron")) {
            ItemStack conductiveIronStack = (ItemStack)OreDictionary.getOres((String)"ingotConductiveIron").get(0);
            conductiveIronStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 1), new ItemStack(Items.field_151042_j, 1), conductiveIronStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotRedstoneAlloy") && OreUtil.doesOreExistAndValid((String)"itemSilicon")) {
            ItemStack redstoneAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotRedstoneAlloy").get(0);
            redstoneAlloyStack.field_77994_a = 1;
            ItemStack siliconStack = (ItemStack)OreDictionary.getOres((String)"itemSilicon").get(0);
            siliconStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 1), siliconStack, redstoneAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotPhasedIron")) {
            ItemStack pulsatingIronStack = (ItemStack)OreDictionary.getOres((String)"ingotPhasedIron").get(0);
            pulsatingIronStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 1), new ItemStack(Items.field_151079_bi, 1), pulsatingIronStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 1), ItemDusts.getDustByName("enderPearl", 1), pulsatingIronStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotEnergeticAlloy") && OreUtil.doesOreExistAndValid((String)"ingotPhasedGold")) {
            ItemStack energeticAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotEnergeticAlloy").get(0);
            energeticAlloyStack.field_77994_a = 1;
            ItemStack vibrantAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotPhasedGold").get(0);
            vibrantAlloyStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(energeticAlloyStack, new ItemStack(Items.field_151079_bi, 1), vibrantAlloyStack, 200, 16));
            RecipeHandler.addRecipe(new AlloySmelterRecipe(energeticAlloyStack, ItemDusts.getDustByName("enderPearl", 1), vibrantAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotSoularium")) {
            ItemStack soulariumStack = (ItemStack)OreDictionary.getOres((String)"ingotSoularium").get(0);
            soulariumStack.field_77994_a = 1;
            RecipeHandler.addRecipe(new AlloySmelterRecipe(new ItemStack(Blocks.field_150425_aM, 1), new ItemStack(Items.field_151043_k, 1), soulariumStack, 200, 16));
        }
    }

    static void addPlateCuttingMachineRecipes() {
        RecipeHandler.addRecipe(new PlateCuttingMachineRecipe(new ItemStack(Blocks.field_150343_Z), ItemPlates.getPlateByName("obsidian", 9), 100, 4));
    }

    static void addIndustrialSawmillRecipes() {
        ItemStack pulpStack = (ItemStack)OreDictionary.getOres((String)"pulpWood").get(0);
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 0), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150344_f, 6, 0), pulpStack, null, 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack(Items.field_151131_as), null, new ItemStack(Blocks.field_150344_f, 6, 0), pulpStack, new ItemStack(Items.field_151133_ar), 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 1), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150344_f, 6, 1), pulpStack, null, 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Items.field_151131_as), null, new ItemStack(Blocks.field_150344_f, 6, 1), pulpStack, new ItemStack(Items.field_151133_ar), 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 2), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150344_f, 6, 2), pulpStack, null, 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Items.field_151131_as), null, new ItemStack(Blocks.field_150344_f, 6, 2), pulpStack, new ItemStack(Items.field_151133_ar), 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 3), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150344_f, 6, 3), pulpStack, null, 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Items.field_151131_as), null, new ItemStack(Blocks.field_150344_f, 6, 3), pulpStack, new ItemStack(Items.field_151133_ar), 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150363_s, 1, 0), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150344_f, 6, 4), pulpStack, null, 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack(Items.field_151131_as), null, new ItemStack(Blocks.field_150344_f, 6, 4), pulpStack, new ItemStack(Items.field_151133_ar), 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150363_s, 1, 1), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Blocks.field_150344_f, 6, 5), pulpStack, null, 200, 30, false));
        RecipeHandler.addRecipe(new IndustrialSawmillRecipe(new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Items.field_151131_as), null, new ItemStack(Blocks.field_150344_f, 6, 5), pulpStack, new ItemStack(Items.field_151133_ar), 200, 30, false));
    }

    static void addBlastFurnaceRecipes() {
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("titanium"), null, ItemIngots.getIngotByName("titanium"), null, 3600, 120, 1500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("titanium", 4), null, ItemIngots.getIngotByName("titanium"), null, 3600, 120, 1500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("aluminum"), null, ItemIngots.getIngotByName("aluminum"), null, 2200, 120, 1700));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("aluminum", 4), null, ItemIngots.getIngotByName("aluminum"), null, 2200, 120, 1700));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("kanthal"), null, ItemIngots.getIngotByName("kanthal"), null, 5500, 120, 2500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("kanthal", 4), null, ItemIngots.getIngotByName("kanthal"), null, 5500, 120, 2500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("tungsten"), null, ItemIngots.getIngotByName("tungsten"), null, 18000, 120, 2500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("tungsten", 4), null, ItemIngots.getIngotByName("tungsten"), null, 18000, 120, 2500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("chrome"), null, ItemIngots.getIngotByName("chrome"), null, 4420, 120, 1700));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("chrome", 4), null, ItemIngots.getIngotByName("chrome"), null, 4420, 120, 1700));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("steel"), null, ItemIngots.getIngotByName("steel"), null, 2800, 120, 1000));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("steel", 4), null, ItemIngots.getIngotByName("steel"), null, 2800, 120, 1000));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemDusts.getDustByName("galena", 2), null, ItemIngots.getIngotByName("silver"), ItemIngots.getIngotByName("lead"), 80, 120, 1500));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(new ItemStack(Items.field_151042_j), ItemDusts.getDustByName("coal", 2), ItemIngots.getIngotByName("steel"), ItemDusts.getDustByName("darkAshes", 2), 500, 120, 1000));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(ItemIngots.getIngotByName("tungsten"), ItemIngots.getIngotByName("steel"), ItemIngots.getIngotByName("hotTungstensteel"), ItemDusts.getDustByName("darkAshes", 4), 500, 500, 3000));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(new ItemStack(Blocks.field_150366_p), ItemDusts.getDustByName("calcite"), new ItemStack(Items.field_151042_j, 3), ItemDusts.getDustByName("darkAshes"), 140, 120, 1000));
        RecipeHandler.addRecipe(new BlastFurnaceRecipe(BlockOre.getOreByName("Pyrite"), ItemDusts.getDustByName("calcite"), new ItemStack(Items.field_151042_j, 2), ItemDusts.getDustByName("darkAshes"), 140, 120, 1000));
    }

    static void addUUrecipes() {
        if (ConfigTechReborn.UUrecipesWood) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150364_r, 8), (Object[])new Object[]{" U ", "   ", "   ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesStone) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150348_b, 16), (Object[])new Object[]{"   ", " U ", "   ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesSnowBlock) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150433_aE, 16), (Object[])new Object[]{"U U", "   ", "   ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesGrass) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack((Block)Blocks.field_150349_c, 16), (Object[])new Object[]{"   ", "U  ", "U  ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesObsidian) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150343_Z, 12), (Object[])new Object[]{"U U", "U U", "   ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesGlass) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150359_w, 32), (Object[])new Object[]{" U ", "U U", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesWater) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150355_j, 1), (Object[])new Object[]{"   ", " U ", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesLava) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150353_l, 1), (Object[])new Object[]{" U ", " U ", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesCocoa) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 32, 3), (Object[])new Object[]{"UU ", "  U", "UU ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesGlowstoneBlock) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150426_aN, 8), (Object[])new Object[]{" U ", "U U", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesCactus) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150434_aF, 48), (Object[])new Object[]{" U ", "UUU", "U U", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesSugarCane) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151120_aE, 48), (Object[])new Object[]{"U U", "U U", "U U", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesVine) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150395_bd, 24), (Object[])new Object[]{"U  ", "U  ", "U  ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesSnowBall) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151126_ay, 16), (Object[])new Object[]{"   ", "   ", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151119_aD, 48), (Object[])new Object[]{"UU ", "U  ", "UU ", Character.valueOf('U'), ModItems.uuMatter});
        if (ConfigTechReborn.UUrecipeslilypad) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150392_bi, 64), (Object[])new Object[]{"U U", " U ", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesGunpowder) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151016_H, 15), (Object[])new Object[]{"UUU", "U  ", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesBone) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151103_aS, 32), (Object[])new Object[]{"U  ", "UU ", "U  ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesFeather) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151008_G, 32), (Object[])new Object[]{" U ", " U ", "U U", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesInk) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 48), (Object[])new Object[]{" UU", " UU", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesEnderPearl) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151079_bi, 1), (Object[])new Object[]{"UUU", "U U", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesCoal) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151044_h, 5), (Object[])new Object[]{"  U", "U  ", "  U", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesIronOre) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150366_p, 2), (Object[])new Object[]{"U U", " U ", "U U", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesGoldOre) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150352_o, 2), (Object[])new Object[]{" U ", "UUU", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesRedStone) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151137_ax, 24), (Object[])new Object[]{"   ", " U ", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesLapis) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 9, 4), (Object[])new Object[]{" U ", " U ", " UU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesEmeraldOre) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Blocks.field_150412_bA, 1), (Object[])new Object[]{"UU ", "U U", " UU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesEmerald) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151166_bC, 2), (Object[])new Object[]{"UUU", "UUU", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesDiamond) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(Items.field_151045_i, 1), (Object[])new Object[]{"UUU", "UUU", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesTinDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 10, 77), (Object[])new Object[]{"   ", "U U", "  U", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesCopperDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 10, 21), (Object[])new Object[]{"  U", "U U", "   ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesLeadDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 14, 42), (Object[])new Object[]{"UUU", "UUU", "U  ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesPlatinumDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 1, 58), (Object[])new Object[]{"  U", "UUU", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesTungstenDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 1, 79), (Object[])new Object[]{"U  ", "UUU", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesTitaniumDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 2, 78), (Object[])new Object[]{"UUU", " U ", " U ", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.UUrecipesAluminumDust) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.dusts, 16, 2), (Object[])new Object[]{" U ", " U ", "UUU", Character.valueOf('U'), ModItems.uuMatter});
        }
        if (ConfigTechReborn.HideUuRecipes) {
            ModRecipes.hideUUrecipes();
        }
    }

    static void hideUUrecipes() {
    }

    static void addIndustrialCentrifugeRecipes() {
        RecipeHandler.addRecipe(new CentrifugeRecipe(new ItemStack((Block)Blocks.field_150391_bh, 8), null, new ItemStack((Block)Blocks.field_150338_P, 2), new ItemStack((Block)Blocks.field_150337_Q, 2), new ItemStack(Items.field_151119_aD, 1), new ItemStack((Block)Blocks.field_150354_m, 4), 1640, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(new ItemStack(Items.field_151065_br), null, ItemDusts.getDustByName("darkAshes", 1), ItemDusts.getDustByName("sulfur", 1), null, null, 1240, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(new ItemStack(Items.field_151064_bs, 1), null, new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151123_aH, 1), null, null, 2500, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("electrum", 2), null, ItemDusts.getDustByName("silver", 1), ItemDusts.getDustByName("gold", 1), null, null, 2400, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("invar", 3), null, ItemDusts.getDustByName("iron", 2), ItemDusts.getDustByName("nickel", 1), null, null, 1340, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("marble", 8), null, ItemDusts.getDustByName("magnesium", 1), ItemDusts.getDustByName("calcite", 7), null, null, 1280, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("redrock", 4), null, ItemDusts.getDustByName("calcite", 2), ItemDusts.getDustByName("flint", 1), ItemDusts.getDustByName("clay", 1), null, 640, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("basalt", 16), null, ItemDusts.getDustByName("peridot", 1), ItemDusts.getDustByName("calcite", 3), ItemDusts.getDustByName("magnesium", 8), ItemDusts.getDustByName("darkAshes", 4), 2680, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("yellowGarnet", 16), null, ItemDusts.getDustByName("andradite", 5), ItemDusts.getDustByName("grossular", 8), ItemDusts.getDustByName("uvarovite", 3), null, 2940, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("redGarnet", 16), null, ItemDusts.getDustByName("pyrope", 3), ItemDusts.getDustByName("almandine", 5), ItemDusts.getDustByName("spessartine", 8), null, 2940, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("darkAshes", 2), null, ItemDusts.getDustByName("ashes", 2), null, null, null, 240, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("manyullyn", 2), null, ItemDusts.getDustByName("cobalt", 1), ItemDusts.getDustByName("ardite", 1), null, null, 1240, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("nichrome", 5), null, ItemDusts.getDustByName("nickel", 4), ItemDusts.getDustByName("chrome", 1), null, null, 2240, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("cupronickel", 2), null, ItemDusts.getDustByName("copper", 1), ItemDusts.getDustByName("nickel", 1), null, null, 960, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("kanthal", 3), null, ItemDusts.getDustByName("iron", 1), ItemDusts.getDustByName("aluminum", 1), ItemDusts.getDustByName("chrome", 1), null, 1040, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("brass", 4), null, ItemDusts.getDustByName("zinc", 1), ItemDusts.getDustByName("copper", 3), null, null, 2000, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("aluminumBrass", 4), null, ItemDusts.getDustByName("aluminum", 1), ItemDusts.getDustByName("copper", 3), null, null, 2000, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("bronze", 4), null, ItemDusts.getDustByName("tin", 1), ItemDusts.getDustByName("copper", 3), null, null, 2420, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("netherrack", 16), null, new ItemStack(Items.field_151137_ax, 1), ItemDusts.getDustByName("sulfur", 4), ItemDusts.getDustByName("basalt", 1), new ItemStack(Items.field_151074_bl, 1), 2400, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("enderEye", 1), null, ItemDusts.getDustByName("enderPearl", 1), new ItemStack(Items.field_151065_br, 1), null, null, 1280, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("tetrahedrite", 8), null, ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("antimony", 1), ItemDusts.getDustByName("sulfur", 3), ItemDusts.getDustByName("iron", 1), 3640, 5));
        RecipeHandler.addRecipe(new CentrifugeRecipe(ItemDusts.getDustByName("lapis", 16), null, ItemDusts.getDustByName("lazurite", 12), ItemDusts.getDustByName("sodalite", 2), ItemDusts.getDustByName("pyrite", 7), ItemDusts.getDustByName("calcite", 1), 3580, 5));
    }

    static void addIndustrialGrinderRecipes() {
        ItemStack dustStack;
        ItemStack gemStack;
        ItemStack oreStack;
        for (String ore : OreUtil.oreNames) {
            if (!OreUtil.hasIngot((String)ore) || !OreUtil.hasDustSmall((String)ore) || !OreUtil.hasBlock((String)ore)) continue;
            RecipeHandler.addRecipe(new GrinderRecipe(OreUtil.getStackFromName((String)("block" + ModRecipes.capitalizeFirstLetter(ore))), null, new FluidStack(FluidRegistry.WATER, 1000), OreUtil.getStackFromName((String)("ingot" + ModRecipes.capitalizeFirstLetter(ore))), OreUtil.getStackFromName((String)("dustSmall" + ModRecipes.capitalizeFirstLetter(ore)), (int)6), OreUtil.getStackFromName((String)("dustSmall" + ModRecipes.capitalizeFirstLetter(ore)), (int)2), null, 100, 120));
            RecipeHandler.addRecipe(new GrinderRecipe(OreUtil.getStackFromName((String)("block" + ModRecipes.capitalizeFirstLetter(ore))), new ItemStack(Items.field_151131_as), null, OreUtil.getStackFromName((String)("ingot" + ModRecipes.capitalizeFirstLetter(ore))), OreUtil.getStackFromName((String)("dustSmall" + ModRecipes.capitalizeFirstLetter(ore)), (int)6), OreUtil.getStackFromName((String)("dustSmall" + ModRecipes.capitalizeFirstLetter(ore)), (int)2), new ItemStack(Items.field_151133_ar), 100, 120));
        }
        if (OreUtil.doesOreExistAndValid((String)"oreCopper")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreCopper").get(0);
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("copper", 2), ItemDustsSmall.getSmallDustByName("Gold", 1), ItemDustsSmall.getSmallDustByName("Nickel", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("copper", 2), ItemDustsSmall.getSmallDustByName("Gold", 1), ItemDustsSmall.getSmallDustByName("Nickel", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidSodiumpersulfate, 1000), ItemDusts.getDustByName("copper", 2), ItemDusts.getDustByName("gold", 1), ItemDustsSmall.getSmallDustByName("Nickel", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketSodiumpersulfate), null, ItemDusts.getDustByName("copper", 2), ItemDusts.getDustByName("gold", 1), ItemDustsSmall.getSmallDustByName("Nickel", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("copper", 2), ItemDustsSmall.getSmallDustByName("Gold", 1), ItemDusts.getDustByName("nickel", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, ItemCells.getCellByName("mercury", 1), null, ItemDusts.getDustByName("copper", 2), ItemDustsSmall.getSmallDustByName("Gold", 1), ItemDusts.getDustByName("nickel", 1), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Copper Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreTin")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreTin").get(0);
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("tin", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Zinc", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("tin", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Zinc", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidSodiumpersulfate, 1000), ItemDusts.getDustByName("tin", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDusts.getDustByName("zinc", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketSodiumpersulfate), null, ItemDusts.getDustByName("tin", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDusts.getDustByName("zinc", 1), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Tin Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreNickel")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreNickel").get(0);
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("nickel", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Platinum", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("nickel", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Platinum", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidSodiumpersulfate, 1000), ItemDusts.getDustByName("nickel", 3), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Platinum", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketSodiumpersulfate), null, ItemDusts.getDustByName("nickel", 3), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Platinum", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("nickel", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDusts.getDustByName("platinum", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketMercury), null, ItemDusts.getDustByName("nickel", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDusts.getDustByName("platinum", 1), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Nickel Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreZinc")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreZinc").get(0);
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("zinc", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Tin", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("zinc", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDustsSmall.getSmallDustByName("Tin", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidSodiumpersulfate, 1000), ItemDusts.getDustByName("zinc", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDusts.getDustByName("iron", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketSodiumpersulfate), null, ItemDusts.getDustByName("zinc", 2), ItemDustsSmall.getSmallDustByName("Iron", 1), ItemDusts.getDustByName("iron", 1), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Zinc Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreSilver")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreSilver").get(0);
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("silver", 2), ItemDustsSmall.getSmallDustByName("Lead", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("silver", 2), ItemDustsSmall.getSmallDustByName("Lead", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("silver", 3), ItemDustsSmall.getSmallDustByName("Lead", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketMercury), null, ItemDusts.getDustByName("silver", 3), ItemDustsSmall.getSmallDustByName("Lead", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Silver Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreLead")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreLead").get(0);
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("lead", 2), ItemDustsSmall.getSmallDustByName("Silver", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("lead", 2), ItemDustsSmall.getSmallDustByName("Silver", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), new ItemStack(Items.field_151133_ar), 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("lead", 2), ItemDusts.getDustByName("silver", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(ModItems.bucketMercury), null, ItemDusts.getDustByName("lead", 2), ItemDusts.getDustByName("silver", 1), ItemDustsSmall.getSmallDustByName("Sulfur", 1), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Lead Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreApatite") & OreUtil.doesOreExistAndValid((String)"gemApatite")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreApatite").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"gemApatite").get(0);
                gemStack.field_77994_a = 6;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, gemStack, ItemDustsSmall.getSmallDustByName("Phosphorous", 4), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, gemStack, ItemDustsSmall.getSmallDustByName("Phosphorous", 4), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Apatite Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"dustNetherQuartz")) {
            try {
                ItemStack dustStack2 = (ItemStack)OreDictionary.getOres((String)"dustNetherQuartz").get(0);
                dustStack2.field_77994_a = 4;
                RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(Blocks.field_150449_bY, 1), null, new FluidStack(FluidRegistry.WATER, 1000), new ItemStack(Items.field_151128_bU, 2), dustStack2, ItemDustsSmall.getSmallDustByName("Netherrack", 2), null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(Blocks.field_150449_bY, 1), new ItemStack(Items.field_151131_as), null, new ItemStack(Items.field_151128_bU, 2), dustStack2, ItemDustsSmall.getSmallDustByName("Netherrack", 2), new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Nether Quartz Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreCertusQuartz")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreCertusQuartz").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0);
                dustStack = (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0);
                dustStack.field_77994_a = 2;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, dustStack, null, null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, dustStack, null, new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Certus Quartz Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreChargedCertusQuartz")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreChargedCertusQuartz").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"crystalChargedCertusQuartz").get(0);
                dustStack = (ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0);
                dustStack.field_77994_a = 2;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, dustStack, null, null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, dustStack, null, new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Charged Certus Quartz Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreAmethyst") && OreUtil.doesOreExistAndValid((String)"gemAmethyst")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreAmethyst").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"gemAmethyst").get(0);
                gemStack.field_77994_a = 2;
                dustStack = (ItemStack)OreDictionary.getOres((String)"gemAmethyst").get(0);
                dustStack.field_77994_a = 1;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, dustStack, null, null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, dustStack, null, new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Certus Quartz Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreTopaz") && OreUtil.doesOreExistAndValid((String)"gemTopaz")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreTopaz").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"gemTopaz").get(0);
                gemStack.field_77994_a = 2;
                dustStack = (ItemStack)OreDictionary.getOres((String)"gemTopaz").get(0);
                dustStack.field_77994_a = 1;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, dustStack, null, null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, dustStack, null, new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Topaz Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreTanzanite") && OreUtil.doesOreExistAndValid((String)"gemTanzanite")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreTanzanite").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"gemTanzanite").get(0);
                gemStack.field_77994_a = 2;
                dustStack = (ItemStack)OreDictionary.getOres((String)"gemTanzanite").get(0);
                dustStack.field_77994_a = 1;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, dustStack, null, null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, dustStack, null, new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Tanzanite Ore");
            }
        }
        if (OreUtil.doesOreExistAndValid((String)"oreMalachite") && OreUtil.doesOreExistAndValid((String)"gemMalachite")) {
            try {
                oreStack = (ItemStack)OreDictionary.getOres((String)"oreMalachite").get(0);
                gemStack = (ItemStack)OreDictionary.getOres((String)"gemMalachite").get(0);
                gemStack.field_77994_a = 2;
                dustStack = (ItemStack)OreDictionary.getOres((String)"gemMalachite").get(0);
                dustStack.field_77994_a = 1;
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, null, new FluidStack(FluidRegistry.WATER, 1000), gemStack, dustStack, null, null, 100, 120));
                RecipeHandler.addRecipe(new GrinderRecipe(oreStack, new ItemStack(Items.field_151131_as), null, gemStack, dustStack, null, new ItemStack(Items.field_151133_ar), 100, 120));
            }
            catch (Exception e) {
                Core.logHelper.info((Object)"Failed to Load Grinder Recipe for Malachite Ore");
            }
        }
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 0), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("galena", 2), ItemDustsSmall.getSmallDustByName("Sulfur", 1), ItemDustsSmall.getSmallDustByName("Silver", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 0), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("galena", 2), ItemDustsSmall.getSmallDustByName("Sulfur", 1), ItemDustsSmall.getSmallDustByName("Silver", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 0), null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("galena", 2), ItemDustsSmall.getSmallDustByName("Sulfur", 1), ItemDusts.getDustByName("silver", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 0), new ItemStack(ModItems.bucketMercury), null, ItemDusts.getDustByName("galena", 2), ItemDustsSmall.getSmallDustByName("Sulfur", 1), ItemDusts.getDustByName("silver", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 2), null, new FluidStack(FluidRegistry.WATER, 1000), ItemGems.getGemByName("ruby", 1), ItemDustsSmall.getSmallDustByName("Ruby", 6), ItemDustsSmall.getSmallDustByName("Chrome", 2), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 2), new ItemStack(Items.field_151131_as), null, ItemGems.getGemByName("ruby", 1), ItemDustsSmall.getSmallDustByName("Ruby", 6), ItemDustsSmall.getSmallDustByName("Chrome", 2), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 3), null, new FluidStack(FluidRegistry.WATER, 1000), ItemGems.getGemByName("sapphire", 1), ItemDustsSmall.getSmallDustByName("Sapphire", 6), ItemDustsSmall.getSmallDustByName("Aluminum", 2), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 3), new ItemStack(Items.field_151131_as), null, ItemGems.getGemByName("sapphire", 1), ItemDustsSmall.getSmallDustByName("Sapphire", 6), ItemDustsSmall.getSmallDustByName("Aluminum", 2), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 4), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("bauxite", 2), ItemDustsSmall.getSmallDustByName("Grossular", 4), ItemDustsSmall.getSmallDustByName("Titanium", 4), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 4), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("bauxite", 2), ItemDustsSmall.getSmallDustByName("Grossular", 4), ItemDustsSmall.getSmallDustByName("Titanium", 4), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 5), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("pyrite", 2), ItemDustsSmall.getSmallDustByName("Sulfur", 1), ItemDustsSmall.getSmallDustByName("Phosphorous", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 5), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("pyrite", 2), ItemDustsSmall.getSmallDustByName("Sulfur", 1), ItemDustsSmall.getSmallDustByName("Phosphorous", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 6), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("cinnabar", 2), ItemDustsSmall.getSmallDustByName("Redstone", 1), ItemDustsSmall.getSmallDustByName("Glowstone", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 6), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("cinnabar", 2), ItemDustsSmall.getSmallDustByName("Redstone", 1), ItemDustsSmall.getSmallDustByName("Glowstone", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 7), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("sphalerite", 2), ItemDustsSmall.getSmallDustByName("Zinc", 1), ItemDustsSmall.getSmallDustByName("YellowGarnet", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 7), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("sphalerite", 2), ItemDustsSmall.getSmallDustByName("Zinc", 1), ItemDustsSmall.getSmallDustByName("YellowGarnet", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 7), null, new FluidStack(ModFluids.fluidSodiumpersulfate, 1000), ItemDusts.getDustByName("sphalerite", 2), ItemDusts.getDustByName("zinc", 1), ItemDustsSmall.getSmallDustByName("YellowGarnet", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 7), new ItemStack(ModItems.bucketSodiumpersulfate), null, ItemDusts.getDustByName("sphalerite", 2), ItemDusts.getDustByName("zinc", 1), ItemDustsSmall.getSmallDustByName("YellowGarnet", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 8), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("tungsten", 2), ItemDustsSmall.getSmallDustByName("Manganese", 1), ItemDustsSmall.getSmallDustByName("Silver", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 8), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("tungsten", 2), ItemDustsSmall.getSmallDustByName("Manganese", 1), ItemDustsSmall.getSmallDustByName("Silver", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 8), null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("tungsten", 2), ItemDustsSmall.getSmallDustByName("Manganese", 1), ItemDusts.getDustByName("silver", 2), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 8), new ItemStack(ModItems.bucketMercury), null, ItemDusts.getDustByName("tungsten", 2), ItemDustsSmall.getSmallDustByName("Manganese", 1), ItemDusts.getDustByName("silver", 2), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 9), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("platinum", 2), ItemDustsSmall.getSmallDustByName("Iridium", 1), ItemDustsSmall.getSmallDustByName("Iridium", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 9), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("platinum", 2), ItemDustsSmall.getSmallDustByName("Iridium", 1), ItemDustsSmall.getSmallDustByName("Iridium", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 9), null, new FluidStack(ModFluids.fluidMercury, 1000), ItemDusts.getDustByName("platinum", 3), ItemDustsSmall.getSmallDustByName("Iridium", 1), ItemDustsSmall.getSmallDustByName("Iridium", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 9), new ItemStack(ModItems.bucketMercury), null, ItemDusts.getDustByName("platinum", 3), ItemDustsSmall.getSmallDustByName("Iridium", 1), ItemDustsSmall.getSmallDustByName("Iridium", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 10), null, new FluidStack(FluidRegistry.WATER, 1000), ItemGems.getGemByName("peridot", 1), ItemDustsSmall.getSmallDustByName("Peridot", 6), ItemDustsSmall.getSmallDustByName("Pyrope", 2), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 10), new ItemStack(Items.field_151131_as), null, ItemGems.getGemByName("peridot", 1), ItemDustsSmall.getSmallDustByName("Peridot", 6), ItemDustsSmall.getSmallDustByName("Pyrope", 2), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 11), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("sodalite", 12), ItemDustsSmall.getSmallDustByName("Lazurite", 4), ItemDustsSmall.getSmallDustByName("Lapis", 4), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 11), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("sodalite", 12), ItemDustsSmall.getSmallDustByName("Lazurite", 4), ItemDustsSmall.getSmallDustByName("Lapis", 4), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 12), null, new FluidStack(FluidRegistry.WATER, 1000), ItemDusts.getDustByName("tetrahedrite", 2), ItemDustsSmall.getSmallDustByName("Antimony", 1), ItemDustsSmall.getSmallDustByName("Zinc", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 12), new ItemStack(Items.field_151131_as), null, ItemDusts.getDustByName("tetrahedrite", 2), ItemDustsSmall.getSmallDustByName("Antimony", 1), ItemDustsSmall.getSmallDustByName("Zinc", 1), new ItemStack(Items.field_151133_ar), 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 12), null, new FluidStack(ModFluids.fluidSodiumpersulfate, 1000), ItemDusts.getDustByName("tetrahedrite", 3), ItemDustsSmall.getSmallDustByName("Antimony", 1), ItemDustsSmall.getSmallDustByName("Zinc", 1), null, 100, 120));
        RecipeHandler.addRecipe(new GrinderRecipe(new ItemStack(ModBlocks.ore, 1, 12), new ItemStack(ModItems.bucketSodiumpersulfate), null, ItemDusts.getDustByName("tetrahedrite", 3), ItemDustsSmall.getSmallDustByName("Antimony", 1), ItemDustsSmall.getSmallDustByName("Zinc", 1), new ItemStack(Items.field_151133_ar), 100, 120));
    }

    static void addImplosionCompressorRecipes() {
    }

    static void addChemicalReactorRecipes() {
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(ItemCells.getCellByName("calcium", 1), ItemCells.getCellByName("carbon", 1), ItemCells.getCellByName("calciumCarbonate", 2), 240, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(new ItemStack(Items.field_151074_bl, 8), new ItemStack(Items.field_151127_ba, 1), new ItemStack(Items.field_151060_bw, 1), 40, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(ItemCells.getCellByName("nitrogen", 1), ItemCells.getCellByName("carbon", 1), ItemCells.getCellByName("nitrocarbon", 2), 1500, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(ItemCells.getCellByName("carbon", 1), ItemCells.getCellByName("hydrogen", 4), ItemCells.getCellByName("methane", 5), 3500, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(ItemCells.getCellByName("sulfur", 1), ItemCells.getCellByName("sodium", 1), ItemCells.getCellByName("sodiumSulfide", 2), 100, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151079_bi, 1), new ItemStack(Items.field_151061_bv, 1), 40, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(new ItemStack(Items.field_151074_bl, 8), new ItemStack(Items.field_151172_bF, 1), new ItemStack(Items.field_151150_bK, 1), 40, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(ItemCells.getCellByName("glyceryl", 1), ItemCells.getCellByName("diesel", 4), ItemCells.getCellByName("nitroDiesel", 5), 1000, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(new ItemStack(Items.field_151043_k, 8), new ItemStack(Items.field_151034_e, 1), new ItemStack(Items.field_151153_ao, 1), 40, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(new ItemStack(Blocks.field_150340_R, 8), new ItemStack(Items.field_151034_e, 1), new ItemStack(Items.field_151153_ao, 1, 1), 40, 30));
        RecipeHandler.addRecipe(new ChemicalReactorRecipe(new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151123_aH, 1), new ItemStack(Items.field_151064_bs, 1), 40, 30));
    }

    static void addIndustrialElectrolyzerRecipes() {
        RecipeHandler.addRecipe(new IndustrialElectrolyzerRecipe(ItemCells.getCellByName("nitrocarbon", 2), null, ItemCells.getCellByName("nitrogen"), ItemCells.getCellByName("carbon"), null, null, 80, 60));
        RecipeHandler.addRecipe(new IndustrialElectrolyzerRecipe(ItemDusts.getDustByName("pyrite", 3), null, ItemDusts.getDustByName("iron"), ItemDusts.getDustByName("sulfur"), null, null, 120, 128));
        RecipeHandler.addRecipe(new IndustrialElectrolyzerRecipe(ItemDusts.getDustByName("sphalerite", 2), null, ItemDusts.getDustByName("zinc"), ItemDusts.getDustByName("sulfur"), null, null, 150, 100));
    }
}

