/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.recipes;

import buildcraft.api.fuels.IFuel;
import buildcraft.core.Version;
import buildcraft.energy.fuels.FuelManager;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import reborncore.api.fuel.FluidPowerManager;
import reborncore.common.util.CraftingHelper;
import reborncore.common.util.RecipeRemover;
import techreborn.Core;
import techreborn.compat.ICompatModule;
import techreborn.config.ConfigTechReborn;

public class RecipesBuildcraft
implements ICompatModule {
    public static Block quarryBlock;

    public static void removeRecipes() {
        RecipeRemover.removeAnyRecipe((ItemStack)new ItemStack(quarryBlock));
    }

    public static void addRecipies() {
        Item drill = IC2Items.getItem("diamondDrill").func_77973_b();
        ItemStack drillStack = new ItemStack(drill, 1, Short.MAX_VALUE);
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(quarryBlock), (Object[])new Object[]{"IAI", "GIG", "DED", Character.valueOf('I'), "gearIron", Character.valueOf('G'), "gearGold", Character.valueOf('D'), "gearDiamond", Character.valueOf('A'), IC2Items.getItem("advancedCircuit"), Character.valueOf('E'), drillStack});
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        Core.logHelper.info((Object)"Trying to change the quarry recipe");
        try {
            Object obj;
            String itemClass = "buildcraft.BuildCraftBuilders";
            if (!Version.getVersion().startsWith("7")) {
                if (Loader.isModLoaded((String)"BuildCraft|Factory")) {
                    itemClass = "buildcraft.BuildCraftFactory";
                }
            } else if (!Version.getVersion().startsWith("7") && !Loader.isModLoaded((String)"BuildCraft|Builders")) {
                Core.logHelper.info((Object)"Buildcraft not found");
                return;
            }
            if (!((obj = Class.forName(itemClass).getField("quarryBlock").get(null)) instanceof Block)) {
                Core.logHelper.fatal((Object)"Could not retrieve quarry block from Buildcraft! This is a fatal error!");
                return;
            }
            quarryBlock = (Block)obj;
            Core.logHelper.info((Object)("Found Quarry Block from buildcraft at " + itemClass + ":quarryBlock"));
        }
        catch (Exception ex) {
            Core.logHelper.fatal((Object)"Could not retrieve quarry block from Buildcraft! This is a fatal error!");
            ex.printStackTrace();
            return;
        }
        RecipesBuildcraft.removeRecipes();
        RecipesBuildcraft.addRecipies();
        for (IFuel fuel : FuelManager.INSTANCE.getFuels()) {
            FluidPowerManager.fluidPowerValues.put(fuel.getFluid(), (double)fuel.getPowerPerCycle() / (double)ConfigTechReborn.euPerRF);
        }
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }
}

