/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat;

import cpw.mods.fml.common.Loader;
import ic2.api.info.IC2Classic;
import java.util.ArrayList;
import techreborn.Core;
import techreborn.compat.ICompatModule;
import techreborn.compat.ee3.EmcValues;
import techreborn.compat.fmp.ForgeMultipartCompat;
import techreborn.compat.minetweaker.MinetweakerCompat;
import techreborn.compat.recipes.RecipesBiomesOPlenty;
import techreborn.compat.recipes.RecipesBuildcraft;
import techreborn.compat.recipes.RecipesForestry;
import techreborn.compat.recipes.RecipesIC2;
import techreborn.compat.recipes.RecipesStandalone;
import techreborn.compat.recipes.RecipesThaumcraft;
import techreborn.compat.recipes.RecipesThermalExpansion;
import techreborn.compat.waila.CompatModuleWaila;
import techreborn.config.ConfigTechReborn;

public class CompatManager {
    public ArrayList<ICompatModule> compatModules = new ArrayList();
    public static CompatManager INSTANCE = new CompatManager();
    public static boolean isIC2Loaded = false;
    public static boolean isIC2ClassicLoaded = false;
    public static boolean isClassicEnet = false;
    public static boolean isGregTechLoaded = false;

    public CompatManager() {
        isIC2Loaded = Loader.isModLoaded((String)"IC2");
        isIC2ClassicLoaded = IC2Classic.isIc2ClassicLoaded();
        if (isIC2ClassicLoaded) {
            isClassicEnet = true;
        }
        if (Loader.isModLoaded((String)"Uncomplication")) {
            isClassicEnet = true;
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            isGregTechLoaded = true;
        }
        this.registerCompact(CompatModuleWaila.class, "Waila");
        this.registerCompact(RecipesIC2.class, "IC2");
        this.registerCompact(RecipesStandalone.class, "!IC2");
        this.registerCompact(RecipesBuildcraft.class, "BuildCraft|Core", "IC2");
        this.registerCompact(RecipesThermalExpansion.class, "ThermalExpansion");
        this.registerCompact(EmcValues.class, "EE3");
        this.registerCompact(RecipesBiomesOPlenty.class, "BiomesOPlenty");
        this.registerCompact(RecipesThaumcraft.class, "Thaumcraft");
        this.registerCompact(RecipesForestry.class, "Forestry", this.isForestry4());
        this.registerCompact(MinetweakerCompat.class, "MineTweaker3");
        this.registerCompact(ForgeMultipartCompat.class, "ForgeMultipart");
    }

    public void registerCompact(Class<?> moduleClass, Object ... objs) {
        Core.logHelper.info((Object)("Attempting to loading compat module " + moduleClass.getSimpleName()));
        boolean shouldLoad = ConfigTechReborn.config.get(ConfigTechReborn.CATEGORY_INTEGRATION, "Compat:" + moduleClass.getSimpleName(), true, "Should the " + moduleClass.getSimpleName() + " be loaded?").getBoolean(true);
        if (ConfigTechReborn.config.hasChanged()) {
            ConfigTechReborn.config.save();
        }
        if (!shouldLoad) {
            Core.logHelper.info((Object)("Compat module " + moduleClass.getSimpleName() + " was not loaded because it has been disabled in the config file."));
            return;
        }
        for (Object obj : objs) {
            if (obj instanceof String) {
                String modid = (String)obj;
                if (modid.startsWith("!")) {
                    if (!Loader.isModLoaded((String)modid.replaceAll("!", ""))) continue;
                    Core.logHelper.info((Object)("Compat module " + moduleClass.getSimpleName() + " has not been loaded because " + modid.replaceAll("!", "") + " is loaded!"));
                    return;
                }
                if (Loader.isModLoaded((String)modid)) continue;
                Core.logHelper.info((Object)("Compat module " + moduleClass.getSimpleName() + " has not been loaded because " + modid.replaceAll("!", "") + " is not loaded!"));
                return;
            }
            if (!(obj instanceof Boolean)) continue;
            Boolean boo = (Boolean)obj;
            if (!boo.booleanValue()) {
                // empty if block
            }
            Core.logHelper.info((Object)("Compat module " + moduleClass.getSimpleName() + " has not been loaded because it was told not to"));
            return;
        }
        Core.logHelper.info((Object)("Compat module " + moduleClass.getSimpleName() + " has been loaded"));
        try {
            this.compatModules.add((ICompatModule)moduleClass.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean isForestry4() {
        try {
            Class.forName("forestry.api.arboriculture.EnumWoodType");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

