/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import openmods.geometry.Box2d;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.utils.IPointList;
import openperipheral.addons.glasses.utils.IPointListBuilder;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.struct.ScriptStruct;
import openperipheral.api.struct.StructField;

@AdapterSourceName(value="glasses_shape")
public abstract class BoundedShape<P>
extends Drawable {
    protected IPointList<P> pointList;

    @Override
    protected void drawContents(RenderState renderState, float partialTicks) {
        renderState.setupSolidRender();
    }

    protected abstract void addPoints(IPointListBuilder<P> var1);

    protected abstract IPointListBuilder<P> createBuilder();

    @ScriptCallable(returnTypes={ReturnType.TABLE}, name="getBoundingBox", description="Get position of top left corner and dimensions")
    public SimpleBox getBox() {
        Box2d bb = this.createAndFillBuilder().buildBoundingBox();
        return new SimpleBox(bb);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateBoundingBox();
    }

    private IPointListBuilder<P> createAndFillBuilder() {
        IPointListBuilder<P> builder = this.createBuilder();
        this.addPoints(builder);
        return builder;
    }

    protected final void updateBoundingBox() {
        IPointListBuilder<P> builder = this.createAndFillBuilder();
        this.pointList = builder.buildPointList();
        this.setBoundingBox(builder.buildBoundingBox());
    }

    @ScriptStruct
    public static class SimpleBox {
        @StructField
        public float top;
        @StructField
        public float left;
        @StructField
        public float width;
        @StructField
        public float height;

        public SimpleBox() {
        }

        public SimpleBox(Box2d box) {
            this.top = box.top;
            this.left = box.left;
            this.width = box.width;
            this.height = box.height;
        }
    }
}

