/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import reborncore.common.IModInfo;

public class VersionChecker {
    public static final String apiAddress = "http://modmuss50.me/api/v1/version.php";
    public String projectName;
    public IModInfo modInfo;
    ArrayList<ModifacationVersionInfo> versions;
    public boolean isChecking;

    public VersionChecker(String projectName, IModInfo modInfo) {
        this.projectName = projectName;
        this.modInfo = modInfo;
    }

    public void checkVersion() throws IOException {
        this.isChecking = true;
        URL url = new URL("http://modmuss50.me/api/v1/version.php?project=" + this.projectName);
        URLConnection con = url.openConnection();
        InputStream in = con.getInputStream();
        String encoding = con.getContentEncoding();
        encoding = encoding == null ? "UTF-8" : encoding;
        String body = IOUtils.toString((InputStream)in, (String)encoding).replaceAll("<br />", "");
        Gson gson = new Gson();
        this.versions = (ArrayList)gson.fromJson(body, new TypeToken<ArrayList<ModifacationVersionInfo>>(){}.getType());
        this.isChecking = false;
    }

    public void checkVersionThreaded() {
        class VersionCheckerThread
        extends Thread {
            VersionCheckerThread() {
            }

            @Override
            public void run() {
                try {
                    VersionChecker.this.checkVersion();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        VersionCheckerThread thread = new VersionCheckerThread();
        thread.start();
    }

    public boolean isLatestVersion() {
        if (this.versions == null || this.versions.isEmpty()) {
            return true;
        }
        return this.versions.get((int)0).version.equals(this.modInfo.MOD_VERSION());
    }

    public ModifacationVersionInfo getLatestVersion() {
        if (this.versions == null || this.versions.isEmpty()) {
            return null;
        }
        return this.versions.get(0);
    }

    public ArrayList<String> getChangeLogSinceCurrentVersion() {
        ArrayList<String> log = new ArrayList<String>();
        if (!this.isLatestVersion()) {
            for (ModifacationVersionInfo version : this.versions) {
                if (version.version.equals(this.modInfo.MOD_VERSION())) break;
                log.addAll(version.changeLog);
            }
        }
        return log;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Generating example json file");
        ArrayList<ModifacationVersionInfo> infos = new ArrayList<ModifacationVersionInfo>();
        ArrayList<String> changelog = new ArrayList<String>();
        changelog.add("A change");
        changelog.add("Another change");
        infos.add(new ModifacationVersionInfo("1.1.1", "1.7.10", changelog, "12th July", true));
        infos.add(new ModifacationVersionInfo("1.2.0", "1.7.10", changelog, "28th July", true));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(infos);
        try {
            FileWriter writer = new FileWriter(new File("master.json"));
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class ModifacationVersionInfo {
        public String version;
        public String minecraftVersion;
        public ArrayList<String> changeLog;
        public String releaseDate;
        public boolean recommended;

        public ModifacationVersionInfo(String version, String minecraftVersion, ArrayList<String> changeLog, String releaseDate, boolean recommended) {
            this.version = version;
            this.minecraftVersion = minecraftVersion;
            this.changeLog = changeLog;
            this.releaseDate = releaseDate;
            this.recommended = recommended;
        }

        public ModifacationVersionInfo() {
        }
    }
}

