/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuiUtil {
    public static void drawRepeated(IIcon icon, double x, double y, double width, double height, double z) {
        double iconWidthStep = (double)(icon.func_94212_f() - icon.func_94209_e()) / 16.0;
        double iconHeightStep = (double)(icon.func_94210_h() - icon.func_94206_g()) / 16.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (double cy = y; cy < y + height; cy += 16.0) {
            double quadHeight = Math.min(16.0, height + y - cy);
            double maxY = cy + quadHeight;
            double maxV = (double)icon.func_94206_g() + iconHeightStep * quadHeight;
            for (double cx = x; cx < x + width; cx += 16.0) {
                double quadWidth = Math.min(16.0, width + x - cx);
                double maxX = cx + quadWidth;
                double maxU = (double)icon.func_94209_e() + iconWidthStep * quadWidth;
                tessellator.func_78374_a(cx, maxY, z, (double)icon.func_94209_e(), maxV);
                tessellator.func_78374_a(maxX, maxY, z, maxU, maxV);
                tessellator.func_78374_a(maxX, cy, z, maxU, (double)icon.func_94206_g());
                tessellator.func_78374_a(cx, cy, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            }
        }
        tessellator.func_78381_a();
    }

    public static void drawTooltipBox(int x, int y, int w, int h) {
        int bg = -267386864;
        GuiUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        GuiUtil.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        GuiUtil.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        GuiUtil.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        GuiUtil.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        int grad1 = 0x505000FF;
        int grad2 = 1344798847;
        GuiUtil.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        GuiUtil.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        GuiUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        GuiUtil.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        new GuiHook().func_73733_a(x, y, x + w, y + h, colour1, colour2);
    }

    public static void drawColouredBox(int colour, int alpha, double posX, double posY, double width, double height) {
        GuiUtil.drawColouredBox(colour, alpha, posX, posY, width, height, 0.0);
    }

    public static void drawColouredBox(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        GuiUtil.drawColouredBox(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColouredBox(int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(r, g, b, alpha);
        tessellator.func_78377_a(posX, posY + height, zLevel);
        tessellator.func_78377_a(posX + width, posY + height, zLevel);
        tessellator.func_78377_a(posX + width, posY, zLevel);
        tessellator.func_78377_a(posX, posY, zLevel);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static class GuiHook
    extends Gui {
        public void func_73733_a(int par1, int par2, int par3, int par4, int par5, int par6) {
            super.func_73733_a(par1, par2, par3, par4, par5, par6);
        }
    }
}

