/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.timer;

import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.timer.Event;
import info.loenwind.enderioaddons.timer.Scheduler;
import java.util.Calendar;
import java.util.Locale;

public class Celeb24
implements Event {
    private final Calendar start = Calendar.getInstance(Locale.getDefault());
    private final Calendar end = Calendar.getInstance(Locale.getDefault());

    public static void create() {
        Scheduler.instance.registerEvent(new Celeb24());
    }

    private Celeb24() {
        this.start.set(2015, 11, 24, 12, 0, 0);
        this.end.set(2015, 11, 27, 0, 0, 0);
    }

    @Override
    public boolean isActive(Calendar now) {
        if (this.start.before(now)) {
            if (this.end.before(now)) {
                this.calculate(now);
                EnderIOAddons.mode24 = false;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public long getTimeToStart(Calendar now) {
        long remaining = this.start.getTimeInMillis() - now.getTimeInMillis();
        return remaining < 0L ? 0L : remaining;
    }

    @Override
    public void calculate(Calendar now) {
        while (this.end.before(now)) {
            this.start.add(1, 1);
            this.end.add(1, 1);
        }
    }

    @Override
    public void run(Calendar now) {
        EnderIOAddons.mode24 = true;
    }

    public String toString() {
        return "Celeb24 [start=" + this.start + ", end=" + this.end + "]";
    }
}

