/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.render;

import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import info.loenwind.enderioaddons.machine.afarm.BlockAfarm;
import info.loenwind.enderioaddons.render.FaceRenderer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class OverlayRenderer {
    private static float[] brightnessPerSide = new float[6];
    private static BoundingBox shell;

    public static <T extends AbstractMachineEntity> boolean renderOverlays(IBlockAccess world, int x, int y, int z, @Nullable BoundingBox bb, @Nullable IIcon overrideTexture, AbstractMachineBlock<T> block, @Nonnull Class<T> clazz) {
        return OverlayRenderer.renderOverlays(world, x, y, z, bb, overrideTexture, block, clazz, false);
    }

    public static <T extends AbstractMachineEntity> boolean renderOverlays(IBlockAccess world, int x, int y, int z, @Nullable BoundingBox bb, @Nullable IIcon overrideTexture, AbstractMachineBlock<T> block, @Nonnull Class<T> clazz, boolean addTranslation) {
        TileEntity tileEntity;
        if (overrideTexture != null) {
            return OverlayRenderer.renderOverlays(world, x, y, z, bb, overrideTexture, block, (AbstractMachineEntity)null, addTranslation);
        }
        if (world != null && clazz.isInstance(tileEntity = world.func_147438_o(x, y, z))) {
            return OverlayRenderer.renderOverlays(world, x, y, z, bb, overrideTexture, block, (AbstractMachineEntity)tileEntity, addTranslation);
        }
        return false;
    }

    public static <T extends AbstractMachineEntity> boolean renderOverlays(IBlockAccess world, int x, int y, int z, @Nullable BoundingBox bb, @Nullable IIcon overrideTexture, AbstractMachineBlock<T> block, @Nullable T te) {
        return OverlayRenderer.renderOverlays(world, x, y, z, bb, overrideTexture, block, te, false);
    }

    public static <T extends AbstractMachineEntity> boolean renderOverlays(IBlockAccess world, int x, int y, int z, @Nullable BoundingBox bb, @Nullable IIcon overrideTexture, AbstractMachineBlock<T> block, @Nullable T te, boolean addTranslation) {
        if (overrideTexture != null) {
            if (addTranslation) {
                Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
            }
            FaceRenderer.setLightingReference(world, (Block)BlockAfarm.blockAfarm, x, y, z);
            FaceRenderer.renderCube(bb == null ? shell : bb, overrideTexture, null, brightnessPerSide, false);
            FaceRenderer.clearLightingReference();
            if (addTranslation) {
                Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
            }
            return true;
        }
        if (te != null) {
            IIcon[] icons = null;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IIcon icon = block.getOverlayIconForMode(te, dir, te.getIoMode(dir));
                if (icon == null) continue;
                if (icons == null) {
                    icons = new IIcon[ForgeDirection.values().length];
                }
                icons[dir.ordinal()] = icon;
            }
            if (icons != null) {
                if (addTranslation) {
                    Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
                }
                FaceRenderer.setLightingReference(world, (Block)BlockAfarm.blockAfarm, x, y, z);
                FaceRenderer.renderCube(bb == null ? shell : bb, icons, null, brightnessPerSide, false);
                FaceRenderer.clearLightingReference();
                if (addTranslation) {
                    Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
                }
            }
        }
        return false;
    }

    static {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            OverlayRenderer.brightnessPerSide[dir.ordinal()] = 1.0f;
        }
        shell = BoundingBox.UNIT_CUBE.scale(1.002, 1.002, 1.002);
    }
}

