/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.network;

import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PacketParticles
implements IMessage,
IMessageHandler<PacketParticles, IMessage> {
    private String particle;
    private double posx;
    private double posy;
    private double posz;
    private double velx;
    private double vely;
    private double velz;

    public PacketParticles() {
    }

    public PacketParticles(String particle, double x, double y, double z, double velx, double vely, double velz) {
        this.particle = particle;
        this.posx = x;
        this.posy = y;
        this.posz = z;
        this.velx = velx;
        this.vely = vely;
        this.velz = velz;
    }

    public static void spawnParticle(World world, String particle, BlockCoord bc, double velx, double vely, double velz) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketParticles(particle, bc.x, bc.y, bc.z, velx, vely, velz), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)bc.x, (double)bc.y, (double)bc.z, 24.0));
    }

    public static void spawnParticle(World world, String particle, double x, double y, double z, double velx, double vely, double velz) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketParticles(particle, x, y, z, velx, vely, velz), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 24.0));
    }

    public void toBytes(ByteBuf buf) {
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.particle.getBytes());
        buf.writeDouble(this.posx);
        buf.writeDouble(this.posy);
        buf.writeDouble(this.posz);
        buf.writeDouble(this.velx);
        buf.writeDouble(this.vely);
        buf.writeDouble(this.velz);
    }

    public void fromBytes(ByteBuf buf) {
        this.particle = new String(NetworkUtil.readByteArray((ByteBuf)buf));
        this.posx = buf.readDouble();
        this.posy = buf.readDouble();
        this.posz = buf.readDouble();
        this.velx = buf.readDouble();
        this.vely = buf.readDouble();
        this.velz = buf.readDouble();
    }

    public IMessage onMessage(PacketParticles message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        if (player != null) {
            player.field_70170_p.func_72869_a(message.particle, message.posx, message.posy, message.posz, message.velx, message.vely, message.velz);
        }
        return null;
    }
}

