/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.waterworks;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.enderioaddons.HandleStash;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.baseclass.TileEnderIOAddons;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.config.Config;
import info.loenwind.enderioaddons.fluid.Fluids;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import info.loenwind.enderioaddons.machine.waterworks.BlockWaterworks;
import info.loenwind.enderioaddons.machine.waterworks.ColMap;
import info.loenwind.enderioaddons.machine.waterworks.DummyRecipe;
import info.loenwind.enderioaddons.machine.waterworks.PacketWaterworksProgress;
import info.loenwind.enderioaddons.machine.waterworks.TaskWaterworks;
import info.loenwind.enderioaddons.machine.waterworks.engine.ConfigProvider;
import info.loenwind.enderioaddons.machine.waterworks.engine.Engine;
import info.loenwind.enderioaddons.machine.waterworks.engine.Stash;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Storable
public class TileWaterworks
extends TileEnderIOAddons
implements IFrameworkMachine,
IFluidHandler,
ITankAccess {
    private static final int ONE_BLOCK_OF_LIQUID = 1000;
    @Nonnull
    @Store
    protected SmartTank inputTank = new SmartTank(3000);
    @Nonnull
    @Store
    protected SmartTank outputTank = new SmartTank(1000);
    private static int IO_MB_TICK = 200;
    boolean tanksDirty = false;
    @Nullable
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.CLIENT})
    protected Fluid progress_in = null;
    @Nullable
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.CLIENT})
    protected Fluid progress_out = null;
    @Nonnull
    protected static final Engine engine = new Engine(ConfigProvider.readConfig());
    @Nonnull
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM}, handler=HandleStash.class)
    protected final Stash stash = new Stash();
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM, Store.StoreFor.CLIENT})
    protected float stashProgress = 0.0f;
    protected static ColMap data;
    protected boolean insertingIntoSelf = false;

    public TileWaterworks() {
        super(new SlotDefinition(0, 14, 1));
        if (data == null) {
            int amount = 1000 * Config.waterWorksWaterReductionPercentage.getInt() / 100;
            data = new ColMap(5);
            data.set(0, NullHelper.notnullF(FluidRegistry.WATER, "FluidRegistry.WATER"), Fluids.BRINE1, 0, amount);
            data.set(1, Fluids.BRINE1, Fluids.BRINE2, 1, amount);
            data.set(2, Fluids.BRINE2, Fluids.BRINE3, 2, amount);
            data.set(3, Fluids.BRINE3, Fluids.BRINE4, 3, amount);
            data.set(4, Fluids.BRINE4, 4);
        }
    }

    protected int outputSlotNo(int no) {
        return no + this.slotDefinition.minOutputSlot;
    }

    public String getMachineName() {
        return BlockWaterworks.ModObject_blockWaterworks.unlocalisedName;
    }

    public void init() {
        super.init();
    }

    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.waterWorksRFinPerTick1.getInt(), 100000, Config.waterWorksRFusePerTick1.getInt()));
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.waterWorksRFinPerTick2.getInt(), 200000, Config.waterWorksRFusePerTick2.getInt()));
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor((ICapacitor)new BasicCapacitor(Config.waterWorksRFinPerTick3.getInt(), 500000, Config.waterWorksRFusePerTick3.getInt()));
            }
        }
    }

    protected float getLiquidFactorPerTask() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                return Config.waterWorksLiquidFactorperTask1.getFloat();
            }
            case ACTIVATED_CAPACITOR: {
                return Config.waterWorksLiquidFactorperTask2.getFloat();
            }
            case ENDER_CAPACITOR: {
                return Config.waterWorksLiquidFactorperTask3.getFloat();
            }
        }
        return 0.0f;
    }

    protected float getRfPerTask() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                return Config.waterWorksRFperTask1.getFloat();
            }
            case ACTIVATED_CAPACITOR: {
                return Config.waterWorksRFperTask2.getFloat();
            }
            case ENDER_CAPACITOR: {
                return Config.waterWorksRFperTask3.getFloat();
            }
        }
        return 0.0f;
    }

    @Override
    public boolean hasTank(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return true;
    }

    @Override
    public Fluid getTankFluid(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        switch (tankSlot) {
            case FRONT_LEFT: {
                return this.inputTank.getFluidAmount() > 0 ? this.inputTank.getFluid().getFluid() : null;
            }
            case BACK_LEFT: {
                return (double)this.inputTank.getFilledRatio() > 0.34 ? this.inputTank.getFluid().getFluid() : null;
            }
            case BACK_RIGHT: {
                return (double)this.inputTank.getFilledRatio() > 0.67 ? this.inputTank.getFluid().getFluid() : null;
            }
            case FRONT_RIGHT: {
                return this.outputTank.getFluidAmount() > 0 ? this.outputTank.getFluid().getFluid() : null;
            }
        }
        return null;
    }

    @Override
    public boolean hasController() {
        return true;
    }

    @Override
    public boolean renderSlot(@Nonnull IFrameworkMachine.TankSlot tankSlot) {
        return tankSlot != IFrameworkMachine.TankSlot.FRONT_LEFT;
    }

    @Override
    public IIcon getSlotIcon(@Nonnull IFrameworkMachine.TankSlot tankSlot, int side) {
        return BlockWaterworks.blockWaterworks.getFilterTexture();
    }

    @Override
    public String getControllerModelName() {
        return BlockWaterworks.blockWaterworks.getControllerModelName();
    }

    @Nullable
    public FluidTank getInputTank(@Nullable FluidStack forFluidType) {
        if (forFluidType != null && this.inputTank.canFill(forFluidType.getFluid())) {
            return this.inputTank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.outputTank};
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    public int fill(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doFill) {
        if (from == null || this.isSideDisabled(from.ordinal()) || resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int res = this.inputTank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    @Nullable
    public FluidStack drain(@Nullable ForgeDirection from, @Nullable FluidStack resource, boolean doDrain) {
        if (from == null || this.isSideDisabled(from.ordinal()) || this.outputTank.getFluid() == null || resource == null || !resource.isFluidEqual(this.outputTank.getFluid())) {
            return null;
        }
        FluidStack res = this.outputTank.drain(resource.amount, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tanksDirty = true;
        }
        return res;
    }

    @Nullable
    public FluidStack drain(@Nullable ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == null || this.isSideDisabled(from.ordinal())) {
            return null;
        }
        FluidStack res = this.outputTank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tanksDirty = true;
        }
        return res;
    }

    public boolean canFill(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        if (from == null || this.isSideDisabled(from.ordinal()) || fluid == null || !this.inputTank.canFill(fluid)) {
            return false;
        }
        if (this.outputTank.getFluidAmount() == 0) {
            return data.containsInputLiquid(fluid);
        }
        return data.isMatchingInputForOutput(fluid, this.outputTank.getFluid().getFluid());
    }

    public boolean canDrain(@Nullable ForgeDirection from, @Nullable Fluid fluid) {
        if (from == null || this.isSideDisabled(from.ordinal())) {
            return false;
        }
        return this.outputTank.canDrainFluidType(fluid);
    }

    @Nonnull
    public FluidTankInfo[] getTankInfo(@Nullable ForgeDirection from) {
        if (from == null || this.isSideDisabled(from.ordinal())) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.inputTank.getInfo(), this.outputTank.getInfo()};
    }

    protected boolean doPush(@Nullable ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (dir == null || this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.outputTank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && target.canFill(dir.getOpposite(), this.outputTank.getFluid().getFluid())) {
            FluidStack push = this.outputTank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.getOpposite(), push, true);
            if (filled > 0) {
                this.outputTank.drain(filled, true);
                this.tanksDirty = true;
                return res;
            }
        }
        return res;
    }

    protected boolean doPull(@Nullable ForgeDirection dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (dir == null || this.isSideDisabled(dir.ordinal())) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (!this.inputTank.isFull() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null) {
            if (this.inputTank.getFluidAmount() > 0) {
                FluidStack canPull = this.inputTank.getFluid().copy();
                canPull.amount = this.inputTank.getCapacity() - this.inputTank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.inputTank.fill(drained, true);
                    this.tanksDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.getOpposite());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.getOpposite(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.inputTank.fill(drained, true);
                        this.tanksDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    protected boolean hasInputStacks() {
        boolean result = (float)this.inputTank.getFluidAmount() >= 1000.0f * this.getLiquidFactorPerTask();
        return result;
    }

    @Nonnull
    protected IMachineRecipe getNextRecipe() {
        return DummyRecipe.instance;
    }

    protected boolean canInsertResult(float chance, @Nullable IMachineRecipe nextRecipe) {
        if ((float)this.inputTank.getFluidAmount() < 1000.0f * this.getLiquidFactorPerTask()) {
            return false;
        }
        this.progress_in = this.inputTank.getFluid().getFluid();
        int level = data.getLevelFromInput(this.inputTank.getFluid().getFluid());
        if (level < 0) {
            return false;
        }
        if ((float)this.outputTank.getAvailableSpace() < (float)data.getOutputAmountFromInput(this.progress_in) * this.getLiquidFactorPerTask()) {
            return false;
        }
        if (!data.isMatchingOutputForInput(this.progress_in, this.outputTank.getFluidAmount() > 0 ? this.outputTank.getFluid().getFluid() : null)) {
            return false;
        }
        this.progress_out = data.getOutputFromInput(this.progress_in);
        return true;
    }

    @Nonnull
    protected IPoweredTask createTask(@Nullable IMachineRecipe nextRecipe, float chance) {
        return new TaskWaterworks(this.getRfPerTask(), this.getLiquidFactorPerTask());
    }

    @Nullable
    protected IPoweredTask createTask(NBTTagCompound taskTagCompound) {
        return TaskWaterworks.readFromNBT(taskTagCompound);
    }

    protected void drainInputFluid(@Nullable MachineRecipeInput fluid) {
        this.inputTank.drain((int)(((TaskWaterworks)this.currentTask).getLiquidInFactor() * 1000.0f), true);
    }

    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (this.currentTask == null || !this.hasPower() && !EnderIOAddons.mode24) {
            return false;
        }
        if (redstoneChecksPassed && !this.currentTask.isComplete()) {
            this.usePower();
        }
        if (this.currentTask.isComplete()) {
            this.taskComplete();
            return true;
        }
        if (this.tanksDirty) {
            this.tanksDirty = false;
            return true;
        }
        return false;
    }

    protected boolean isMachineItemValidForSlot(int i, @Nullable ItemStack itemstack) {
        return this.insertingIntoSelf && i >= this.slotDefinition.minOutputSlot && i <= this.slotDefinition.maxOutputSlot;
    }

    protected void taskComplete() {
        if (this.currentTask != null) {
            int level = data.getLevelFromInput(this.progress_in);
            this.insertingIntoSelf = true;
            Engine.CreationResult creationResult = engine.createItems(this.stash, level, (IInventory)this, this.slotDefinition.minOutputSlot, this.slotDefinition.maxOutputSlot, true);
            this.insertingIntoSelf = false;
            if (creationResult == Engine.CreationResult.OK || creationResult == Engine.CreationResult.NO_INPUTS) {
                this.stashProgress = (float)engine.getLastProgress();
                float factor = ((TaskWaterworks)this.currentTask).getLiquidInFactor();
                int amount = (int)((float)data.getOutputAmountFromInput(this.progress_in) * factor);
                if (amount > 0) {
                    Fluid progress_out2 = this.progress_out;
                    if (progress_out2 == null) {
                        progress_out2 = data.getOutputFromInput(this.progress_in);
                    }
                    if (progress_out2 != null && this.outputTank.getFluidAmount() == 0) {
                        this.outputTank.setFluid(new FluidStack(progress_out2, amount));
                    } else if (progress_out2 == null || this.outputTank.getFluid().getFluidID() == progress_out2.getID()) {
                        this.outputTank.addFluidAmount(amount);
                    } else {
                        return;
                    }
                }
                engine.processWater(this.stash, level, factor);
                this.currentTask = null;
                this.progress_out = null;
                this.progress_in = null;
                this.lastProgressScaled = 0;
                this.func_70296_d();
            } else if (creationResult == Engine.CreationResult.LOW_OUTPUTS) {
                this.func_70296_d();
            }
        }
    }

    protected void sendTaskProgressPacket() {
        PacketHandler.sendToAllAround((IMessage)new PacketWaterworksProgress(this), (TileEntity)this);
        this.ticksSinceLastProgressUpdate = 0;
    }
}

