/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.tcom;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.machine.framework.GroupObjectWithIcon;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import info.loenwind.enderioaddons.machine.framework.RendererFrameworkMachine;
import info.loenwind.enderioaddons.machine.tcom.BlockTcom;
import info.loenwind.enderioaddons.machine.tcom.GuiTcom;
import info.loenwind.enderioaddons.machine.tcom.TileTcom;
import info.loenwind.enderioaddons.machine.tcom.engine.EngineTcom;
import info.loenwind.enderioaddons.machine.tcom.engine.Mats;
import info.loenwind.enderioaddons.render.FaceRenderer;
import info.loenwind.enderioaddons.render.OverlayRenderer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RendererTcom
implements ISimpleBlockRenderingHandler {
    private static final VertexRotationFacing xform = new VertexRotationFacing(ForgeDirection.SOUTH);
    @Nonnull
    private final RendererFrameworkMachine frameRenderer;
    private boolean leather_or_string_has_rendered = false;
    private boolean wood_or_sticks_has_rendered = false;
    private static final double px = 0.0625;

    public RendererTcom(@Nonnull RendererFrameworkMachine frameRenderer) {
        this.frameRenderer = frameRenderer;
        GroupObjectWithIcon controllerPassive = new GroupObjectWithIcon(frameRenderer.getControllerPart(4), BlockTcom.blockTcom);
        frameRenderer.registerController(BlockTcom.blockTcom.getControllerModelName(), controllerPassive, controllerPassive);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.frameRenderer.renderInventoryBlock(block, metadata, modelId, renderer);
    }

    public void renderTileEntityAt(TileTcom te) {
        if (te != null) {
            xform.setRotation(te.getFacingDir());
            EngineTcom e = te.engine;
            Map<ItemStack, Float> materials = e.getMaterials();
            List<ItemStack> list = GuiTcom.sortMaterialsList(materials);
            int idx = 0;
            this.leather_or_string_has_rendered = false;
            this.wood_or_sticks_has_rendered = false;
            for (int lower = 0; lower <= 1; ++lower) {
                for (IFrameworkMachine.TankSlot tankSlot : IFrameworkMachine.TankSlot.values()) {
                    if ((tankSlot = NullHelper.notnullJ(tankSlot, "enum.values()[i]")) == IFrameworkMachine.TankSlot.FRONT_RIGHT && lower == 1) {
                        this.renderEnchantments(te, tankSlot, lower == 1);
                        continue;
                    }
                    if (tankSlot == IFrameworkMachine.TankSlot.FRONT_LEFT && lower == 0) continue;
                    while (idx < list.size() && !this.renderTrayContents(te, tankSlot, lower == 1, Mats.getMat(list.get(idx++)))) {
                    }
                }
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileTcom tileTcom;
        if (OverlayRenderer.renderOverlays(world, x, y, z, null, renderer.field_147840_d, BlockTcom.blockTcom, (TileTcom)null, true)) {
            return true;
        }
        TileEntity te = world != null ? world.func_147438_o(x, y, z) : null;
        IFrameworkMachine frameworkMachine = te instanceof IFrameworkMachine ? (IFrameworkMachine)te : null;
        TileTcom tileTcom2 = tileTcom = te instanceof TileTcom ? (TileTcom)te : null;
        if (frameworkMachine != null && tileTcom != null) {
            xform.setRotation(tileTcom.getFacingDir());
            FaceRenderer.setLightingReference(world, (Block)BlockTcom.blockTcom, x, y, z);
            Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
            for (IFrameworkMachine.TankSlot tankSlot : IFrameworkMachine.TankSlot.values()) {
                tankSlot = NullHelper.notnullJ(tankSlot, "enum.values()[i]");
                this.renderTray(tankSlot, true);
                this.renderTray(tankSlot, false);
            }
            Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
            FaceRenderer.clearLightingReference();
        }
        return this.frameRenderer.renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockTcom.blockTcom.func_149645_b();
    }

    private void renderTray(@Nonnull IFrameworkMachine.TankSlot tankSlot, boolean lower) {
        if (tankSlot == IFrameworkMachine.TankSlot.FRONT_LEFT && !lower || tankSlot == IFrameworkMachine.TankSlot.FRONT_RIGHT && lower) {
            return;
        }
        IIcon icon_side = BlockTcom.blockTcom.func_149691_a(ForgeDirection.SOUTH.ordinal(), 0);
        IIcon icon_bottom = BlockTcom.blockTcom.func_149691_a(ForgeDirection.DOWN.ordinal(), 0);
        IIcon icon_top = BlockTcom.blockTcom.func_149691_a(ForgeDirection.UP.ordinal(), 0);
        int[] pos = RendererFrameworkMachine.translateToSlotPosition(ForgeDirection.SOUTH, tankSlot);
        IIcon[] icons1 = new IIcon[]{null, null, icon_side, icon_side, icon_side, icon_side};
        BoundingBox bb1 = RendererTcom.makePartialBBofSlot(0, 0, 0, 16, 16, 16, pos);
        BoundingBox bb2 = RendererTcom.makePartialBBofSlot(1, 0, 0, 15, 16, 16, pos);
        BoundingBox bb3 = RendererTcom.makePartialBBofSlot(0, 0, 1, 16, 16, 15, pos);
        BoundingBox bb4 = RendererTcom.makePartialBBofSlot(0, 0, 0, 16, 7, 16, pos);
        BoundingBox bb5 = RendererTcom.makePartialBBofSlot(0, 1, 0, 16, 16, 16, pos);
        if (lower) {
            bb1 = bb1.translate(0.0f, -0.5f, 0.0f);
            bb2 = bb2.translate(0.0f, -0.5f, 0.0f);
            bb3 = bb3.translate(0.0f, -0.5f, 0.0f);
            bb4 = bb4.translate(0.0f, -0.5f, 0.0f);
            bb5 = bb5.translate(0.0f, -0.5f, 0.0f);
        }
        FaceRenderer.renderCube(bb1, icons1, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.UP, icon_top, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb5, ForgeDirection.DOWN, icon_bottom, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb2, ForgeDirection.EAST, icon_side, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb2, ForgeDirection.WEST, icon_side, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb3, ForgeDirection.NORTH, icon_side, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb3, ForgeDirection.SOUTH, icon_side, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
    }

    public static void renderStandaloneTray() {
        IIcon icon_side = BlockTcom.blockTcom.func_149691_a(ForgeDirection.SOUTH.ordinal(), 0);
        IIcon icon_bottom = BlockTcom.blockTcom.func_149691_a(ForgeDirection.DOWN.ordinal(), 0);
        IIcon icon_top = BlockTcom.blockTcom.func_149691_a(ForgeDirection.UP.ordinal(), 0);
        IIcon[] icons1 = new IIcon[]{icon_bottom, null, icon_side, icon_side, icon_side, icon_side};
        BoundingBox bb1 = RendererTcom.makePartialBB(0, 0, 0, 16, 16, 16);
        BoundingBox bb2 = RendererTcom.makePartialBB(1, 0, 0, 15, 16, 16);
        BoundingBox bb3 = RendererTcom.makePartialBB(0, 0, 1, 16, 16, 15);
        BoundingBox bb4 = RendererTcom.makePartialBB(0, 0, 0, 16, 7, 16);
        BoundingBox bb5 = RendererTcom.makePartialBB(0, 1, 0, 16, 16, 16);
        FaceRenderer.renderCube(bb1, icons1, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb4, ForgeDirection.UP, icon_top, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(bb5, ForgeDirection.DOWN, icon_bottom, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb2, ForgeDirection.EAST, icon_side, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb2, ForgeDirection.WEST, icon_side, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb3, ForgeDirection.NORTH, icon_side, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderSingleFace(bb3, ForgeDirection.SOUTH, icon_side, 0.0, 16.0, 0.0, 16.0, null, FaceRenderer.stdBrightnessInside, true);
    }

    public static void renderStandaloneEnchantmentPylon(boolean withTank) {
        RenderUtil.bindTexture((String)(EnderIOAddons.DOMAIN + ":textures/blocks/enchantmentbase.png"));
        BoundingBox bb2 = RendererTcom.makePartialBB(2, 0, 2, 14, 16, 14);
        BoundingBox bb3 = RendererTcom.makePartialBB(3, 0, 3, 13, 16, 13).scale(1.0, 0.96, 1.0);
        float minU = (float)(EnderIO.proxy.getTickCount() % 24L) / 48.0f;
        float maxU = minU + 0.5f;
        float minV = 0.5f;
        float maxV = 1.0f;
        FaceRenderer.setupVertices(bb2, null);
        FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, true);
        FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, true);
        FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.WEST, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, true);
        FaceRenderer.renderSingleFace(ForgeDirection.WEST, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.EAST, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, true);
        FaceRenderer.renderSingleFace(ForgeDirection.EAST, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        minU = 0.0f;
        maxU = 0.41666666f;
        minV = 0.0f;
        maxV = 0.5f;
        FaceRenderer.setupVertices(bb3, null);
        FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.WEST, maxU, minU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.EAST, maxU, minU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        minU = 0.0f;
        maxU = 0.20833333f;
        minV = 0.0f;
        maxV = 0.15625f;
        FaceRenderer.renderSingleFace(ForgeDirection.UP, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderSingleFace(ForgeDirection.DOWN, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
        if (withTank) {
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            RenderUtil.bindTexture((String)(EnderIOAddons.DOMAIN + ":textures/blocks/frameworkModel.png"));
            minU = 0.71875f;
            maxU = minU + 0.09375f;
            minV = 0.734375f;
            maxV = minV + 0.09375f;
            FaceRenderer.setupVertices(BoundingBox.UNIT_CUBE, null);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                FaceRenderer.renderSingleFace(dir, minU, maxU, minV, maxV, null, FaceRenderer.stdBrightness, false);
            }
        }
    }

    private boolean renderTrayItems(@Nonnull TileTcom te, @Nonnull IFrameworkMachine.TankSlot tankSlot, boolean lower) {
        if (te.engine.getAmount(Mats.LEATHER) < 0.01f && te.engine.getAmount(Mats.STRING) < 0.01f) {
            return false;
        }
        int[] pos = RendererFrameworkMachine.translateToSlotPosition(ForgeDirection.SOUTH, tankSlot);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        RenderUtil.bindItemTexture();
        for (Mats mat : new Mats[]{Mats.LEATHER, Mats.STRING}) {
            IIcon icon = mat == Mats.LEATHER ? Items.field_151116_aA.func_77617_a(0) : Items.field_151007_F.func_77617_a(0);
            float rawAmount = te.engine.getAmount(mat) / 100.0f;
            int renderAmount = (int)(rawAmount * 8.0f);
            if (rawAmount > 0.0f && renderAmount < 1) {
                renderAmount = 1;
            } else if (renderAmount > 7) {
                renderAmount = 7;
            }
            for (int i = 0; i < renderAmount; ++i) {
                int offsetx = 6 + (i + mat.ordinal() & 1) * 4;
                int offsetz = 6 + ((i + mat.ordinal() & 2) >> 1) * 4;
                BoundingBox bbi = RendererTcom.makePartialBBofSlot(offsetx - 4, 0, offsetz - 4, offsetx + 4, i + 1, offsetz + 4, pos).translate(0.0f, 0.002f * (float)(mat == Mats.LEATHER ? 1 : 2), 0.0f);
                if (lower) {
                    bbi = bbi.translate(0.0f, -0.5f, 0.0f);
                }
                FaceRenderer.renderSingleFace(bbi, ForgeDirection.UP, icon, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        RenderUtil.bindBlockTexture();
        return true;
    }

    private boolean renderTrayContents(@Nonnull TileTcom te, @Nonnull IFrameworkMachine.TankSlot tankSlot, boolean lower, Mats mat) {
        switch (mat) {
            case WOOD: 
            case STICK: {
                if (this.wood_or_sticks_has_rendered) {
                    return false;
                }
                this.wood_or_sticks_has_rendered = true;
                break;
            }
            case LEATHER: 
            case STRING: {
                if (this.leather_or_string_has_rendered) {
                    return false;
                }
                this.leather_or_string_has_rendered = true;
                return this.renderTrayItems(te, tankSlot, lower);
            }
        }
        Block toRender = Block.func_149634_a((Item)mat.getBlockStack().func_77973_b());
        int[] pos = RendererFrameworkMachine.translateToSlotPosition(ForgeDirection.SOUTH, tankSlot);
        EngineTcom e = te.engine;
        IIcon[] icons = RenderUtil.getBlockTextures((Block)toRender, (int)mat.getItemStack().func_77960_j());
        float rawAmount = e.getAmount(mat) / 100.0f;
        if (mat == Mats.WOOD) {
            rawAmount += e.getAmount(Mats.STICK) / 100.0f / 2.0f;
        } else if (mat == Mats.STICK) {
            rawAmount = e.getAmount(Mats.WOOD) / 100.0f + rawAmount / 2.0f;
        }
        int renderAmount = (int)(rawAmount * 14.0f);
        if (rawAmount > 0.0f && renderAmount < 1) {
            renderAmount = 1;
        } else if (renderAmount > 14) {
            renderAmount = 14;
        }
        if (renderAmount > 0) {
            BoundingBox bb = RendererTcom.makePartialBBofSlot(1, 1, 1, 15, 1 + renderAmount, 15, pos);
            if (lower) {
                bb = bb.translate(0.0f, -0.5f, 0.0f);
            }
            FaceRenderer.renderSkirt(bb, icons, 0.0, 16.0, 0.0, (double)(2 + renderAmount), (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(bb, ForgeDirection.UP, icons, 0.0, 16.0, 0.0, 16.0, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            return true;
        }
        return false;
    }

    private void renderEnchantments(@Nonnull TileTcom te, @Nonnull IFrameworkMachine.TankSlot tankSlot, boolean lower) {
        int[] pos = RendererFrameworkMachine.translateToSlotPosition(ForgeDirection.SOUTH, tankSlot);
        EngineTcom e = te.engine;
        float rawAmount = e.getEnchantmentAmounts() / 100.0f;
        int renderAmount = (int)(rawAmount * 16.0f);
        if (rawAmount > 0.0f && renderAmount < 1) {
            renderAmount = 1;
        } else if (renderAmount > 16) {
            renderAmount = 16;
        }
        if (renderAmount > 0) {
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            RenderUtil.bindTexture((String)(EnderIOAddons.DOMAIN + ":textures/blocks/enchantments.png"));
            int renderAmount2 = renderAmount / 2;
            if (renderAmount == 0) {
                renderAmount = 1;
            }
            BoundingBox bb = RendererTcom.makePartialBBofSlot(0, 0, 0, 16, renderAmount2, 16, pos).scale(0.99, 1.0, 0.99);
            BoundingBox bb1 = RendererTcom.makePartialBBofSlot(1, 0, 1, 15, renderAmount, 15, pos);
            if (lower) {
                bb = bb.translate(0.0f, -0.5f, 0.0f);
                bb1 = bb1.translate(0.0f, -0.5f, 0.0f);
            }
            if (te.lastRenderTick != EnderIO.proxy.getTickCount()) {
                te.lastRenderTick = EnderIO.proxy.getTickCount();
                te.renderData[0] = te.renderData[0] + te.renderData[1];
                if (te.renderData[0] + 32 >= 320) {
                    te.renderData[0] = te.renderData[0] - 1;
                    te.renderData[1] = -1;
                } else if (te.renderData[0] <= -1) {
                    te.renderData[0] = te.renderData[0] + 1;
                    te.renderData[1] = 1;
                }
                te.renderData[2] = te.renderData[2] + (te.func_145831_w().field_73012_v.nextInt(5) - 2);
                if (te.renderData[2] + 32 >= 64) {
                    te.renderData[2] = 31;
                } else if (te.renderData[2] < 0) {
                    te.renderData[2] = 0;
                }
                te.renderData[3] = te.renderData[3] + te.renderData[1];
                if (te.renderData[3] < 0) {
                    te.renderData[3] = te.renderData[3] + 24;
                } else if (te.renderData[3] >= 24) {
                    te.renderData[3] = te.renderData[3] - 24;
                }
            }
            float minU = (float)te.renderData[2] / 64.0f;
            float maxU = (float)(te.renderData[2] + 32) / 64.0f;
            float minV = (float)te.renderData[0] / 320.0f;
            float maxV = (float)(te.renderData[0] + renderAmount * 2) / 320.0f;
            if (te.renderData[1] < 0) {
                float tmp = minV;
                minV = maxV;
                maxV = tmp;
            }
            FaceRenderer.setupVertices(bb1, (VertexTransform)xform);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.WEST, maxU, minU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.EAST, maxU, minU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.UP, 0.0f, 0.5f, 0.0f, 0.1f, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            if (te.renderData[1] < 0) {
                minV = (float)(te.renderData[0] + renderAmount2 * 2) / 320.0f;
            } else {
                maxV = (float)(te.renderData[0] + renderAmount2 * 2) / 320.0f;
            }
            FaceRenderer.setupVertices(bb, (VertexTransform)xform);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.WEST, maxU, minU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.EAST, maxU, minU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.UP, 0.0f, 0.5f, 0.0f, 0.1f, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        }
        if (renderAmount < 16) {
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            RenderUtil.bindTexture((String)(EnderIOAddons.DOMAIN + ":textures/blocks/enchantmentbase.png"));
            BoundingBox bb2 = RendererTcom.makePartialBBofSlot(2, 0, 2, 14, 16, 14, pos);
            BoundingBox bb3 = RendererTcom.makePartialBBofSlot(3, 0, 3, 13, 16, 13, pos);
            if (lower) {
                bb2 = bb2.translate(0.0f, -0.5f, 0.0f);
                bb3 = bb3.translate(0.0f, -0.5f, 0.0f);
            }
            float minU = (float)te.renderData[3] / 48.0f;
            float maxU = minU + 0.5f;
            float minV = 0.5f;
            float maxV = 1.0f;
            FaceRenderer.setupVertices(bb2, (VertexTransform)xform);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, true);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, true);
            FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.WEST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, true);
            FaceRenderer.renderSingleFace(ForgeDirection.WEST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.EAST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, true);
            FaceRenderer.renderSingleFace(ForgeDirection.EAST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            minU = 0.0f;
            maxU = 0.41666666f;
            minV = 0.0f;
            maxV = 0.5f;
            FaceRenderer.setupVertices(bb3, (VertexTransform)xform);
            FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.WEST, maxU, minU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
            FaceRenderer.renderSingleFace(ForgeDirection.EAST, maxU, minU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        RenderUtil.bindBlockTexture();
    }

    private static BoundingBox makePartialBBofSlot(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int[] pos) {
        BoundingBox bb = new BoundingBox(0.0625 * (double)minX, 0.0625 * (double)minY, 0.0625 * (double)minZ, 0.0625 * (double)maxX, 0.0625 * (double)maxY, 0.0625 * (double)maxZ);
        bb = RendererTcom.centerscale(bb, 0.375, 0.375, 0.375);
        bb = bb.translate((float)pos[0] * 4.0f / 16.0f, 0.25f, (float)pos[1] * 4.0f / 16.0f);
        return bb;
    }

    private static BoundingBox makePartialBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BoundingBox bb = new BoundingBox(0.0625 * (double)minX, 0.0625 * (double)minY, 0.0625 * (double)minZ, 0.0625 * (double)maxX, 0.0625 * (double)maxY, 0.0625 * (double)maxZ);
        return bb;
    }

    private static BoundingBox centerscale(BoundingBox bb, double x, double y, double z) {
        return new BoundingBox(((double)bb.minX - 0.5) * x + 0.5, ((double)bb.minY - 0.5) * y + 0.5, ((double)bb.minZ - 0.5) * z + 0.5, ((double)bb.maxX - 0.5) * x + 0.5, ((double)bb.maxY - 0.5) * y + 0.5, ((double)bb.maxZ - 0.5) * z + 0.5);
    }

    static {
        xform.setCenter(new Vector3d(0.5, 0.5, 0.5));
    }
}

