/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.tcom;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.gui.GuiButtonIoConfig;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.enderioaddons.EnderIOAddons;
import info.loenwind.enderioaddons.gui.GuiEIOABase;
import info.loenwind.enderioaddons.gui.InvisibleButton;
import info.loenwind.enderioaddons.gui.StdOutputSlot;
import info.loenwind.enderioaddons.gui.StdSlot;
import info.loenwind.enderioaddons.machine.tcom.ContainerTcom;
import info.loenwind.enderioaddons.machine.tcom.PacketTcomAction;
import info.loenwind.enderioaddons.machine.tcom.TileTcom;
import info.loenwind.enderioaddons.machine.tcom.engine.Mats;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiTcom
extends GuiEIOABase<TileTcom> {
    private static final int SCROLL_STEP = 19;
    private static final int SCROLL_ITEMS = 3;
    private static final int tabXOffset = -3;
    private static final int tabYOffset = 4;
    private static final int TAB_WIDTH = 24;
    private static final int TAB_HEIGHT = 24;
    protected int scrollPosition = 0;
    protected int scrollPositionOffset = 0;
    protected InvisibleButton plus;
    protected InvisibleButton minus;
    protected InvisibleButton tab_mats;
    protected InvisibleButton tab_enchant;
    protected int maxScrollItems = 1;
    protected boolean isEnchantScreen = false;
    protected final InvisibleButton[] getButtons = new InvisibleButton[3];
    protected final GuiToolTip[] enchTooltips = new GuiToolTip[3];
    protected final GuiToolTip inputTooltip;
    protected GuiButtonIoConfig configB2;
    protected static final int CONFIG_ID2 = 8962349;
    private String texture = null;
    private long lastUpdateRequest = 0L;
    private long lastTick = 0L;
    private int blockX0 = 0;
    private int blockX1 = 0;
    private int blockY0 = 0;
    private int blockY1 = 0;

    public GuiTcom(InventoryPlayer par1InventoryPlayer, @Nonnull TileTcom te) {
        super(te, (Container)new ContainerTcom(par1InventoryPlayer, te));
        this.plus = new InvisibleButton((GuiMachineBase)this, 1, 59, 8);
        this.minus = new InvisibleButton((GuiMachineBase)this, 2, 59, 70);
        this.tab_mats = new InvisibleButton((GuiMachineBase)this, 3, 0, 0);
        this.tab_enchant = new InvisibleButton((GuiMachineBase)this, 4, 0, 0);
        this.enchTooltips[0] = new GuiToolTip(new Rectangle(54, 14, 88, 18), (List)null);
        this.addToolTip(this.enchTooltips[0]);
        this.enchTooltips[1] = new GuiToolTip(new Rectangle(54, 33, 88, 18), (List)null);
        this.addToolTip(this.enchTooltips[1]);
        this.enchTooltips[2] = new GuiToolTip(new Rectangle(54, 52, 88, 18), (List)null);
        this.addToolTip(this.enchTooltips[2]);
        this.inputTooltip = new GuiToolTip(new Rectangle(19, 14, 18, 18), new String[]{EnderIOAddons.lang.localize("tcom.input.tooltip")});
        this.addToolTip(this.inputTooltip);
        this.getButtons[0] = new InvisibleButton((GuiMachineBase)this, 100, 124, 14);
        this.getButtons[1] = new InvisibleButton((GuiMachineBase)this, 101, 124, 33);
        this.getButtons[2] = new InvisibleButton((GuiMachineBase)this, 102, 124, 52);
        this.getButtons[2].field_146120_f = 18;
        this.getButtons[1].field_146120_f = 18;
        this.getButtons[0].field_146120_f = 18;
        this.getButtons[2].field_146121_g = 12;
        this.getButtons[1].field_146121_g = 12;
        this.getButtons[0].field_146121_g = 12;
        this.getButtons[0].setToolTip("");
        this.getButtons[1].setToolTip("");
        this.getButtons[2].setToolTip("");
        this.lastUpdateRequest = EnderIO.proxy.getTickCount() + 10L;
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTcomAction((TileTcom)this.getTileEntity()));
    }

    private void updateVisibility() {
        ((StdSlot)((ContainerTcom)this.field_147002_h).in0).enable(!this.isEnchantScreen);
        ((StdSlot)((ContainerTcom)this.field_147002_h).in1).enable(this.isEnchantScreen);
        ((StdOutputSlot)((ContainerTcom)this.field_147002_h).out0).enable(!this.isEnchantScreen);
        ((StdOutputSlot)((ContainerTcom)this.field_147002_h).out1).enable(this.isEnchantScreen);
        this.inputTooltip.setVisible(!this.isEnchantScreen);
        this.plus.field_146124_l = this.scrollPosition < this.maxScrollItems - 3;
        this.minus.field_146124_l = this.scrollPosition > 0;
        this.tab_mats.field_146124_l = this.isEnchantScreen;
        this.tab_enchant.field_146124_l = !this.isEnchantScreen;
        this.enchTooltips[0].setVisible(this.isEnchantScreen && this.maxScrollItems >= 1 && this.scrollPositionOffset == 0);
        this.enchTooltips[1].setVisible(this.isEnchantScreen && this.maxScrollItems >= 2 && this.scrollPositionOffset == 0);
        this.enchTooltips[2].setVisible(this.isEnchantScreen && this.maxScrollItems >= 3 && this.scrollPositionOffset == 0);
        this.getButtons[0].field_146124_l = this.maxScrollItems >= 1 && this.scrollPositionOffset == 0;
        this.getButtons[1].field_146124_l = this.maxScrollItems >= 2 && this.scrollPositionOffset == 0;
        this.getButtons[2].field_146124_l = this.maxScrollItems >= 3 && this.scrollPositionOffset == 0;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.configB.field_146125_m = false;
        this.redstoneButton.field_146125_m = false;
        for (IGuiOverlay overlay : this.overlays) {
            if (!(overlay instanceof GuiOverlayIoConfig)) continue;
            int x = this.getXSize() - 5 - 16;
            int y = 5;
            this.configB2 = new GuiButtonIoConfig((IGuiScreen)this, 8962349, x, y, (IIoConfigurable)this.getTileEntity(), (GuiOverlayIoConfig)overlay);
            this.configB2.onGuiInit();
            break;
        }
        this.plus.onGuiInit();
        this.minus.onGuiInit();
        this.tab_mats.onGuiInit();
        this.tab_enchant.onGuiInit();
        this.getButtons[0].onGuiInit();
        this.getButtons[1].onGuiInit();
        this.getButtons[2].onGuiInit();
        this.updateVisibility();
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn == this.plus) {
            if (this.scrollPosition >= this.maxScrollItems - 3) {
                return;
            }
            ++this.scrollPosition;
            this.scrollPositionOffset -= 19;
        } else if (btn == this.minus) {
            if (this.scrollPosition <= 0) {
                return;
            }
            --this.scrollPosition;
            this.scrollPositionOffset += 19;
        } else if (btn == this.tab_mats) {
            this.isEnchantScreen = false;
            this.scrollPositionOffset = 0;
            this.scrollPosition = 0;
        } else if (btn == this.tab_enchant) {
            this.isEnchantScreen = true;
            this.scrollPositionOffset = 0;
            this.scrollPosition = 0;
        } else if (btn.field_146127_k >= 100 && btn.field_146127_k <= 102) {
            if (this.isEnchantScreen) {
                Map<Enchantment, Float> enchantments = this.getCurrentEnchantmentList();
                List<Enchantment> keyList = GuiTcom.sortEnchantmentList(enchantments);
                Enchantment enchantment = keyList.get(btn.field_146127_k - 100 + this.scrollPosition);
                if (enchantment != null) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTcomAction((TileTcom)this.getTileEntity(), enchantment.field_77352_x));
                }
            } else {
                Map<ItemStack, Float> materials = ((TileTcom)this.getTileEntity()).engine.getMaterials();
                List<ItemStack> keyList = GuiTcom.sortMaterialsList(materials);
                Mats mat = Mats.getMat(keyList.get(btn.field_146127_k - 100 + this.scrollPosition));
                if (mat != null) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTcomAction((TileTcom)this.getTileEntity(), mat));
                }
            }
        } else {
            super.func_146284_a(btn);
        }
    }

    protected boolean showRecipeButton() {
        return false;
    }

    protected int getPowerX() {
        return 8;
    }

    protected int getPowerY() {
        return 10;
    }

    protected int getPowerWidth() {
        return 4;
    }

    protected int getPowerHeight() {
        return 66;
    }

    private void updateScrollPositionPre() {
        this.maxScrollItems = this.isEnchantScreen ? this.getCurrentEnchantmentList().size() : ((TileTcom)this.getTileEntity()).engine.getMaterials().size();
        if (this.scrollPosition > this.maxScrollItems - 3) {
            this.scrollPosition = this.maxScrollItems - 3;
            this.scrollPositionOffset = 0;
        }
        if (this.scrollPosition < 0) {
            this.scrollPosition = 0;
            this.scrollPositionOffset = 0;
        }
        this.updateVisibility();
    }

    private Map<Enchantment, Float> getCurrentEnchantmentList() {
        return ((TileTcom)this.getTileEntity()).engine.getEnchantments(((TileTcom)this.getTileEntity()).func_70301_a(((ContainerTcom)this.field_147002_h).in1.field_75222_d));
    }

    private void updateScrollPositionPost() {
        if (this.lastTick < EnderIO.proxy.getTickCount()) {
            this.lastTick = EnderIO.proxy.getTickCount();
            if (this.scrollPositionOffset < 0) {
                this.scrollPositionOffset += 1 - this.scrollPositionOffset / 9;
            } else if (this.scrollPositionOffset > 0) {
                this.scrollPositionOffset -= 1 + this.scrollPositionOffset / 9;
            }
        }
    }

    private void drawEnchants(int x, int y) {
        Map<Enchantment, Float> enchantments = this.getCurrentEnchantmentList();
        List<Enchantment> keyList = GuiTcom.sortEnchantmentList(enchantments);
        int line = 0;
        for (int i = 0; i < keyList.size(); ++i) {
            int y0 = y + 15 + (i - this.scrollPosition) * 19 - this.scrollPositionOffset;
            if (y0 < y || y0 >= y + 69) continue;
            Enchantment enchantment = keyList.get(i);
            this.drawEnchantmentText(enchantment, x, y0);
            Float amount = enchantments.get(enchantment);
            if (this.scrollPositionOffset > -2 && this.scrollPositionOffset < 2) {
                int x10 = amount.intValue() / 10;
                float m10 = amount.floatValue() - (float)(x10 * 10);
                if (x10 > 10) {
                    x10 = 10;
                    m10 = 10.0f;
                }
                int barAmount1 = (int)((float)x10 * 86.0f / 10.0f);
                int barAmount2 = (int)(m10 * 86.0f / 10.0f);
                this.drawProgressLine(x + 1, y0 + 14, barAmount1, 1);
                this.drawProgressLine(x + 1, y0 + 15, barAmount2, 1);
            }
            if (this.scrollPositionOffset != 0 || line >= this.enchTooltips.length) continue;
            String enchantmentName = EnderIOAddons.lang.localizeExact(enchantment.func_77320_a());
            this.getButtons[line].setToolTip(EnderIOAddons.lang.localize("tcom.get.ench.tooltip", new Object[]{enchantmentName}));
            this.enchTooltips[line++].setToolTipText(new String[]{EnderIOAddons.lang.localize("tcom.ench.tooltip", new Object[]{String.format("%.1f", amount), enchantmentName})});
        }
    }

    private static List<Enchantment> sortEnchantmentList(final Map<Enchantment, Float> enchantments) {
        ArrayList<Enchantment> keyList = new ArrayList<Enchantment>(enchantments.keySet());
        Collections.sort(keyList, new Comparator<Enchantment>(){

            @Override
            public int compare(Enchantment paramT1, Enchantment paramT2) {
                return Float.compare(((Float)enchantments.get(paramT2)).floatValue(), ((Float)enchantments.get(paramT1)).floatValue());
            }
        });
        return keyList;
    }

    private void drawEnchantmentText(Enchantment enchantment, int x, int y0) {
        String displayName = StatCollector.func_74838_a((String)enchantment.func_77320_a());
        while (this.field_146289_q.func_78256_a(displayName) > 68) {
            displayName = displayName.substring(0, displayName.length() - 1);
        }
        this.field_146289_q.func_78261_a(displayName, x + 1, y0 + 1, 0xFFFFFF);
    }

    private void drawItems(int x, int y) {
        Float amount;
        ItemStack itemStack;
        int y0;
        int i;
        Map<ItemStack, Float> materials = ((TileTcom)this.getTileEntity()).engine.getMaterials();
        List<ItemStack> keyList = GuiTcom.sortMaterialsList(materials);
        int line = 0;
        for (i = 0; i < keyList.size(); ++i) {
            y0 = y + 15 + (i - this.scrollPosition) * 19 - this.scrollPositionOffset;
            if (y0 < y || y0 >= y + 69) continue;
            itemStack = keyList.get(i);
            amount = materials.get(itemStack);
            this.drawMaterialLine(itemStack, x, y0);
            if (this.scrollPositionOffset > -2 && this.scrollPositionOffset < 2) {
                int barAmount = (int)((amount.floatValue() - (float)amount.intValue()) * 64.0f);
                this.drawProgressLine(x + 23, y0 + 14, barAmount, 2);
            }
            if (this.scrollPositionOffset != 0 || line >= this.getButtons.length) continue;
            this.getButtons[line++].setToolTip(EnderIOAddons.lang.localize("tcom.get.mat.tooltip", new Object[]{itemStack.func_82833_r()}));
        }
        if (this.scrollPositionOffset != 0) {
            RenderUtil.bindTexture((String)this.texture);
            this.drawScrollMask1(x, y);
        }
        for (i = 0; i < keyList.size(); ++i) {
            y0 = y + 15 + (i - this.scrollPosition) * 19 - this.scrollPositionOffset;
            if (y0 < y || y0 >= y + 69) continue;
            itemStack = keyList.get(i);
            amount = materials.get(itemStack);
            this.drawMaterialLineAmount(amount.intValue(), x, y0);
        }
    }

    public static List<ItemStack> sortMaterialsList(final Map<ItemStack, Float> materials) {
        ArrayList<ItemStack> keyList = new ArrayList<ItemStack>(materials.keySet());
        Collections.sort(keyList, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack paramT1, ItemStack paramT2) {
                return Float.compare(((Float)materials.get(paramT2)).floatValue(), ((Float)materials.get(paramT1)).floatValue());
            }
        });
        return keyList;
    }

    private void drawProgressLine(int x, int y, int length, int lines) {
        RenderUtil.bindTexture((String)this.texture);
        this.func_73729_b(x, y, 1, 250, length, lines);
    }

    private void drawMaterialLine(ItemStack itemStack, int x, int y0) {
        this.drawFakeItemsStart();
        this.drawFakeItemStack(x + 1, y0, itemStack);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3042);
        String displayName = itemStack.func_82833_r();
        while (this.field_146289_q.func_78256_a(displayName) > 46) {
            displayName = displayName.substring(0, displayName.length() - 1);
        }
        this.field_146289_q.func_78261_a(displayName, x + 23, y0 + 1, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        this.drawFakeItemsEnd();
    }

    private void drawMaterialLineAmount(int amount, int x, int y0) {
        if (amount > 0) {
            this.drawFakeItemsStart();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3042);
            String s1 = amount >= 1000 ? String.valueOf(amount / 1000) + "k" : String.valueOf(amount);
            this.field_146289_q.func_78261_a(s1, x + 20 - 2 - this.field_146289_q.func_78256_a(s1), y0 + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            this.drawFakeItemsEnd();
        }
    }

    private void drawArrows(int sx, int sy) {
        if (this.isEnchantScreen) {
            float progress = ((TileTcom)this.getTileEntity()).getWorkProgress_enchant();
            if (progress > 0.0f) {
                int length = (int)(progress * 16.0f);
                int sidelength = length >= 8 ? 24 : (int)(progress * 16.0f / 8.0f * 24.0f);
                RenderUtil.bindTexture((String)this.texture);
                this.func_73729_b(sx + 23, sy + 33, 200, 0, 8, length);
                this.func_73729_b(sx + 27 + (24 - sidelength), sy + 40, 208, 0, sidelength, 2);
            }
        } else {
            float progress = ((TileTcom)this.getTileEntity()).getWorkProgress_in();
            if (progress > 0.0f) {
                int length = (int)(progress * 13.0f);
                RenderUtil.bindTexture((String)this.texture);
                this.func_73729_b(sx + 38, sy + 18, 200, 0, length, 8);
            }
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.texture = EnderIOAddons.DOMAIN + (this.isEnchantScreen ? ":textures/gui/tcomEnch.png" : ":textures/gui/tcomMats.png");
        RenderUtil.bindTexture((String)this.texture);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawTabs(sx, sy);
        this.updateScrollPositionPre();
        if (this.isEnchantScreen) {
            this.drawEnchants(sx + 54, sy);
        } else {
            this.drawItems(sx + 54, sy);
        }
        RenderUtil.bindTexture((String)this.texture);
        if (this.scrollPositionOffset != 0) {
            this.drawScrollMask2(sx + 54, sy);
        }
        this.updateScrollPositionPost();
        this.drawArrows(sx, sy);
        super.func_146976_a(par1, par2, par3);
        if (EnderIO.proxy.getTickCount() > this.lastUpdateRequest) {
            this.lastUpdateRequest = EnderIO.proxy.getTickCount() + 10L;
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTcomAction((TileTcom)this.getTileEntity()));
        }
    }

    private void drawTabs(int sx, int sy) {
        int tabX = sx + this.field_146999_f + -3;
        int tabY = sy + 4;
        if (this.isEnchantScreen) {
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)tabX, (double)tabY, true);
            IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)tabX, (double)(tabY + 24), true);
        } else {
            IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)tabX, (double)tabY, true);
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)tabX, (double)(tabY + 24), true);
        }
        IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)(tabX + 5), (double)tabY, true);
        IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)(tabX + 5), (double)(tabY + 24), true);
        this.field_73735_i = 200.0f;
        GuiTcom.field_146296_j.field_77023_b = 200.0f;
        field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack(Blocks.field_150344_f), tabX + 4, tabY + 4);
        field_146296_j.renderItemIntoGUI(this.field_146289_q, this.field_146297_k.field_71446_o, new ItemStack((Item)Items.field_151134_bR), tabX + 4, tabY + 24 + 4, true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        this.field_73735_i = 0.0f;
        GuiTcom.field_146296_j.field_77023_b = 0.0f;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        this.tab_mats.field_146128_h = tabX + 4;
        this.tab_mats.field_146129_i = tabY + 4;
        this.tab_mats.field_146120_f = 16;
        this.tab_mats.field_146121_g = 16;
        this.tab_enchant.field_146128_h = tabX + 4;
        this.tab_enchant.field_146129_i = tabY + 24 + 4;
        this.tab_enchant.field_146120_f = 16;
        this.tab_enchant.field_146121_g = 16;
        this.blockX0 = tabX;
        this.blockX1 = tabX + 24 + 1;
        this.blockY0 = tabY;
        this.blockY1 = tabY + 48;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gc, int x, int y, int w, int h) {
        return x + w >= this.blockX0 && x <= this.blockX1 && y + h >= this.blockY0 && y <= this.blockY1;
    }

    private void drawScrollMask1(int sx, int sy) {
        RenderUtil.bindTexture((String)this.texture);
        GL11.glDisable((int)2929);
        this.func_73729_b(sx, sy, 88, 166, 88, 83);
        GL11.glEnable((int)2929);
    }

    private void drawScrollMask2(int sx, int sy) {
        RenderUtil.bindTexture((String)this.texture);
        GL11.glDisable((int)2929);
        this.func_73729_b(sx, sy, 0, 166, 88, 83);
        GL11.glEnable((int)2929);
    }
}

