/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.magcharger;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import info.loenwind.enderioaddons.common.Profiler;
import info.loenwind.enderioaddons.machine.magcharger.BlockMagCharger;
import info.loenwind.enderioaddons.machine.magcharger.TileMagCharger;
import info.loenwind.enderioaddons.render.FaceRenderer;
import info.loenwind.enderioaddons.render.OverlayRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RendererMagCharger
implements ISimpleBlockRenderingHandler {
    private static final double px = 0.0625;
    private static BoundingBox bb0 = BoundingBox.UNIT_CUBE;
    private static BoundingBox bbi = RendererMagCharger.makePartialBB(1, 0, 1, 15, 16, 15);
    private static BoundingBox bb1 = RendererMagCharger.makePartialBB(1, 5, 1, 15, 14, 15);
    private static BoundingBox bb2 = RendererMagCharger.makePartialBB(7, 5, 7, 9, 14, 9);
    private static BoundingBox bb3 = RendererMagCharger.makePartialBB(0, 7, 0, 16, 12, 16);
    private static final VertexRotationFacing xform = new VertexRotationFacing(ForgeDirection.SOUTH);

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (OverlayRenderer.renderOverlays(world, x, y, z, null, renderer.field_147840_d, BlockMagCharger.blockMagCharger, TileMagCharger.class, true)) {
            return true;
        }
        long id = Profiler.client.start();
        xform.setRotation(ForgeDirection.SOUTH);
        FaceRenderer.setLightingReference(world, (Block)BlockMagCharger.blockMagCharger, x, y, z);
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        IIcon[] icons = RendererMagCharger.getBlockTextures(world, x, y, z, 4);
        RendererMagCharger.renderBlock(icons);
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        FaceRenderer.clearLightingReference();
        Profiler.client.stop(id, "magcharger world");
        return true;
    }

    public static void renderBlock(Block block, int meta) {
        long id = Profiler.client.start();
        xform.setRotation(ForgeDirection.SOUTH);
        IIcon[] icons = RendererMagCharger.getBlockTextures(block, meta, 4);
        RendererMagCharger.renderBlock(icons);
        Profiler.client.stop(id, "magcharger item");
    }

    private static void renderBlock(IIcon[] icons) {
        IIcon[] icons2 = new IIcon[]{icons[6], icons[7], null, null, null, null};
        IIcon[] icons3 = new IIcon[]{icons[9], icons[9], null, null, null, null};
        FaceRenderer.renderCube(bb0, icons, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        FaceRenderer.renderCube(bb0, icons, (VertexTransform)xform, FaceRenderer.stdBrightness, true);
        FaceRenderer.renderSkirt(bbi, icons[3], (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderCube(bb1, icons2, (VertexTransform)xform, FaceRenderer.stdBrightnessInside, true);
        FaceRenderer.renderCube(bb3, icons3, (VertexTransform)xform, FaceRenderer.stdBrightness, true);
        FaceRenderer.setupVertices(bb2, (VertexTransform)xform);
        float minU = icons[8].func_94214_a(0.0);
        float maxU = icons[8].func_94214_a(2.0);
        float minV = icons[8].func_94206_g();
        float maxV = icons[8].func_94207_b(9.0);
        FaceRenderer.renderSingleFace(ForgeDirection.SOUTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = maxU;
        maxU = icons[8].func_94214_a(4.0);
        FaceRenderer.renderSingleFace(ForgeDirection.EAST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = maxU;
        maxU = icons[8].func_94214_a(6.0);
        FaceRenderer.renderSingleFace(ForgeDirection.NORTH, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
        minU = maxU;
        maxU = icons[8].func_94214_a(8.0);
        FaceRenderer.renderSingleFace(ForgeDirection.WEST, minU, maxU, minV, maxV, (VertexTransform)xform, FaceRenderer.stdBrightness, false);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockMagCharger.blockMagCharger.func_149645_b();
    }

    private static BoundingBox makePartialBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BoundingBox bb = new BoundingBox(0.0625 * (double)minX, 0.0625 * (double)minY, 0.0625 * (double)minZ, 0.0625 * (double)maxX, 0.0625 * (double)maxY, 0.0625 * (double)maxZ);
        return bb;
    }

    public static IIcon[] getBlockTextures(IBlockAccess world, int x, int y, int z, int extra) {
        Block block = world.func_147439_a(x, y, z);
        IIcon[] icons = new IIcon[6 + extra];
        for (int i = 0; i < 6 + extra; ++i) {
            icons[i] = block.func_149673_e(world, x, y, z, i);
        }
        return icons;
    }

    public static IIcon[] getBlockTextures(Block block, int meta, int extra) {
        IIcon[] icons = new IIcon[6 + extra];
        for (int i = 0; i < 6 + extra; ++i) {
            icons[i] = block.func_149691_a(i, meta);
        }
        return icons;
    }

    static {
        xform.setCenter(new Vector3d(0.5, 0.5, 0.5));
    }
}

