/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.framework;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.AbstractMachineEntity;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TESRFrameworkMachine
extends TileEntitySpecialRenderer {
    private static final float EPSILON = 0.01f;
    @Nonnull
    private static final int[][] direction = new int[][]{{1, -1, 1}, {1, -1, -1}, {-1, -1, -1}, {-1, -1, 1}};
    @Nonnull
    static final int[][] rotation = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 3, 0}, {3, 0, 1, 2}, {2, 3, 0, 1}, {0, 1, 2, 3}};

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTick) {
        if (te instanceof AbstractMachineEntity && te instanceof IFrameworkMachine) {
            TESRFrameworkMachine.renderTankPass(te, x, y, z, false);
            TESRFrameworkMachine.renderTankPass(te, x, y, z, true);
        }
    }

    private static void renderTankPass(@Nonnull TileEntity te, double x, double y, double z, boolean waterPass) {
        short facing = ((AbstractMachineEntity)te).facing;
        for (IFrameworkMachine.TankSlot tankSlot : IFrameworkMachine.TankSlot.values()) {
            Fluid fluid;
            if (!((IFrameworkMachine)te).hasTank(tankSlot = NullHelper.notnullJ(tankSlot, "enum.values()[i]")) || (fluid = ((IFrameworkMachine)te).getTankFluid(tankSlot)) == null || fluid == FluidRegistry.WATER != waterPass) continue;
            int[] r = direction[rotation[facing][tankSlot.ordinal()]];
            TESRFrameworkMachine.renderTankFluid((float)x, (float)y, (float)z, r[0], r[1], r[2], 6.0f, 6.0f, 6.0f, fluid.getStillIcon());
        }
    }

    public static void renderTankFluid(float x, float y, float z, float xOffset, float yOffset, float zOffset, float xSize, float ySize, float zSize, IIcon icon) {
        float xScale = xSize - 0.02f;
        float yScale = ySize - 0.02f;
        float zScale = zSize - 0.02f;
        BoundingBox bb = BoundingBox.UNIT_CUBE.scale(xScale / 16.0f, yScale / 16.0f, zScale / 16.0f);
        float xPos = (xSize / 2.0f + 1.0f) * xOffset;
        float yPos = (ySize / 2.0f + 1.0f) * yOffset;
        float zPos = (zSize / 2.0f + 1.0f) * zOffset;
        bb = bb.translate(xPos / 16.0f, yPos / 16.0f, zPos / 16.0f);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtil.bindBlockTexture();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78372_c(x, y, z);
        CubeRenderer.render((BoundingBox)bb, (IIcon)icon);
        Tessellator.field_78398_a.func_78372_c(-x, -y, -z);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopAttrib();
    }
}

