/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.framework;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.machine.AbstractMachineEntity;
import info.loenwind.enderioaddons.common.NullHelper;
import info.loenwind.enderioaddons.machine.framework.AbstractTileFramework;
import info.loenwind.enderioaddons.machine.framework.IFrameworkBlock;
import info.loenwind.enderioaddons.machine.framework.IFrameworkMachine;
import info.loenwind.enderioaddons.machine.framework.TechneMachineRenderer;
import info.loenwind.enderioaddons.machine.part.MachinePart;
import info.loenwind.enderioaddons.render.FaceRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.common.util.ForgeDirection;

public class RendererFrameworkMachine
extends TechneMachineRenderer<AbstractTileFramework> {
    @Nonnull
    private Map<String, GroupObject> controller = new HashMap<String, GroupObject>();
    @Nonnull
    private GroupObject[] tanks = new GroupObject[]{null, null, null, null};
    @Nonnull
    private GroupObject[] valves = new GroupObject[]{null, null, null, null};
    @Nonnull
    private GroupObject[] stems = new GroupObject[]{null, null};
    @Nonnull
    private GroupObject[] contr = new GroupObject[]{null, null, null, null, null, null, null, null, null, null};
    @Nonnull
    private static final int[][] positions = new int[][]{{-1, 1}, {1, 1}, {1, -1}, {-1, -1}};

    public RendererFrameworkMachine() {
        super(-1, "models/framework");
        int i;
        for (i = 1; i <= 4; ++i) {
            this.tanks[i - 1] = (GroupObject)this.model.remove("tank" + i);
            this.valves[i - 1] = (GroupObject)this.model.remove("Valve" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.stems[i - 1] = (GroupObject)this.model.remove("ValveStem" + i);
        }
        for (i = 1; i <= 10; ++i) {
            this.contr[i - 1] = (GroupObject)this.model.remove("Controller" + i);
        }
    }

    @Nullable
    public GroupObject extractModelPart(@Nonnull String name) {
        return (GroupObject)this.model.remove(name);
    }

    @Nullable
    public GroupObject getControllerPart(int id) {
        return this.contr[id - 1];
    }

    public void registerController(@Nonnull String name, @Nonnull GroupObject active, @Nonnull GroupObject inactive) {
        this.controller.put(name, inactive);
        this.controller.put(name + "Active", active);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        AbstractMachineEntity machineEntity;
        TileEntity te = world != null ? world.func_147438_o(x, y, z) : null;
        IFrameworkMachine frameworkMachine = te instanceof IFrameworkMachine ? (IFrameworkMachine)te : null;
        AbstractMachineEntity abstractMachineEntity = machineEntity = te instanceof AbstractMachineEntity ? (AbstractMachineEntity)te : null;
        if (frameworkMachine != null && machineEntity != null) {
            for (IFrameworkMachine.TankSlot tankSlot : IFrameworkMachine.TankSlot.values()) {
                if (!frameworkMachine.renderSlot(tankSlot = NullHelper.notnullJ(tankSlot, "enum.values()[i]"))) continue;
                RendererFrameworkMachine.renderSubBlock(x, y, z, machineEntity, tankSlot);
            }
        }
        return super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    private static void renderSubBlock(int x, int y, int z, @Nonnull AbstractMachineEntity te, @Nonnull IFrameworkMachine.TankSlot tankSlot) {
        BoundingBox bb = BoundingBox.UNIT_CUBE;
        int[] pos = RendererFrameworkMachine.translateToSlotPosition(NullHelper.notnull(te.getFacingDir(), "Internal state error: Block is not facing any direction"), tankSlot);
        bb = bb.translate((float)pos[0] * 4.0f / 16.0f, 0.25f, (float)pos[1] * 4.0f / 16.0f);
        bb = bb.scale(0.375, 0.375, 0.375);
        bb = bb.translate((float)x, (float)y, (float)z);
        IIcon[] icons = RendererFrameworkMachine.getBlockTextures(te, tankSlot);
        CubeRenderer.render((BoundingBox)bb, (IIcon[])icons, null, (float[])FaceRenderer.stdBrightness);
    }

    private static ForgeDirection turn(@Nonnull ForgeDirection dir, @Nonnull IFrameworkMachine.TankSlot tankSlot) {
        if (tankSlot == IFrameworkMachine.TankSlot.BACK_RIGHT) {
            return dir.getRotation(ForgeDirection.DOWN);
        }
        if (tankSlot == IFrameworkMachine.TankSlot.BACK_LEFT) {
            return dir.getOpposite();
        }
        if (tankSlot == IFrameworkMachine.TankSlot.FRONT_LEFT) {
            return dir.getRotation(ForgeDirection.UP);
        }
        return dir;
    }

    public static int[] translateToSlotPosition(@Nonnull ForgeDirection dir, @Nonnull IFrameworkMachine.TankSlot tankSlot) {
        switch (dir) {
            case NORTH: {
                return positions[2 + tankSlot.ordinal() & 3];
            }
            case SOUTH: {
                return positions[0 + tankSlot.ordinal() & 3];
            }
            case WEST: {
                return positions[3 + tankSlot.ordinal() & 3];
            }
            case EAST: {
                return positions[1 + tankSlot.ordinal() & 3];
            }
        }
        return positions[0];
    }

    public static IIcon[] getBlockTextures(@Nonnull AbstractMachineEntity te, @Nonnull IFrameworkMachine.TankSlot tankSlot) {
        IFrameworkMachine fm = (IFrameworkMachine)te;
        int facing = RendererFrameworkMachine.turn(NullHelper.notnull(te.getFacingDir(), "Internal state error: Block is not facing any direction"), tankSlot).ordinal();
        IIcon[] icons = new IIcon[6];
        int i = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            icons[i++] = te.isActive() ? fm.getSlotIcon(tankSlot, ClientProxy.sideAndFacingToSpriteOffset[dir.ordinal()][facing] + 6) : fm.getSlotIcon(tankSlot, ClientProxy.sideAndFacingToSpriteOffset[dir.ordinal()][facing]);
        }
        return icons;
    }

    protected Collection<GroupObject> getModel(Block block, int metadata) {
        String controllerName;
        ArrayList<GroupObject> result = new ArrayList<GroupObject>();
        if (this.renderFrameInItem(block, metadata)) {
            result.addAll(super.getModel(block, metadata));
        }
        if ((controllerName = this.getControllerInItemName(block, metadata)) != null) {
            result.add(this.controller.get(controllerName + "Active"));
        }
        if (this.renderAllTanksInItem(block, metadata)) {
            for (GroupObject groupObject : this.tanks) {
                result.add(groupObject);
            }
        } else if (this.renderOneTankInItem(block, metadata)) {
            result.add(this.tanks[IFrameworkMachine.TankSlot.FRONT_LEFT.ordinal()]);
        }
        return result;
    }

    protected Collection<GroupObject> getModel(IBlockAccess world, int x, int y, int z) {
        AbstractMachineEntity machineEntity;
        ArrayList<GroupObject> result = new ArrayList<GroupObject>(super.getModel(world, x, y, z));
        TileEntity te = world != null ? world.func_147438_o(x, y, z) : null;
        IFrameworkMachine frameworkMachine = te instanceof IFrameworkMachine ? (IFrameworkMachine)te : null;
        AbstractMachineEntity abstractMachineEntity = machineEntity = te instanceof AbstractMachineEntity ? (AbstractMachineEntity)te : null;
        if (frameworkMachine != null && machineEntity != null) {
            if (frameworkMachine.hasController()) {
                if (machineEntity.isActive()) {
                    result.add(this.controller.get(frameworkMachine.getControllerModelName() + "Active"));
                } else {
                    result.add(this.controller.get(frameworkMachine.getControllerModelName()));
                }
            }
            boolean stem1 = false;
            boolean stem2 = false;
            block4: for (IFrameworkMachine.TankSlot tankSlot : IFrameworkMachine.TankSlot.values()) {
                if (!frameworkMachine.hasTank(tankSlot = NullHelper.notnullJ(tankSlot, "enum.values()[i]"))) continue;
                int i = tankSlot.ordinal();
                result.add(this.tanks[i]);
                result.add(this.valves[i]);
                switch (tankSlot) {
                    case FRONT_LEFT: 
                    case BACK_LEFT: {
                        stem1 = true;
                        continue block4;
                    }
                    case FRONT_RIGHT: 
                    case BACK_RIGHT: {
                        stem2 = true;
                    }
                }
            }
            if (stem1) {
                result.add(this.stems[0]);
            }
            if (stem2) {
                result.add(this.stems[1]);
            }
        }
        return result;
    }

    protected boolean renderFrameInItem(@Nullable Block block, int metadata) {
        if ((metadata & 0x10) == 16) {
            return MachinePart.values()[metadata & 0xF].hasFrame;
        }
        return true;
    }

    protected String getControllerInItemName(@Nullable Block block, int metadata) {
        if ((metadata & 0x10) == 16) {
            return MachinePart.values()[metadata & 0xF].getControllerModelName();
        }
        if (block instanceof IFrameworkBlock) {
            return ((IFrameworkBlock)block).getControllerModelName();
        }
        return null;
    }

    protected boolean renderAllTanksInItem(@Nullable Block block, int metadata) {
        if ((metadata & 0x10) == 16) {
            return MachinePart.values()[metadata & 0xF].hasTanks;
        }
        return true;
    }

    protected boolean renderOneTankInItem(@Nullable Block block, int metadata) {
        if ((metadata & 0x10) == 16) {
            return MachinePart.values()[metadata & 0xF].hasSingleTank;
        }
        return false;
    }
}

