/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.machine.afarm;

import crazypants.enderio.machine.SlotDefinition;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class SlotDefinitionAfarm
extends SlotDefinition {
    private final List<SLOT> slottypes = new ArrayList<SLOT>();
    private final Map<SLOT, Integer> minslots = new EnumMap<SLOT, Integer>(SLOT.class);
    private final Map<SLOT, Integer> maxslots = new EnumMap<SLOT, Integer>(SLOT.class);

    public SlotDefinitionAfarm(int num_control_slots, int num_control_storage_slots, int num_seed_ghost_slots, int num_seed_storage_slots, int num_output_slots, int num_tool_slots, int num_fertilizer_slots, int num_cropstick_slots, int num_upgrade_slots) {
        super(num_control_storage_slots + num_seed_storage_slots + num_tool_slots + num_fertilizer_slots + num_cropstick_slots, num_output_slots, num_upgrade_slots);
        this.addSlot(SLOT.CONTROL_STORAGE, num_control_storage_slots);
        this.addSlot(SLOT.SEED, num_seed_storage_slots);
        this.addSlot(SLOT.TOOL, num_tool_slots);
        this.addSlot(SLOT.FERTILIZER, num_fertilizer_slots);
        this.addSlot(SLOT.CROPSTICK, num_cropstick_slots);
        this.addSlot(SLOT.OUTPUT, num_output_slots);
        this.addSlot(SLOT.UPGRADE, num_upgrade_slots);
        this.addSlot(SLOT.CONTROL, num_control_slots);
        this.addSlot(SLOT.SEED_GHOST, num_seed_ghost_slots);
    }

    private void addSlot(SLOT slottype, int num_slots) {
        this.minslots.put(slottype, this.slottypes.size());
        for (int i = 1; i <= num_slots; ++i) {
            this.slottypes.add(slottype);
        }
        this.maxslots.put(slottype, this.slottypes.size() - 1);
    }

    public int getNumSlots() {
        return this.slottypes.size();
    }

    public boolean isSlot(SLOT slottype, int slotno) {
        return this.slottypes.get(slotno) == slottype;
    }

    public SLOT getSlotType(int slotno) {
        return this.slottypes.get(slotno);
    }

    public int getMinSlot(SLOT slottype) {
        return this.minslots.get((Object)slottype);
    }

    public int getMaxSlot(SLOT slottype) {
        return this.maxslots.get((Object)slottype);
    }

    public static enum SLOT {
        CONTROL,
        CONTROL_STORAGE,
        SEED,
        SEED_GHOST,
        OUTPUT,
        TOOL,
        FERTILIZER,
        CROPSTICK,
        UPGRADE;

    }
}

