/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.enderioaddons.config;

import info.loenwind.enderioaddons.config.Section;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public enum Config {
    drainContinuousEnergyUseRF(Section.DRAIN, 10, "The amount of power used by a (food) drain per tick", true, false),
    drainPerBucketEnergyUseRF(Section.DRAIN, 400, "The amount of power used by a (food) drain per 1000mB of liquid collected"),
    drainPerSourceBlockMoveEnergyUseRF(Section.DRAIN, 250, "The amount of power used by a (food) drain to move a source block by one mete."),
    drainAllowOnDedicatedServer(Section.DRAIN, false, "Allow the use of the drain on a dedicated server. This does not effect the food drain", true, true),
    drainEnabled(Section.RECIPES, true, "Enable the crafting recipe for the drain", true, true),
    foodDrainCollectsMilkFromCows(Section.DRAIN, true, "Allows the food drain to collect milk from cows."),
    foodDrainCollectsFlowingMilk(Section.DRAIN, true, "Allows the food drain to pick up flowing milk."),
    foodDrainRange(Section.DRAIN, 3.0, "Distance from the food drain that is searched for cows."),
    foodDrainEnabled(Section.RECIPES, true, "Enable the crafting recipe for the food drain", true, true),
    cobbleWorksRfPerCobblestone(Section.COBBLEWORKS, 100, "RF used per generated cobblestone", true, false),
    cobbleWorksRfDiscountForCrafting(Section.COBBLEWORKS, 10, "Discount on the RF cost of crafting operations in percent (0-100)"),
    cobbleWorksRfDiscountForSmelting(Section.COBBLEWORKS, 10, "Discount on the RF cost of smelting operations in percent (0-100)"),
    cobbleWorksRfDiscountForCrushing(Section.COBBLEWORKS, 10, "Discount on the RF cost of crusing (sagmilling) operations in percent (0-100)"),
    cobbleWorksRfDiscountPerUpgrade(Section.COBBLEWORKS, 10, "Discount on the RF cost of any operation in percent (0-100). This discount is applied once for a double-layer capacitor and twice for an octadic capacitor upgrade."),
    cobbleWorksEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Cobbleworks", true, true),
    waterWorksWaterReductionPercentage(Section.WATERWORKS, 10, "Amount of liquid produced when processing in percent (0-100) of the input liquid", true, false),
    waterWorksRFperTask1(Section.WATERWORKS, 2000.0, "RF per task (machine with no capacitor upgrades)", true, false),
    waterWorksRFperTask2(Section.WATERWORKS, 3150.0, "RF per task (machine with first capacitor upgrade)", true, false),
    waterWorksRFperTask3(Section.WATERWORKS, 4800.0, "RF per task (machine with second capacitor upgrade)", true, false),
    waterWorksLiquidFactorperTask1(Section.WATERWORKS, 1.0, "Amount of input liquid consumed per task as factor on the base value of 1000mB (machine with no capacitor upgrades)", true, false),
    waterWorksLiquidFactorperTask2(Section.WATERWORKS, 1.75, "Amount of input liquid consumed per task as factor on the base value of 1000mB (machine with first capacitor upgrade)", true, false),
    waterWorksLiquidFactorperTask3(Section.WATERWORKS, 3.0, "Amount of input liquid consumed per task as factor on the base value of 1000mB (machine with second capacitor upgrade)", true, false),
    waterWorksRFusePerTick1(Section.WATERWORKS, 20, "RF a machine can use per tick (machine with no capacitor upgrades)", true, false),
    waterWorksRFusePerTick2(Section.WATERWORKS, 40, "RF a machine can use per tick (machine with first capacitor upgrade)", true, false),
    waterWorksRFusePerTick3(Section.WATERWORKS, 60, "RF a machine can use per tick (machine with second capacitor upgrade)", true, false),
    waterWorksRFinPerTick1(Section.WATERWORKS, 100, "RF a machine can accept per tick (machine with no capacitor upgrades)", true, false),
    waterWorksRFinPerTick2(Section.WATERWORKS, 200, "RF a machine can accept per tick (machine with first capacitor upgrade)", true, false),
    waterWorksRFinPerTick3(Section.WATERWORKS, 800, "RF a machine can accept per tick (machine with second capacitor upgrade)", true, false),
    waterWorksEnabled(Section.RECIPES, false, "Enable the crafting recipe for the Waterworks", true, true),
    impulseHopperRFusePerOperation(Section.IHOPPER, 16, "RF use per operation (regardless of its outcome)"),
    impulseHopperRFusePerItem(Section.IHOPPER, 1.0, "RF use per transfered item"),
    impulseHopperWorkEveryTick1(Section.IHOPPER, 20, "How many ticks does it take to execute one operation (machine with no capacitor upgrades)"),
    impulseHopperWorkEveryTick2(Section.IHOPPER, 10, "How many ticks does it take to execute one operation (machine with first capacitor upgrade)"),
    impulseHopperWorkEveryTick3(Section.IHOPPER, 4, "How many ticks does it take to execute one operation (machine with second capacitor upgrade)"),
    impulseHopperEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Impulse Hopper", true, true),
    niardContinuousEnergyUseRF(Section.NIARD, 10, "The amount of power used by a niard per tick.", true, false),
    niardPerBucketEnergyUseRF(Section.NIARD, 400, "The amount of power used by a niard per 1000mB of liquid placed into the world."),
    niardAllowWaterInHell(Section.NIARD, false, "Is the Niard allowed to place water in the Nether?"),
    niardEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Niard", true, true),
    voidTankContinuousEnergyUseRF1(Section.VOIDTANK, 10, "The amount of power used by a Portal Tank per tick (machine with no capacitor upgrades)", true, false),
    voidTankContinuousEnergyUseRF2(Section.VOIDTANK, 100, "The amount of power used by a Portal Tank per tick (machine with first capacitor upgrade)", true, false),
    voidTankContinuousEnergyUseRF3(Section.VOIDTANK, 10000, "The amount of power used by a Portal Tank per tick (machine with second capacitor upgrade)", true, false),
    voidTankEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Portal Tank", true, true),
    pMonEnableDynamicTextures(Section.PMON, true, "Enable dynamic texture updating for the Graphical Power Monitor. Disabling this also reduces network trafic"),
    pMonEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Graphical Power Monitor", true, true),
    tcomRecyclingLossFix(Section.TCOM, 0.25, "Fix loss of recycling in the Loot Recycler (0-1)", true, false),
    tcomRecyclingLossChanced(Section.TCOM, 0.5, "Chance based loss of recycling in the Loot Recycler (0-1)", true, false),
    tcomRecyclingPowerPerTick(Section.TCOM, 10, "RF/tick for recycling in the Loot Recycler", true, false),
    tcomRecyclingTicksPerItem(Section.TCOM, 45, "Ticks for recycling one item in the Loot Recycler (Note: Sound plays for 45 ticks)"),
    tcomExtractingPowerPerItem(Section.TCOM, 10, "RF for extracting one recycled item from the Loot Recycler"),
    tcomEnchantingPowerPerTick(Section.TCOM, 125, "RF/tick for enchanting in the Loot Recycler", true, false),
    tcomEnchantingTicksPerItem(Section.TCOM, 80, "Ticks for enchanting one item in the Loot Recycler"),
    tcomEnchantingPowerPerFailure(Section.TCOM, 1250, "RF wasted on failing to enchant in the Loot Recycler"),
    tcomPowerIntakePerTick(Section.TCOM, 100, "RF/tick the Loot Recycler can take", true, false),
    tcomEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Loot Recycler", true, true),
    magcMagnetizingPowerPerTick(Section.MAGCHARGER, 10, "RF/tick for magnetizing in the Magnetic Charger", true, false),
    magcMagnetizingTicksPerItem(Section.MAGCHARGER, 20, "Ticks for magnetizing one item in the Magnetic Charger (Note: Sound plays for 20 ticks)"),
    magcPowerIntakePerTick(Section.MAGCHARGER, 100, "RF/tick the Magnetic Charger can take", true, false),
    magcEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Magnetic Charger", true, true),
    flagDemagnetizingChance(Section.FLAG, 0.04, "Chance that a Magnetic Flag demagnetizes when broken (0-1)"),
    flagKeepTargetOnBreaking(Section.FLAG, false, "Should Magnetic Flags keep their target when being broken?"),
    flagEnabled(Section.RECIPES, true, "Enable the crafting recipe for the Magnetic Flag", true, true),
    decoBlockInvisibleIsInvisible(Section.DECO, true, "Allow the invisible block to be invisible. Otherwise it will mimic a quite clear glass block.", true, false),
    decoBlockEnabled(Section.RECIPES, true, "Enable the crafting recipe for the decoration block", true, true),
    farmNO_POWEREnabled(Section.FARM_NOTIF, true, "Enable the notification NO_POWER"),
    farmNO_HOEEnabled(Section.FARM_NOTIF, true, "Enable the notification NO_HOE"),
    farmNO_RAKEEnabled(Section.FARM_NOTIF, true, "Enable the notification NO_RAKE"),
    farmNO_CROPSEnabled(Section.FARM_NOTIF, true, "Enable the notification NO_CROPS"),
    farmNO_SEEDSEnabled(Section.FARM_NOTIF, true, "Enable the notification NO_SEEDS"),
    farmNO_FERTILIZEREnabled(Section.FARM_NOTIF, false, "Enable the notification NO_FERTILIZER"),
    farmFULLEnabled(Section.FARM_NOTIF, true, "Enable the notification FULL"),
    farmWEEDSEnabled(Section.FARM_NOTIF, true, "Enable the notification WEEDS"),
    farmOFFLINEEnabled(Section.FARM_NOTIF, true, "Enable the notification OFFLINE"),
    ghostItemsEnabled(Section.VISUALS, true, "Enable item ghosts in the GUI"),
    directDrawingEnabled(Section.VISUALS, true, "Allow openGL drawing without tesselator. Disable this if certain machines don't render. Be prepared for texture mapping errors when this is off."),
    rotationInItemframesEnabled(Section.VISUALS, true, "Blocks rotate when placed in an item frame"),
    farmBreaksWoodenRakesEnabled(Section.FARM, true, "If enabled, the farming station can break wooden hand rakes"),
    farmBreaksIronRakesEnabled(Section.FARM, true, "If enabled, the farming station can break iron hand rakes"),
    farmBreaksWoodenRakesChance(Section.FARM, 0.0033333333333333335, "Chance that a farming station breaks a wooden hand rake (0-1)"),
    farmBreaksIronRakesChance(Section.FARM, 0.0011111111111111111, "Chance that a farming station breaks a wooden hand rake (0-1)"),
    farmRFperTickPerArea(Section.FARM, 2.5, "RF used per tick per 'ring' of farmland", true, false),
    farmRFperTickPerModule(Section.FARM, 5.0, "RF used per tick per installed module", true, false),
    farmRFperAnalyzing(Section.FARM, 1000, "RF used when analyzing a seed"),
    farmRFperCrops(Section.FARM, 100, "RF used when placing down crop sticks"),
    farmRFperCrossCrops(Section.FARM, 100, "RF used when placing down cross crop sticks"),
    farmRFperFertilize(Section.FARM, 750, "RF used when fertilizing a plant"),
    farmRFperHarvest(Section.FARM, 200, "RF used when harvest produce"),
    farmRFperPlant(Section.FARM, 2000, "RF used when planting a seed"),
    farmRFperRaking(Section.FARM, 100, "RF used when raking with a hand rake"),
    farmRFperRakingIndustrial(Section.FARM, 200, "RF used when raking with an industrial rake"),
    farmRFperSeedHarvest(Section.FARM, 500, "RF used when removing a plant to get back seeds, crop sticks and potentially harvest"),
    farmRFperTill(Section.FARM, 2000, "RF used when tilling a block"),
    farmArea1(Section.FARM, 3, "'Rings' of farmland a farm with no capacitor upgrades will work", true, false),
    farmArea2(Section.FARM, 5, "'Rings' of farmland a farm with first capacitor upgrade will work", true, false),
    farmArea3(Section.FARM, 9, "'Rings' of farmland a farm with second capacitor upgrade will work", true, false),
    farmDelay1(Section.FARM, 20, "Number of ticks it takes a farm with no capacitor upgrades to work one tile of land"),
    farmDelay2(Section.FARM, 10, "Number of ticks it takes a farm with first capacitor upgrade to work one tile of land"),
    farmDelay3(Section.FARM, 3, "Number of ticks it takes a farm with second capacitor upgrade to work one tile of land"),
    seedsRFperGrowthTick(Section.FARM, 100000, "RF it takes the Capacitor Plant to try to grow"),
    seedsTierEasy(Section.FARM, 3, "Tier of the Capacitor seeds when 'easy recipes' are selected"),
    seedsTierHard(Section.FARM, 5, "Tier of the Capacitor seeds when 'hard recipes' are selected"),
    farmSeedlessRecipesEnabled(Section.FARM, false, "If enabled there will be recipes for the farm that don't require you to grow capacitor plants. I call it cheat mode", true, true),
    seedRecipesEnabled(Section.FARM, true, "If disabled there will be no recipe to craft capacitor plant seeds and no recipes to use the fruits of the capacitor plant. The seeds may still be generated as random loot by AgriCraft", true, true),
    plantDropsLowGain(Section.FARM, "enderioaddons:itemMachineParts@23=13500, EnderIO:itemBasicCapacitor@0=10, EnderIO:itemBasicCapacitor@1=5, EnderIO:itemBasicCapacitor@2=1", "A list of items with weights that will be dropped by the capacitor plant when harvested. Plants with a gain of 1-2 will drop one item from this list, plants with a gain of 3-10 will drop 2."),
    plantDropsHighGain(Section.FARM, "enderioaddons:itemMachineParts@23=10000, enderioaddons:itemMachineParts@24=3000, enderioaddons:itemMachineParts@25=500, EnderIO:itemBasicCapacitor@0=10, EnderIO:itemBasicCapacitor@1=5, EnderIO:itemBasicCapacitor@2=1", "A list of items with weights that will be dropped by the capacitor plant when harvested. Plants with a gain of 6-9 will drop one item from this list, plants with a gain of 10 will drop 2."),
    plantRequiredBlocks(Section.FARM, "EnderIO:blockCapBank@1, minecraft:bedrock@-1, EnderIO:blockDarkIronBars@-1", "Three items that define the soil, block under soil and block around for the capacitor plant. Please note that this are item IDs, not block IDs, but block meta values. The blocks for these item will be looked up as ususal.", true, true),
    seedsAutomaticHarvestingEnabled(Section.FARM, false, "If enabled Capacitor Plants can be harvested with machines. I call it couch potato mode"),
    seedsBonemealEnabled(Section.FARM, false, "If enabled Capacitor Plants can be fertilized with bonemeal."),
    farmAggressiveTillingDefault(Section.FARM, true, "The initial value of 'till agressively' for newly placed farms"),
    farmDebugLoggingEnabled(Section.FARM, false, "When enabled, the farm will write extensive information about its operation into the logfile"),
    farmEnabled(Section.RECIPES, true, "Enable the crafting recipe for the AgriCraft farming station (will only work if AgriCraft is installed)", true, true),
    flowingMilkCuresPoison(Section.LIQUIDS, 0.001, "Chance that flowing milk will cure poison (applies once per tick)"),
    sourceMilkIsConsumedWhenCuringPoison(Section.LIQUIDS, 0.25, "Chance that a source block of milk will be consumed when curing poison"),
    fortuneCookiesEnabled(Section.RECIPES, true, "When enabled, the fortune cookies will be visible ingame"),
    fortuneCookiesCraftingEnabled(Section.RECIPES, true, "When enabled, the fortune cookies will have a crafting recipe", true, true),
    leversEnabled(Section.RECIPES, "10,30,60,300", "A comma-seperated list of durations in seconds. For these, self-reseting levers will be created. Set to 0 to disable the lever", true, true),
    profilingEnabled(Section.DEV, false, "When enabled, profiling information will be written into the logfile"),
    growthRequirementDebuggingEnabled(Section.DEV, false, "When enabled, growth requirement data will be written into the logfile");

    @Nonnull
    private final Section section;
    @Nonnull
    private final Object defaultValue;
    @Nonnull
    private final String description;
    @Nonnull
    private Object currentValue;
    private final boolean requiresWorldRestart;
    private final boolean requiresGameRestart;

    private Config(@Nonnull Section section, Object defaultValue, String description, boolean requiresWorldRestart, boolean requiresGameRestart) {
        this.section = section;
        this.description = description;
        this.currentValue = this.defaultValue = defaultValue;
        this.requiresWorldRestart = requiresWorldRestart;
        this.requiresGameRestart = requiresGameRestart;
    }

    private Config(@Nonnull Section section, Integer defaultValue, String description, boolean requiresWorldRestart, boolean requiresGameRestart) {
        this(section, (Object)defaultValue, description, requiresWorldRestart, requiresGameRestart);
    }

    private Config(@Nonnull Section section, Double defaultValue, String description, boolean requiresWorldRestart, boolean requiresGameRestart) {
        this(section, (Object)defaultValue, description, requiresWorldRestart, requiresGameRestart);
    }

    private Config(@Nonnull Section section, Boolean defaultValue, String description, boolean requiresWorldRestart, boolean requiresGameRestart) {
        this(section, (Object)defaultValue, description, requiresWorldRestart, requiresGameRestart);
    }

    private Config(@Nonnull Section section, String defaultValue, String description, boolean requiresWorldRestart, boolean requiresGameRestart) {
        this(section, (Object)defaultValue, description, requiresWorldRestart, requiresGameRestart);
    }

    private Config(@Nonnull Section section, Integer defaultValue, String description) {
        this(section, (Object)defaultValue, description, false, false);
    }

    private Config(@Nonnull Section section, Double defaultValue, String description) {
        this(section, (Object)defaultValue, description, false, false);
    }

    private Config(@Nonnull Section section, Boolean defaultValue, String description) {
        this(section, (Object)defaultValue, description, false, false);
    }

    private Config(@Nonnull Section section, String defaultValue, String description) {
        this(section, (Object)defaultValue, description, false, false);
    }

    void load(Configuration config) {
        Object value = null;
        if (this.defaultValue instanceof Integer) {
            value = this.setPropertyData(config.get(this.section.name, this.name(), ((Integer)this.defaultValue).intValue(), this.description)).getInt(((Integer)this.defaultValue).intValue());
        } else if (this.defaultValue instanceof Double) {
            value = this.setPropertyData(config.get(this.section.name, this.name(), ((Double)this.defaultValue).doubleValue(), this.description)).getDouble(((Double)this.defaultValue).doubleValue());
        } else if (this.defaultValue instanceof Boolean) {
            value = this.setPropertyData(config.get(this.section.name, this.name(), ((Boolean)this.defaultValue).booleanValue(), this.description)).getBoolean(((Boolean)this.defaultValue).booleanValue());
        } else if (this.defaultValue instanceof String) {
            value = this.setPropertyData(config.get(this.section.name, this.name(), (String)this.defaultValue, this.description)).getString();
        }
        this.setField(value);
    }

    private Property setPropertyData(Property property) {
        property.setRequiresWorldRestart(this.requiresWorldRestart);
        property.setRequiresMcRestart(this.requiresGameRestart);
        return property;
    }

    private void setField(Object value) {
        if (value != null) {
            this.currentValue = value;
        }
    }

    void store(ByteBuf buf) {
        if (this.defaultValue instanceof Integer) {
            buf.writeInt(this.getInt());
        } else if (this.defaultValue instanceof Double) {
            buf.writeDouble(this.getDouble());
        } else if (this.defaultValue instanceof Boolean) {
            buf.writeBoolean(this.getBoolean());
        } else if (this.defaultValue instanceof String) {
            String value = this.getString();
            byte[] bytes = value.getBytes(Charset.forName("UTF-8"));
            buf.writeInt(bytes.length);
            buf.writeBytes(bytes);
        }
    }

    void read(ByteBuf buf) {
        Object value = null;
        if (this.defaultValue instanceof Integer) {
            value = buf.readInt();
        } else if (this.defaultValue instanceof Double) {
            value = buf.readDouble();
        } else if (this.defaultValue instanceof Boolean) {
            value = buf.readBoolean();
        } else if (this.defaultValue instanceof String) {
            int len = buf.readInt();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes, 0, len);
            value = new String(bytes, Charset.forName("UTF-8"));
        }
        this.setField(value);
    }

    protected void resetToDefault() {
        this.setField(this.defaultValue);
    }

    public Section getSection() {
        return this.section;
    }

    public int getDefaultInt() {
        if (this.defaultValue instanceof Integer) {
            return (Integer)this.defaultValue;
        }
        if (this.defaultValue instanceof Double) {
            return ((Double)this.defaultValue).intValue();
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.defaultValue != false ? 1 : 0;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    public double getDefaultDouble() {
        if (this.defaultValue instanceof Integer) {
            return ((Integer)this.defaultValue).intValue();
        }
        if (this.defaultValue instanceof Double) {
            return (Double)this.defaultValue;
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.defaultValue != false ? 1.0 : 0.0;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    public float getDefaultFloat() {
        if (this.defaultValue instanceof Integer) {
            return ((Integer)this.defaultValue).intValue();
        }
        if (this.defaultValue instanceof Double) {
            return ((Double)this.defaultValue).floatValue();
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.defaultValue != false ? 1.0f : 0.0f;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    public boolean getDefaultBoolean() {
        if (this.defaultValue instanceof Integer) {
            throw new DataTypeErrorInConfigException();
        }
        if (this.defaultValue instanceof Double) {
            throw new DataTypeErrorInConfigException();
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.defaultValue;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    @Nonnull
    public String getDefaultString() {
        if (this.defaultValue instanceof Integer) {
            return ((Integer)this.defaultValue).toString();
        }
        if (this.defaultValue instanceof Double) {
            return ((Double)this.defaultValue).toString();
        }
        if (this.defaultValue instanceof Boolean) {
            return ((Boolean)this.defaultValue).toString();
        }
        if (this.defaultValue instanceof String) {
            return (String)this.defaultValue;
        }
        throw new DataTypeErrorInConfigException();
    }

    public int getInt() {
        if (this.defaultValue instanceof Integer) {
            return (Integer)this.currentValue;
        }
        if (this.defaultValue instanceof Double) {
            return ((Double)this.currentValue).intValue();
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.currentValue != false ? 1 : 0;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    public double getDouble() {
        if (this.defaultValue instanceof Integer) {
            return ((Integer)this.currentValue).intValue();
        }
        if (this.defaultValue instanceof Double) {
            return (Double)this.currentValue;
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.currentValue != false ? 1.0 : 0.0;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    public float getFloat() {
        if (this.defaultValue instanceof Integer) {
            return ((Integer)this.currentValue).intValue();
        }
        if (this.defaultValue instanceof Double) {
            return ((Double)this.currentValue).floatValue();
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.currentValue != false ? 1.0f : 0.0f;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    public boolean getBoolean() {
        if (this.defaultValue instanceof Integer) {
            throw new DataTypeErrorInConfigException();
        }
        if (this.defaultValue instanceof Double) {
            throw new DataTypeErrorInConfigException();
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.currentValue;
        }
        if (this.defaultValue instanceof String) {
            throw new DataTypeErrorInConfigException();
        }
        throw new DataTypeErrorInConfigException();
    }

    @Nonnull
    public String getString() {
        if (this.defaultValue instanceof Integer) {
            return ((Integer)this.currentValue).toString();
        }
        if (this.defaultValue instanceof Double) {
            return ((Double)this.currentValue).toString();
        }
        if (this.defaultValue instanceof Boolean) {
            return ((Boolean)this.currentValue).toString();
        }
        if (this.defaultValue instanceof String) {
            return (String)this.currentValue;
        }
        throw new DataTypeErrorInConfigException();
    }

    private class DataTypeErrorInConfigException
    extends RuntimeException {
        private DataTypeErrorInConfigException() {
        }
    }
}

