/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.enderioaddons.common.NullHelper;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class Reader {
    public static <T> void read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound tag, @Nonnull T object) {
        try {
            StorableEngine.read(registry, phase, tag, object);
        }
        catch (NoHandlerFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void read(@Nullable Set<Store.StoreFor> phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, NullHelper.notnull(phase, "Missing phase"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(@Nonnull Registry registry, @Nonnull Store.StoreFor phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(registry, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(@Nonnull Store.StoreFor phase, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.of(phase), "EnumSet.of()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(@Nonnull Registry registry, @Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(registry, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.allOf(Store.StoreFor.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }

    public static <T> void read(@Nullable NBTTagCompound tag, @Nonnull T object) {
        Reader.read(Registry.GLOBAL_REGISTRY, (Set<Store.StoreFor>)NullHelper.notnullJ(EnumSet.allOf(Store.StoreFor.class), "EnumSet.allOf()"), NullHelper.notnull(tag, "Missing NBT"), object);
    }
}

