/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui.element;

import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import com.pahimar.repackage.cofh.lib.gui.GuiColor;
import com.pahimar.repackage.cofh.lib.gui.element.ElementBase;
import com.pahimar.repackage.cofh.lib.gui.element.listbox.IListBoxElement;
import com.pahimar.repackage.cofh.lib.util.helpers.StringHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class ElementListBox
extends ElementBase {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    private final int _marginTop = 2;
    private final int _marginLeft = 2;
    private final int _marginRight = 2;
    private final int _marginBottom = 2;
    private final List<IListBoxElement> _elements = new LinkedList<IListBoxElement>();
    private int _firstIndexDisplayed;
    private int _selectedIndex;
    private int scrollHoriz;

    public ElementListBox(GuiBase containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height);
    }

    public void add(IListBoxElement element) {
        this._elements.add(element);
    }

    public void add(Collection<? extends IListBoxElement> elements) {
        this._elements.addAll(elements);
    }

    public void remove(IListBoxElement element) {
        this._elements.remove(element);
    }

    public void removeAt(int index) {
        this._elements.remove(index);
    }

    public int getInternalWidth() {
        int width = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            width = Math.max(this._elements.get(i).getWidth(), width);
        }
        return width;
    }

    public int getInternalHeight() {
        int height = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            height += this._elements.get(i).getHeight();
        }
        return height;
    }

    public int getContentWidth() {
        return this.sizeX - 2 - 2;
    }

    public int getContentHeight() {
        return this.sizeY - 2 - 2;
    }

    public int getContentTop() {
        return this.posY + 2;
    }

    public int getContentLeft() {
        return this.posX + 2;
    }

    public final int getContentBottom() {
        return this.getContentTop() + this.getContentHeight();
    }

    public final int getContentRight() {
        return this.getContentLeft() + this.getContentWidth();
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.drawModalRect(this.posX - 1, this.posY - 1, this.posX + this.sizeX + 1, this.posY + this.sizeY + 1, this.borderColor);
        this.drawModalRect(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, this.backgroundColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int heightDrawn = 0;
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glEnable((int)2960);
        GL11.glClear((int)1024);
        this.drawStencil(this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        GL11.glTranslated((double)(-this.scrollHoriz), (double)0.0, (double)0.0);
        int e = this._elements.size();
        for (int nextElement = this._firstIndexDisplayed; nextElement < e && heightDrawn <= this.getContentHeight(); heightDrawn += this._elements.get(nextElement).getHeight(), ++nextElement) {
            if (nextElement == this._selectedIndex) {
                this._elements.get(nextElement).draw(this, this.getContentLeft(), this.getContentTop() + heightDrawn, this.selectedLineColor, this.selectedTextColor);
                continue;
            }
            this._elements.get(nextElement).draw(this, this.getContentLeft(), this.getContentTop() + heightDrawn, this.backgroundColor, this.textColor);
        }
        GL11.glDisable((int)2960);
        GL11.glPopMatrix();
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        int elementHeight;
        int heightChecked = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && heightChecked <= this.getContentHeight(); heightChecked += elementHeight, ++i) {
            elementHeight = this._elements.get(i).getHeight();
            if (this.getContentTop() + heightChecked > mouseY || this.getContentTop() + heightChecked + elementHeight < mouseY) continue;
            this.setSelectedIndex(i);
            this.onElementClicked(this._elements.get(i));
            break;
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (StringHelper.isControlKeyDown()) {
            if (movement > 0) {
                this.scrollLeft();
            } else if (movement < 0) {
                this.scrollRight();
            }
        } else if (movement > 0) {
            this.scrollUp();
        } else if (movement < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int heightDisplayed = 0;
        int elementsDisplayed = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && heightDisplayed + this._elements.get(i).getHeight() <= this.sizeY; ++i) {
            heightDisplayed += this._elements.get(i).getHeight();
            ++elementsDisplayed;
        }
        if (this._firstIndexDisplayed + elementsDisplayed < this._elements.size()) {
            ++this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollLeft() {
        this.scrollHoriz = Math.max(this.scrollHoriz - 15, 0);
        this.onScrollH(this.scrollHoriz);
    }

    public void scrollRight() {
        this.scrollHoriz = Math.min(this.scrollHoriz + 15, this.getLastScrollPositionH());
        this.onScrollH(this.scrollHoriz);
    }

    public int getLastScrollPosition() {
        int position = this._elements.size() - 1;
        for (int heightUsed = this._elements.get(position).getHeight(); position > 0 && heightUsed < this.sizeY; heightUsed += this._elements.get(--position).getHeight()) {
        }
        return position + 1;
    }

    public int getLastScrollPositionH() {
        return Math.max(this.getInternalWidth() - this.getContentWidth(), 0);
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getIndexOf(Object value) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!this._elements.get(i).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        return this._elements.get(this._selectedIndex);
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this._elements.size() && index != this._selectedIndex) {
            this._selectedIndex = index;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int index) {
        return this._elements.get(index);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    public void scrollToV(int index) {
        if (index >= 0 && index < this._elements.size()) {
            this._firstIndexDisplayed = index;
        }
    }

    public void scrollToH(int index) {
        if (index >= 0 && index <= this.getLastScrollPositionH()) {
            this.scrollHoriz = index;
        }
    }

    protected void onElementClicked(IListBoxElement element) {
    }

    protected void onScrollV(int newStartIndex) {
    }

    protected void onScrollH(int newStartIndex) {
    }

    protected void onSelectionChanged(int newIndex, IListBoxElement newElement) {
    }
}

