/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util.serialize;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.knowledge.PlayerKnowledge;
import com.pahimar.ee3.reference.Comparators;
import java.lang.reflect.Type;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;

public class PlayerKnowledgeSerializer
implements JsonSerializer<PlayerKnowledge>,
JsonDeserializer<PlayerKnowledge> {
    public PlayerKnowledge deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        TreeSet<ItemStack> knownItemStacks = new TreeSet<ItemStack>(Comparators.ID_COMPARATOR);
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                if (!jsonElement.isJsonObject()) continue;
                WrappedStack wrappedStack = null;
                try {
                    wrappedStack = (WrappedStack)context.deserialize(jsonElement, WrappedStack.class);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
                if (wrappedStack == null || !(wrappedStack.getWrappedObject() instanceof ItemStack)) continue;
                knownItemStacks.add((ItemStack)wrappedStack.getWrappedObject());
            }
        }
        return new PlayerKnowledge(knownItemStacks);
    }

    public JsonElement serialize(PlayerKnowledge src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        if (src != null) {
            for (ItemStack itemStack : src.getKnownItemStacks()) {
                jsonArray.add(context.serialize((Object)WrappedStack.wrap(itemStack)));
            }
        }
        return jsonArray;
    }
}

