/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.reference.Comparators;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;

public class FilterUtils {
    public static Set<ItemStack> filterByDisplayName(Set<ItemStack> itemStacks, String filterString) {
        return FilterUtils.filterByDisplayName(itemStacks, filterString, NameFilterType.STARTS_WITH, null);
    }

    public static Set<ItemStack> filterByDisplayName(Set<ItemStack> itemStacks, String filterString, NameFilterType filterType) {
        return FilterUtils.filterByDisplayName(itemStacks, filterString, filterType, null);
    }

    public static Set<ItemStack> filterByDisplayName(Collection<ItemStack> itemStacks, String filterString, NameFilterType filterType, Comparator comparator) {
        TreeSet<ItemStack> filteredSet;
        TreeSet<ItemStack> treeSet = filteredSet = comparator != null ? new TreeSet<ItemStack>(comparator) : new TreeSet<ItemStack>(Comparators.DISPLAY_NAME_COMPARATOR);
        if (itemStacks != null) {
            if (filterString == null || filterString.isEmpty()) {
                filteredSet.addAll(itemStacks);
            } else {
                for (ItemStack itemStack : itemStacks) {
                    String itemDisplayName = itemStack.func_82833_r().toLowerCase();
                    if (filterType == NameFilterType.STARTS_WITH && itemDisplayName.startsWith(filterString.toLowerCase())) {
                        filteredSet.add(itemStack);
                        continue;
                    }
                    if (filterType != NameFilterType.CONTAINS || !itemDisplayName.contains(filterString.toLowerCase())) continue;
                    filteredSet.add(itemStack);
                }
            }
        }
        return filteredSet;
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> itemStacks, Number valueBound) {
        return FilterUtils.filterByEnergyValue(itemStacks, new EnergyValue(Float.valueOf(valueBound.floatValue())), ValueFilterType.VALUE_LOWER_THAN_BOUND, null);
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> itemStacks, EnergyValue valueBound) {
        return FilterUtils.filterByEnergyValue(itemStacks, valueBound, ValueFilterType.VALUE_LOWER_THAN_BOUND, null);
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> itemStacks, Number valueBound, ValueFilterType filterType) {
        return FilterUtils.filterByEnergyValue(itemStacks, new EnergyValue(Float.valueOf(valueBound.floatValue())), filterType, null);
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> itemStacks, EnergyValue valueBound, ValueFilterType filterType) {
        return FilterUtils.filterByEnergyValue(itemStacks, valueBound, filterType, null);
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> itemStacks, Number valueBound, ValueFilterType filterType, Comparator comparator) {
        return FilterUtils.filterByEnergyValue(EnergyValueRegistry.INSTANCE.getEnergyValues(), itemStacks, new EnergyValue(Float.valueOf(valueBound.floatValue())), filterType, comparator);
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> itemStacks, EnergyValue valueBound, ValueFilterType filterType, Comparator comparator) {
        return FilterUtils.filterByEnergyValue(EnergyValueRegistry.INSTANCE.getEnergyValues(), itemStacks, valueBound, filterType, comparator);
    }

    public static Set<ItemStack> filterByEnergyValue(Map<WrappedStack, EnergyValue> valueMap, Collection<ItemStack> itemStacks, EnergyValue valueBound, ValueFilterType filterType, Comparator comparator) {
        TreeSet<ItemStack> filteredSet;
        TreeSet<ItemStack> treeSet = filteredSet = comparator != null ? new TreeSet<ItemStack>(comparator) : new TreeSet<ItemStack>(Comparators.DISPLAY_NAME_COMPARATOR);
        if (itemStacks != null) {
            if (valueBound == null) {
                filteredSet.addAll(itemStacks);
            } else {
                for (ItemStack itemStack : itemStacks) {
                    EnergyValue energyValue = EnergyValueRegistry.getEnergyValue(valueMap, itemStack, false);
                    if (energyValue == null || Float.compare(energyValue.getValue(), 0.0f) <= 0) continue;
                    if (filterType == ValueFilterType.VALUE_LOWER_THAN_BOUND && energyValue.compareTo(valueBound) <= 0) {
                        filteredSet.add(itemStack);
                        continue;
                    }
                    if (filterType != ValueFilterType.VALUE_GREATER_THAN_BOUND || energyValue.compareTo(valueBound) < 0) continue;
                    filteredSet.add(itemStack);
                }
            }
        }
        return filteredSet;
    }

    public static Collection<ItemStack> filterForItemStacks(Collection<?> objects) {
        TreeSet<ItemStack> itemStacks = new TreeSet<ItemStack>(Comparators.ID_COMPARATOR);
        for (Object object : objects) {
            if (!(object instanceof ItemStack)) continue;
            itemStacks.add((ItemStack)object);
        }
        return itemStacks;
    }

    public static enum ValueFilterType {
        VALUE_GREATER_THAN_BOUND,
        VALUE_LOWER_THAN_BOUND;

    }

    public static enum NameFilterType {
        STARTS_WITH,
        CONTAINS;

    }
}

